# ***Fancm*** regulates meiotic double-strand break repair pathway choice in mammals

This repository hosts the code and scripts for processing and analyzing the bulk sequenced (***Fancm***-KO and wildtype) mice as well as single sperm DNA sequencing of male (***Fancm***-KO and wildtype) mice to study the regulation of ***Fancm*** on meiotic crossover.  

bioRxiv [manuscript](https://www.biorxiv.org/content/10.1101/2022.06.16.496499v1)


# Snakemake workflows

The preprocessing of raw sequencing files, alignment, and variant calling for all samples was done by using pipelines formed using snakemake.

# Raw data availability

The raw fastq files for all bulk DNA sample (BC1F1) and single sperm cells from 6 male mice are available at ENA with project accession PRJEB57095. 

# Preprocessing 

## High depth sequencing of reference samples
Sample 20 (FVB), sample 424 (F1), and sample 427 (F1) were seqeunced with 20-30X coverage. The allele reads ratios across the SNPs from these samples were used for estimating the expected alternative reads ratios for different genome backgrounds, which subsequently were used in the hidden Markov model for calling crossovers in the BC1F1 samples.

## BC1F1 samples

A total of 372 BC1F1 samples were processed and analyzed for crossover detection. Detailed commands can be found in the snakemake files: `bulkDNAseq_BGI.snk` `bulkDNAseq_agrf.snk` and `bulkDNAseq_BGI-extra.snk`.

## F1 single sperm sequencing

We ran the cellranger CNV pipeline for demultiplexing reads for each single sperm and mapping to the reference genome. Detailed commands can be found in the snakemake files: `10xCNV_2020-04-24.snk` and `10xCNV_2021-04-26.snk`. The aligned BAM file for each sample was processed by [sgcocaller](https://github.com/ruqianl/sgcocaller) for crossover inference using a hidden Markov model. 

## PCR-based genotyped BC1F1 samples

The genotype results of 58 samples were provided in excel sheets in `data/All_data_May_to_August_2019.xlsx`.

# Processed data

## Bulk BC1F1 rds file

`output/outputR/bc1f1_samples.rds`

## F1 single sperm samples rds file

`output/outputR/f1_sperm.rds`


# Analysis reports and figures generated 

https://biocellgen-public.svi.edu.au/fancm-crossovers-2022/index.html