# Condition-dependence of (un)predictability in escape behavior of a grasshopper species
---

In order to test the condition-dependence of (un)predictability, we exposed steppe grasshoppers *Chorthippus dorsatus* to an immune challengeand recorded the effect of the treatment on three escape behavior traits, in comparison to untreated individuals.


## Description of the data and file structure

The dataset consists of a text file with a total of 1163 observations and 12 columns, described below:

TrialID refers to each observation.

IndID refers to the identification number of each individual.

FID is the flight initiation distance in centimeters, defined as the minimum distance between the chaser and the grasshopper before the grasshopper jumped.

JumpDistance is the jump's length in centimeters, defined as the distance between the point where the jump started and where the grasshopper landed.

JumpAngle is the angle of the jump direction in degrees in relation to the initial grasshopper body position. Straight jumps scored 0ᵒ, while negative values marked jumps to the left, and positive values jumps to the right.

JumpOrder refers to the sequential number of jumps within the 10 trials of an individual.

JumpYN indicates if the grasshopper jumped or not during that trial (Y = jumped, N = didn't jump). 

Sex is coded as M for males and F for females.

Treatment refers whether an individual was from the control group (C) or if it received the immune challenge injection (T). See manuscript for details.

PhenotypingDate is the date when the experiment occurred (DD_MM_YYYY).

DayTime is coded as 24h, with the minutes converted to decimals (for example: 1:30 pm = 13.5).

PairID is the identification number of a pair of grasshoppers of same age and sex, kept in the same cage and phenotyped together, one assigned to the treatment group and the other to the control group.

Missing data is coded as NA.


## Sharing/Access information

Data and code for the analysis are also available at OSF.io
DOI: https://doi.org/10.17605/OSF.IO/98BE7 


