library(ggplot2)
library(dplyr)
library(reshape2)
library(stringr)
library(viridis)
library(colourvalues)

outputfull <- read.csv("output-ciep-full.csv",sep=",")
outputtreebanks <- read.csv("output-treebanks-full.csv",sep=",")

contrastive <- outputfull %>% select(language,determ_raw_entropy,quant_raw_entropy,art_pos_entropy,dem_pos_entropy,quant_pos_entropy,dem_lemma_entropy,art_lemma_entropy,quant_lemma_entropy,dem_lemma_entropy)

#Select raw entropies only
overview_plot1 <- contrastive %>% select(language,determ_raw_entropy,art_pos_entropy,quant_pos_entropy)
overview_plot1_l <- melt(overview_plot1)
axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)
ggplot(data=overview_plot1_l) +
   geom_point(size=4,mapping = aes(x = language , y = value, shape=variable)) +##
   theme_bw() +##
   theme(legend.position = "bottom", legend.text = element_text(face="bold"), axis.text.x = element_text(angle = 45)) +
   labs(title = "", y = "Shannon's entropy", x = "Language", fill = "\n") +
   scale_shape_manual(name="",values=c(8,5,3),labels = c("Rel: Determiners and Quantifiers","Rel+UPOS: article","Rel+UPOS: demonstrative and quantifier") )
   #scale_colour_manual(values = c("#440154FF","#FDE725FF"),name="",labels = c("UD Rel","UD Rel + UPOS"))
  ggsave("../plots/fig2.png")
  
  
#filter for dependency
#lemma_l <- lemma[which(lemma_f$language == "BCS" | lemma_f$language == "Bulgarian" | lemma_f$language == "Czech" | lemma_f$language == "Danish" | lemma_f$language == "Dutch" |lemma_f$language == "English" |lemma_f$language == "French" | lemma_f$language == "German" | lemma_f$language == "Irish" | lemma_f$language == "Lithuanian" |lemma_f$language == "Polish" |lemma_f$language == "Welsh" |lemma_f$language == "Greek" |lemma_f$language == "Portuguese" | lemma_f$language == "Romanian" | lemma_f$language == "Russian" | lemma_f$language == "Spanish"),]
overview_lemma <- contrastive %>% select(language,dem_lemma_entropy,art_lemma_entropy,quant_lemma_entropy)
overview_lemma_l <- melt(overview_lemma, id = c("language"))
ggplot(overview_lemma_l) +
   geom_point(size=4,mapping = aes(x = language , y = value, shape=variable)) +##
   theme_bw() +##
   #ylim(0,1) +
   theme(legend.position = "right", legend.text = element_text(face="bold"), axis.text.x = element_text(angle = 45)) +
   labs(title = "", y = "Shannon's entropy", x = "Language", fill = "\n") +
   scale_shape_manual(name="",values=c(6,7,10),labels = c("demonstrative", "article", "quantifier"))
   #scale_colour_manual(values = c("#77D153FF","#228D8DFF","#29AF7FFF"),name="",labels = c("Demonstrative","Article","Quantifier"))
ggsave("../plots/fig3.png")

contrastive <- outputtreebanks %>% select(language,determ_raw_entropy,quant_raw_entropy,art_pos_entropy,dem_pos_entropy,quant_pos_entropy,dem_lemma_entropy,art_lemma_entropy,quant_lemma_entropy,dem_lemma_entropy)

#filter for dependency
#lemma_l <- lemma[which(lemma_f$language == "BCS" | lemma_f$language == "Bulgarian" | lemma_f$language == "Czech" | lemma_f$language == "Danish" | lemma_f$language == "Dutch" |lemma_f$language == "English" |lemma_f$language == "French" | lemma_f$language == "German" | lemma_f$language == "Irish" | lemma_f$language == "Lithuanian" |lemma_f$language == "Polish" |lemma_f$language == "Welsh" |lemma_f$language == "Greek" |lemma_f$language == "Portuguese" | lemma_f$language == "Romanian" | lemma_f$language == "Russian" | lemma_f$language == "Spanish"),]
overview_lemma <- contrastive %>% select(language,dem_lemma_entropy,art_lemma_entropy,quant_lemma_entropy)
overview_lemma <- overview_lemma[which(overview_lemma$language == "UD_Greek-GDT" | overview_lemma$language == "UD_Romanian-RRT" | overview_lemma$language == "UD_Irish-IDT" | overview_lemma$language == "UD_Welsh-CCG"),]
overview_lemma_l <- melt(overview_lemma, id = c("language"))
ggplot(overview_lemma_l) +
  geom_point(size=4,mapping = aes(x = language , y = value, shape=variable)) +##
  theme_bw() +##
  #ylim(0,1) +
  theme(legend.position = "right", legend.text = element_text(face="bold"), axis.text.x = element_text(angle = 45)) +
  labs(title = "", y = "Shannon's entropy", x = "Language", fill = "\n") +
  scale_shape_manual(name="",values=c(6,7,10),labels = c("demonstrative", "article", "quantifier"))
#scale_colour_manual(values = c("#77D153FF","#228D8DFF","#29AF7FFF"),name="",labels = c("Demonstrative","Article","Quantifier"))
ggsave("../plots/fig4.png")
