# Accompanying data for the paper "Reduced order modeling of geometrically nonlinear rotating structures using the direct parametrisation of invariant manifolds"

<br>

## Links

- isSupplementTo *publication-article* [https://doi.org/10.46298/jtcam.10430](https://doi.org/10.46298/jtcam.10430)
- isSupplementedBy *software* [https://archive.softwareheritage.org/swh:1:dir:97292192b4790c2af01e25f4694d024561c5638c;origin=https://github.com/MORFEproject/MORFEInvariantManifold.jl;visit=swh:1:snp:cbd3f3eaf0dc99efb1d6bed706c3b4c3b67a1077;anchor=swh:1:rev:f56492ccd78890ee2b82970ae8941d6e39c0c147](https://archive.softwareheritage.org/swh:1:dir:97292192b4790c2af01e25f4694d024561c5638c;origin=https://github.com/MORFEproject/MORFEInvariantManifold.jl;visit=swh:1:snp:cbd3f3eaf0dc99efb1d6bed706c3b4c3b67a1077;anchor=swh:1:rev:f56492ccd78890ee2b82970ae8941d6e39c0c147)

## Authors

- **Martin Adrien**, Institut des Sciences de la Mécanique et Applications Industrielles, École Nationale Supérieure de Techniques Avancées, Institut Polytechnique de Paris
- **Opreni Andrea**, Politecnico di Milano, ORCID: [0000-0003-1397-6435](https:://orcid.org/0000-0003-1397-6435)
- **Vizzaccaro Alessandra**, University of Bristol, ORCID: [0000-0002-2040-4753](https:://orcid.org/0000-0002-2040-4753)
- **Debeurre Marielle**, Laboratoire d’Ingénierie des Systèmes Physiques et Numériques, HESAM Université - Communauté d'universités et d'établissements Hautes écoles Sorbonne Arts et métiers université
- **Salles Loic**, Imperial College London, Université de Liège, ORCID: [0000-0002-0098-1246](https:://orcid.org/0000-0002-0098-1246)
- **Frangi Attilio**, Politecnico di Milano, ORCID: [0000-0002-7100-1321](https:://orcid.org/0000-0002-7100-1321)
- **Thomas Olivier**, Laboratoire d’Ingénierie des Systèmes Physiques et Numériques, HESAM Université - Communauté d'universités et d'établissements Hautes écoles Sorbonne Arts et métiers université, ORCID: [https://orcid.org/0000-0001-7240-5259](https:://orcid.org/https://orcid.org/0000-0001-7240-5259)
- **Touzé Cyril**, Institut des Sciences de la Mécanique et Applications Industrielles, École Nationale Supérieure de Techniques Avancées, Institut Polytechnique de Paris, ORCID: [0000-0002-4346-4484](https:://orcid.org/0000-0002-4346-4484)

## Language

- English

## License

- Creative Commons Attribution 4.0

## Contributions


- Adrien MARTIN carried out the main part of study, defined the examples, performed the numerical simulations and drafted the manuscript;
- Andrea OPRENI and Alessandra VIZZACCARO developed the methodology and built the main parts of the Julia code implementing the reduction method;
- Andrea OPRENI developed the first version of the HBFEM code which has been updated for rotation in collaboration with Adrien MARTIN;
- Marielle DEBEURRE performed all the simulations shown in Appendix C related to the Timoshenko beam model with continuation;
- Loïc SALLES supervised the work, discussed applications to blades, and helped in designing and understanding the twisted plate model;
- Attilio FRANGI supervised the work and help in the development of the methodology;
- Olivier THOMAS helped in all discussions related to the comparisons with the thin beam example and wrote Appendix C;
- Cyril TOUZE supervised the work, carried out most of the writing and developed the methodology;

All authors read and approved the final manuscript.

## Data collection: period and details

- Datasets produced between September and December 2022

## Funding sources

- Funding from AID (Agence de l’Innovation de Défense), project REMODEL, contract number 2020 65 0057 ENSTA

## Data structure and information

- `README.md`: Contains the general information concerning this dataset

### Figures

- `fig_1`: description of the rotating beam
- `fig_2(a,b,c,d)`: Linear characteristics of the rotating cantilever beam
- `fig_3(a,b)`: FRC of the rotating cantilever beam around 1F mode
- `fig_4`: Convergence of the non-autonomous part of DPIM for the 1F mode
- `fig_5(a,b,c,d,e,f)`: Interpolation of the coefficients of the autonomous ROM
- `fig_6(a,c)`: Hardening/softening behaviour of the rotating beam; fig 6b is a zoom on fig 6a
- `fig_7(a,b,c)`: Comparisons of FRCs obtained from interpolated ROMs with FOM solution
- `fig_8a`: FRC of the rotating cantilever beam around 2F mode; fig 8b is a zoom of fig 8a
- `fig_9(a,b,c,d)`: fig 9 a-b-c : geometry of the blade and some modes and static displacements; fig 9d : Campbell diagram of the blade
- `fig_10`: FRC of the twisted plate
- `fig_11(a,b,c)`: Computing time and convergence analysis with respect to mesh refinement for the fan blade
- `fig_12(a,b,c,d)`: FRC of interpolated ROMs with increasing degrees compared to reference solution

- `fig_A_1`: Campbell diagram of the beam : impact of Coriolis effects
- `fig_C_3(a,b,c,d,e,f,g,h,i)`: Comparison of the results on the beam studied between DPIM and article from Thomas for 1F and 2F modes
- `fig_C_2(a, b)`: Comparison of the results on the beam studied between : DPIM, article from Thomas and results from Debeurre