# Optimal Parameters for MF89 model 

Optimal Parameters are derived from "Bicycle Tyre Data" dataset, available here: 
Gabriele Dell'Orto, Jason K. Moore, Gianpiero Mastinu, & Riender Happee. (2023). Bicycle Tyre Data - Lateral Characteristics (Version 1) [Data set]. Zenodo. https://doi.org/10.5281/zenodo.7866646
We identified 14 parameters for lateral force, 18 parameters for self-aligning torque.
You can find ready-to-use parameters for Pacejka Magic Formula '89. Scripts are available in repository
for plotting and/or analysis collected into .mat structs and .yaml files (same data, only different format). 
.yaml files have been generated from .mat struct, using .mat scripts available here: https://github.com/ewiger/yamlmatlab.git

Experimental measurement of lateral characteristics of bicycle tyres were performed through indoor test-rig VeTyT (Department of Mechanical Engineering, Politecnico di Milano, Milan IT). The test-rig for bicycle tyres complies with the standard ISO 9001-2015.
For further details, refer to the following papers. 

1. Dell’Orto, G., Ballo, F. M., Mastinu, G. (2022). Experimental methods to measure the lateral 	
characteristics of bicycle tyres – a review. Vehicle System Dynamics, 1–23. 	https://doi.org/10.1080/00423114.2022.2144388

2. Dell'Orto, G., Ballo, F. M., Mastinu, G., Gobbi, M. (2022). Bicycle tyres – development of a 	
new test-rig to measure mechanical  characteristics. Measurement, 202, 111813. 	https://doi.org/10.1016/j.measurement.2022.111813

3. Dell'Orto, G., & Mastinu, G. (2022). Effect of temperature on the mechanical characteristics of bicycle tyres. In _Proceedings of the 10th International Cycling Safety Conference_ Technische Universität Dresden. https://doi.org/10.25368/2022.473

4. Dell'Orto, G., Ballo, F. M., Mastinu, G., Gobbi, M., Magnani, G. (2023). Racing bicycle tyres – Influence on mechanical characteristics of internal pressure, vertical force, speed and temperature, European Journal of Mechanics - A/Solids, Volume 100, 105010, ISSN 0997-7538, https://doi.org/10.1016/j.euromechsol.2023.105010


# File name explanation:
OptParameterMF_[identifier tyre-rim]__p__[inflation pressure]

Eventually (only for T10Rigid and T11 Rigid), also camber is reported.
OptParameterMF_[identifier tyre-rim]__camber__[camber angle]__p__[inflation pressure]


.mat files are organized as struct.
Files contain the following data:
1. OptParameterMF_Fy (14 parameters)
1. OptParameterMF_Mz (18 parameters)


## Tyre Identifier

We tested the tyres T10 and T11 mounted on high-stiffness laboratory rim (named as "Rigid"). See reference 2. for further information.
List of tyres tested and identifiers (ID) used to name the data files. 

| Brand      |Serie         	        |Name                   |Dimensions |ETRTO    |ID       |                  
|------------|--------------------------|-----------------------|-----------|---------|---------|                
| Schwalbe   |Balloon       		|Big Ben Plus           |20" x 2,15  | 55-406 |T01      |
| CST        |Brooklyn      		|/                      |20" x 2,15  | 55-406 |T02      |
| Schwalbe   |50km Energizer		|Plus G-Guard 5/Addix-E |28" x 1,75  | 47-622 |T03      |    
| Schwalbe   |50km Energizer		|Active Plus P-Guard 5  |28" x 1,75  | 47-622 |T04      |    
| Scalato    |/        			|Mondano                |28" x 2,15  | 55-622 |T05      |    
| Schwalbe   |/        			|Super Moto-X           |27,5" x 2,40| 62-584 |T06      |
| Mach1 (Rim)|Kargo    			|Disc                   |20"         | 406-25c|T07      |
| Ryde (Rim) |Andra    			|40                     |25"         | 25c-584|T09      |
| Vittoria   |Road Racing/Competition	|Corsa N.ext   		|28" x 26    | 26-622 |T10      |
| Vittoria   |Road Racing/Competition	|Corsa N.ext   		|28" x 28    | 28-622 |T11      |
|Shimano(Rim)|Deore			|HB-M525A   		|28"         | 622    |R01      |

## References 
- E. Bakker, H. B. Pacejka, and L. Lidner, “A new tire model with an application in vehicle dynamics studies,” SAE Technical Papers, vol. 98, pp. 101–113, 1989, doi: 10.4271/890087
- H. B. Pacejka, Tire and Vehicle Dynamics. 2006. doi: 10.1016/B978-0-7506-6918-4.X5000-X.
- MSC Software, “Introducing Adams/Tire”.

## Contacts
For further details, contact the corresponding author Gabriele Dell'Orto
- ResearchGate  https://www.researchgate.net/profile/Gabriele-Dellorto-2/research (Gabriele Dell'Orto, corresponding author)
- LinkedIn  www.linkedin.com/in/dellortogabriele