% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty.R
\name{phylo_generate_uncertainty}
\alias{phylo_generate_uncertainty}
\title{Generate uncertainty in branch lengths using a lognormal.}
\usage{
phylo_generate_uncertainty(
  phy,
  size = 100,
  uncertainty_method = "other",
  age_distribution = "uniform",
  age_sd = NULL,
  age_var = 0.1,
  age_scale = 0,
  alpha = 0.025,
  rescale = TRUE
)
}
\arguments{
\item{phy}{A \code{phylo} object.}

\item{size}{A numeric vector indicating the number of samples to be generated.}

\item{uncertainty_method}{A character vector specifying the method to generate uncertainty. mrbayes is default.}

\item{age_distribution}{A character string specifying the type of calibration.
Only "fixed" and "uniform" are implemented for now.
\describe{
\item{fixed}{The age given in ncalibration will be used as fixed age.}
\item{lognormal}{The age given in ncalibration will be used as mean age.
The standard deviation can be provided. # still need to add this option.
By default, a 95 CI sd is used.}
\item{uniform}{The age given in ncalibration will be used as mean age.
Where min_age = 0.9 * mean age, and max_age = 1.1 * mean age.}
}}

\item{age_sd}{The standard deviation around the age to use for generating the uncertainty. If not a numeric value, var will be used to calculate it.}

\item{age_var}{The variance to calculate age_sd and generate uncertainty.}

\item{age_scale}{How to scale sd by the depth of the node. If 0, same sd for all. If not, older nodes have more uncertainty}

\item{alpha}{The significance level on uncertainty to generate. By default 0.025}

\item{rescale}{Boolean. If true, observed age will be rescaled each round.}
}
\value{
A phylo or multiPhylo object with the same topology as phy but different branch lengths
}
\description{
Generate uncertainty in branch lengths using a lognormal.
}
\details{
If you want to change the size of sampled trees you do not need to run mrbayes again.
Just use sample_trees("mrbayes_trees_file_directory", size = new_size) and you will get a multiPhylo object with a new tree sample.
}
\examples{
\dontrun{
# Generate uncertainty over feline species SDM chronogram.
# Load the data:

data(felid_sdm)

# By default, generates a sample of 100 trees with var = 0.1:

unc <- phylo_generate_uncertainty(felid_sdm$phy)
length(unc)

# Make an LTT plot:

max_age <- max(sapply(unc, ape::branching.times))
ape::ltt.plot(phy = unc[[1]], xlim = c(-max_age, 0), col = "#cce5ff50")
for (i in 2:100) {
  ape::ltt.lines(phy = unc[[i]], col = "#cce5ff50")
}
ape::ltt.lines(felid_sdm$phy, col = "red")
title(c("fake uncertainty", "in Felidae SDM chronogram"))
} # end dontrun
}
