module TestExamples1DMHD

using Test
using Trixi

include("test_trixi.jl")

# pathof(Trixi) returns /path/to/Trixi.jl/src/Trixi.jl, dirname gives the parent directory
EXAMPLES_DIR = joinpath(pathof(Trixi) |> dirname |> dirname, "examples", "tree_1d_dgsem")

@testset "MHD Multicomponent" begin

  @trixi_testset "elixir_mhdmulti_ec.jl" begin
    @test_trixi_include(joinpath(EXAMPLES_DIR, "elixir_mhdmulti_ec.jl"),
      l2   = [0.08160481582829862, 0.05467911944326103, 0.05467911944326103, 0.15450926504459692,
              4.130462730494e-17, 0.054763752050210085, 0.054763752050210085, 0.008371564857135208,
              0.016743129714270416, 0.03348625942854083],
      linf = [0.18198258075330706, 0.09136114386311774, 0.09136114386311774, 0.423831369951313,
              1.1102230246251565e-16, 0.09937317613143604, 0.09937317613143604, 0.0157164284712992,
              0.0314328569425984, 0.0628657138851968])
  end

  @trixi_testset "elixir_mhdmulti_ec.jl with flux_derigs_etal" begin
    @test_trixi_include(joinpath(EXAMPLES_DIR, "elixir_mhdmulti_ec.jl"),
      l2   = [0.08153372259925547, 0.05464109003345891, 0.05464109003345891, 0.1540576724164453,
              4.130462730494e-17, 0.054734930802131036, 0.054734930802131036, 0.008391254781284321,
              0.016782509562568642, 0.033565019125137284],
      linf = [0.17492544007323832, 0.09029632168248182, 0.09029632168248182, 0.40798609353896564,
              1.1102230246251565e-16, 0.09872923637833075, 0.09872923637833075, 0.01609818847160674,
              0.03219637694321348, 0.06439275388642696],
      volume_flux = flux_derigs_etal)
  end

  @trixi_testset "elixir_mhdmulti_es.jl" begin
    @test_trixi_include(joinpath(EXAMPLES_DIR, "elixir_mhdmulti_es.jl"),
      l2   = [0.07968782477167513, 0.05398115008116676, 0.05398115008116676, 0.15015281822439228,
              4.130462730494e-17, 0.053629890024921495, 0.053629890024921495, 0.008279068245579706,
              0.016558136491159413, 0.033116272982318826],
      linf = [0.14118014632124837, 0.07820697032983395, 0.07820697032983395, 0.3390558674728652,
              1.1102230246251565e-16, 0.06998787893467828, 0.06998787893467828, 0.014943825414763745,
              0.02988765082952749, 0.05977530165905498])
  end

  @trixi_testset "elixir_mhdmulti_convergence.jl" begin
    @test_trixi_include(joinpath(EXAMPLES_DIR, "elixir_mhdmulti_convergence.jl"),
      l2   = [1.7337265267786785e-5, 0.00032976971029271364, 0.0003297697102926479, 6.194071694759044e-5,
              4.130462730494001e-17, 0.00032596825025664136, 0.0003259682502567132, 2.5467510126885455e-5,
              5.093502025377091e-5, 0.00010187004050754182],
      linf = [3.877554303711845e-5, 0.0012437848638874956, 0.0012437848638876898, 0.00016431262020277781,
              1.1102230246251565e-16, 0.0012443734922607112, 0.001244373492260704, 5.691007974162332e-5,
              0.00011382015948324664, 0.00022764031896649328])
    end

  @trixi_testset "elixir_mhdmulti_briowu_shock_tube.jl" begin
    @test_trixi_include(joinpath(EXAMPLES_DIR, "elixir_mhdmulti_briowu_shock_tube.jl"),
      l2   = [0.1946577804333822, 0.3591196215528672, 0.0, 0.36875476066849383,
              4.7644020131827105e-16, 0.36668249926193885, 0.0, 0.05775369214541893,
              0.11550738429083786],
      linf = [0.4345551123140612, 1.0874941615375844, 0.0, 1.0493729052116585,
              3.219646771412954e-15, 1.5160434573973656, 0.0, 0.18616213071936066,
              0.3723242614387213],
      coverage_override = (maxiters=6,))
    end

end

end # module
