# An empirical investigation on the competences and roles of practitioners in Microservices-based Architectures

### Visualization

The folder 'analysis-results' contains our visualizations resulted during the study. Besides the figures that are included in the paper, different graphs that were derived as intermediary results are also added for future reference.

### Installation

1. For the scripts towork, python3 is required to be installed
2. Download the contents from the folder source_code-raw_data
3. Install dependencies such as pandas and jupyter notebooks

### Data
The folder source_code-raw_data contains the following data files:
* users_toptags-fulldataset-21189.json: the dataset of our anaysis including the users along with their top tags and information about the tags
* tags.csv: the total set of tags gathered along with a number on how many times each tag appeares in the users profiles
* UsersTagsCollection.csv: the included user profiles (after filtering) along with their collection of associated tags
* UsersTagsFullMatrix.csv: a binary matrix indicating the association of each user with every tag (0 or 1)
* co-occurrence.csv: dataset of the co-occurrence matrix, showing what tags appear with each other and how many co-occurrences each combination has
* Wu_et_al_2021-dataset.csv: the dataset published in the paper of Wu et al. (2021), used as a source for the data gathering of the practitioners working with microservices

### Running the scripts

All of our data gathering and analysis is using jupyter notebooks. 
The data gathering takes place in 'gather-users.ipynb' and requires an active account in the StackExchange API. In order for the script to run, please add your access key and token obtaines by StackExchange in the designated area (2nd cell).

The analysis takes place in 'data-analysis-notebook.ipynb' and it works independently from the data gathering script, since all the data files are included. 

### References
Wu, M., Zhang, Y., Liu, J., Wang, S., Zhang, Z., Xia, X., & Mao, X. (2022, March). On the Way to Microservices: Exploring Problems and Solutions from Online Q&A Community. In 2022 IEEE International Conference on Software Analysis, Evolution and Reengineering (SANER) (pp. 432-443). IEEE.
