function showResults(mechanics,stats,video,options)
% plot first frame to get the limits
f = 1;
vidFrame = video.Frames(f); % frame 1
[~, im] = getVideoFrame(video,vidFrame,options); % load the first frame
imshow(im)
title('Select a rectangle to display');
rect = getrect;
limits = round([rect(1) rect(1)+rect(3) rect(2) rect(2)+rect(4)]);
close all

% process the stats to get which points converged
mechanics.trust = checkOptimizationOutput(stats);

% organizing and plotting the results
rows = 2; columns = 2; % layout of the output
frame = buildFrameStructure(rows,columns,options,limits);
frame.frames = video.Frames;
% plot 1 - 1st principle strain
frame.axes(1).title = '1st Principal Strain'; % title
frame.axes(1).Direction = 2; % 1st principal strain is 2
frame.axes(1).points.on = false;
% plot 2 - second principle strain
frame.axes(2).title = '2nd Principal Strain'; % title
frame.axes(2).Direction = 1; % second principal strain (1)
frame.axes(2).points.on = false;
% plot 3 - strain concentraions
frame.axes(3).title = 'SIMPLE (Delta)';
frame.axes(3).dataType = 'SIMPLE';
frame.axes(3).Direction = 2; % second principle strain (1)
frame.axes(3).points.on = false;
% plot 4 - DTI imaging
frame.axes(4).title = 'DTI';
frame.axes(4).Direction = 1; % second principle strain (1)
frame.axes(4).points.on = false;
frame.axes(4).type = 'DTI';
%% process the output and display the video

frame.f = f; % put the frame 1 in the structure
frame = plotFrame(frame,mechanics,f,im); %plot the first frame (For reference)
[h3,flabel] = suplabel(['Frame ' num2str(video.Frames(1))],'t',[.05 .01 .9 .025]);
colormap jet
% create an output video
if ispc || ismac
    vid_format = 'MPEG-4';
    vid_ext = '.mp4';
else
    vid_format = 'Motion JPEG AVI';
    vid_ext = '.avi';
end
resultsfilename = ['results' vid_ext];
outputVideo = VideoWriter(resultsfilename,vid_format); % if so create an ouput video, append results to the title
outputVideo.FrameRate = 2; % 2 frames per second works well
open(outputVideo); % open the video
for f = 1:1:numel(video.Frames) % now loop through the frames
    vidFrame = video.Frames(f);
    [~, im] = getVideoFrame(video,vidFrame,options); % load the first frame
    frame.f = f; % put the frame 1 in the structure
    set(flabel,'String',['Frame ' num2str(video.Frames(f))]);
    frame = plotFrame(frame,mechanics,f,im,frame.fig); %plot the first frame (For reference)
    mframe = getframe(gcf); % get the frame from matlab
    writeVideo(outputVideo,mframe); % now add the frame to the movie
end
close all % close the figure
close(outputVideo); % and close the video

