% cross plot
function a = plot_cross(a,data,frame,first)
%% centers
dat = data.(a.dataType).F; % get the data we're explicity dealing with!
if isfield(data,'trust') % if there are trrusted values include them
    keep = data.trust(frame,:) ;%& ~(abs(dat)>abs(mean(dat))+4*std(dat));
else
    keep = 1:size(dat,3);
end
lims = a.limits.lims; %(xmin xmax ymin ymax)
xdata = data.x(2,:,frame); % get the positional xdata in the current frame
ydata = data.x(1,:,frame); % " y data
if ~isempty(lims)
    drop = xdata<lims(1) | xdata>lims(2) | ydata<lims(3) | ydata>lims(4);
    xdata(drop | ~keep) = []; ydata(drop | ~keep) =[];
    F = dat(:,:,~drop | keep,frame);
else
    F = dat(:,:,keep,frame);
end
npt = numel(xdata);
res = a.res(1);

% get x and y positions of the vertices
xv1 = repmat([-res(1)/2  res(1)/2],npt,1);
z  = zeros(npt,2);
yv1 = repmat([-res(1)/2  res(1)/2],npt,1); 

xv = horzcat(xv1, z   );
yv = horzcat(z  , yv1 );
clear x;clear y;
% get current F values

% x = zeros(2,6,npt);

for i = 1:npt % loop thorugh each pt and multiply by F
    dX = [xv(i,:) ; yv(i,:)];
    dx = (F(:,:,i))^a.exponent*dX;
    x(i,:) = dx(2,:)+xdata(i); % check!!!
    y(i,:) = dx(1,:)+ydata(i); % check!!!
end
%%
xp = horzcat(x(:,1:2),nan(npt,1),x(:,3:4),nan(npt,1))';
xp = reshape(xp,[3 npt*2]);
yp = horzcat(y(:,1:2),nan(npt,1),y(:,3:4),nan(npt,1))';
yp = reshape(yp,[3 npt*2]);

d = (xp(1,:)-xp(2,:)).^2+(yp(1,:)-yp(2,:)).^2;
t = d>=(res^2);
c = d<=(res^2);


% assign before dropping
xp_comp = xp(:,c);
xp_ten =  xp(:,t);
yp_comp = yp(:,c);
yp_ten =  yp(:,t);
%
if isempty(a.quivt) || first
    a.quivt = plot(xp_ten(:),yp_ten(:),'r','LineWidth',1.5);
    a.quivc = plot(xp_comp(:),yp_comp(:),'b','LineWidth',1.5);
    axis off
else
    set(a.quivt,'XData',xp_ten(:),'YData',yp_ten(:));
    set(a.quivc,'XData',xp_comp(:),'YData',yp_comp(:));
end

%alpha(a.quivc,0.8)
%xv = horzcat([xv1 ; xv2],nan(2*npt,1))';
%yv = horzcat([yv2 ; yv1],nan(2*npt,1))';
%xv = xv(:);
%yv = yv(:);



