function regions = makeBoxRegions(centers,boxSize)
% create the vertices array
nPoints = size(centers,1);
dist = [(boxSize(1)-1)/2 (boxSize(2)-1)/2];
v = [-dist(1)  -dist(2) dist(1) dist(2)]; % create the verticies
% combine the centers with the verticies
centers = repmat(centers,1,2); % repeat the centers
v = repmat(v,nPoints,1); % repeat the edges
vert = centers + v; % add the vertices to the centers to get the edges
regions = struct(); % preallocate the regions
for i = 1:nPoints % loop over each one and create the points
    c = vert(i,:);
    xv = c(1):c(3);
    yv = c(2):c(4);
    [x,y] = ndgrid(xv,yv);
    regions(i).x = x; regions(i).y = y;
end

end