function [mechanics,stats,preComp] = lkInverseCompositional(video,options) 
%% generalized LK code - no requirements on the type of warp or the
% structure of the regions
% the warp will be specified as a function in options.lk.warp
%
% Inputs Description:
% video - a descriptor indentifying the video we are using. will be
%   interpreted by getVideoFrame function
% options - a structure containing all options related to image processing,
%   optimization, and outputs.

%% process the video
% -------------------------------------
% load the first frame with gradients
% -------------------------------------
getGradients = true;
[template,RGBImage,gradients,options] = getVideoFrame(video,video.Frames(1),options,getGradients);

% -------------------------------------
% mesh the template image
% -------------------------------------
[regions,X] = meshRegions(RGBImage,options);

% [regions,X] = meshRegions(RGBImage,options,X);
% -------------------------------------
% perform precomputation for each region 
% -------------------------------------
preComp = preComputation(gradients,regions,template,options);

% -------------------------------------
% register every region in each frame 
% -------------------------------------
[P,stats] = LKSolver(video,preComp,options);
% -------------------------------------
% process the results to get the mechanics
% -------------------------------------
mechanics = processResults(preComp,video,P,X,options);

%showResults(mechanics,stats,video,options);

end

