%images2array read folder of images into a Matlab array
% Louis Woodhams 2016
% edited 2019

function [ intensmat ] = images2array (fileFolder, scale, startFrame, endFrame, extIndex)

multipage = false;
% 1 for .tif, 2 for .jpg, 3 for .bmp
ext = {'*.tif'; '*.jpg'; '*.bmp'};

% if no folder provided, let's go get one and ask for other variables
fileName = [];
if nargin == 0
    [fileName, fileFolder, extIndex] = uigetfile(ext,'Select a reference image from files to be analyzed.');
    
    % get the image scaling percentage
    scale = input('Percent to scale image to? [100]: ');
    if isempty(scale)
        scale = 100;
    end
    
    % get the starting image number
    startFrame = input('Starting Frame? [1]: ');
    if isempty(startFrame)
        startFrame = 1;
    end
    
    % get the ending frame number (blank for end)
    endFrame = input('End Frame? [end]: ');
end

dirOutput = dir(fullfile(fileFolder, ext{extIndex}));
fileNames = {dirOutput.name};

%add fileFolder to path temporarily
addpath(fileFolder);

% see if this is a multipage tif
if ~isempty(fileName)
    info{1} = imfinfo(fileName);
    num_pages = numel(info{1});
    if num_pages > 1
        multipage = true;
        file_pages{1} = num_pages;
    end
end

%specific name of reference image for image properties
imRef = imread(fileNames{1});
numFiles = length(fileNames); % number of  image files

%scale brightness
% hot_pixel = 1*double(prctile(imRef(:),98));  % safe maximum pixel value
% bright_scale_def = 255/hot_pixel;
% % if bright_scale_def > 1.02
% fprintf('Default Brightness Scale is %2.2f \n', bright_scale_def);
% bright_scale = input('Scale Brightness? (1 is no scaling): ');
% if isempty(bright_scale)
%     bright_scale = bright_scale_def;
% end
% else
    bright_scale = 1;
% end
% if bright_scale == 1
%     imRef = uint8(imRef);
% else
%     imRef = uint8(bright_scale * imRef);  % convert in uint8
% end

imRef = im2uint8(imRef);
% if multipage
%     for i = 2:numFiles % go through each file
%         info{i} = imfinfo(fileNames{i}); % read file info and put in cell array
%         file_pages{i} = numel(info{i});
%         num_pages = num_pages + file_pages{i}; % add number of pages to total
%     end
%     % create index
%     count = 1;
%     file_index = zeros(num_pages,2);
%     for i = 1:numFiles % for each file
%         for ii = 1:file_pages{i} % assign each page to an index
%             file_index(count,:) = [i ii];
%             count = count + 1;
%         end
%     end
% else
%     num_pages = numFiles;
% end

% ---------------------
% default arguments
% ---------------------
% if nargin > 0 && nargin < 4
%     endFrame = numFiles;
%     if nargin < 3
%         startFrame = 1;
%         if nargin < 2
%             scale = 100;
%         end
%     end
% end
 if isempty(endFrame)
    endFrame = numFiles;
 end
% 
% % resize image
scale = scale / 100;
dim = size(imresize(imRef,scale));
% is this a color image?
color = 0;
if length(dim) == 3
    color = 1;
end




%create Array from images
w = waitbar(0,'Creating intensitiesArray');
tic
numFrames = endFrame - startFrame + 1;
intensmat = zeros(dim(1),dim(2),numFrames,'uint8');   %create array of intensity vectors

disp('Creating intensitiesArray');
n = 0;  %for the waitbar!
for i = startFrame:endFrame
    
    %waitbar only every 20 frames
    if mod(n,20) == 0
        waitbar(n/numFrames, w);
    end
    
    % Read in the image
    if multipage
        file = file_index(i,1);
        page = file_index(i,2);
        img = bright_scale*imread(fileNames{file},page,'Info',info{file});
    else
        img = bright_scale*imread(fileNames{i}); % just read
    end
    
    % do we need to convert three channel to single channel?
    if color
        img = mean(img,3); % read and convert to grayscale
    end
    
    % scale image (if needed) and save to array
    if scale == 1
        intensmat(:,:,i) = im2uint8(img);
    else
        intensmat(:,:,i) = im2uint8(imresize(img,scale));
    end
    n = n + 1;
end


delete(w); % close the waitbar
toc

fprintf('\n')
rmpath(fileFolder); %restore path