function trust = checkOptimizationOutput(stats)
nframes = numel(stats); % find out how many frames we have
npts = numel(stats(2).converged); % find out how many points
stats(1).converged = ones(1,npts);
converged = reshape([stats.converged],npts,nframes)'; % convergence stats in frame by point orientation
failed = ~converged; % frame by frame failures
nFailed = cumsum(failed); % cumulative sum of how many times the point failed
untrusted = nFailed>0; % if a point failed to converge once disregard it
trust = ~untrusted; % we trust things that are not untrusted.