function frame = buildFrameStructure(varargin)
% builds a frame structure with all defaults, to be changed afterward
% f.axes               - main containing each array specifying what to
%                         plot on each axis
% f.data                - main containing the data for the frame, built in
%                           builddatastruct
% f.first               - set true if the figure hans't been made
% f.spacing             - spacing of the frame
% f.frame               - frame index to use to plot
%
% set up initial data
row = varargin{1};
column = varargin{2};
options = varargin{3};
if nargin >= 4
    limits = varargin{4};
end
if nargin == 5
    scale = varargin{6};
else scale = -1;
end
%data,row,column,options,limits
frame.frame = 1;
%frame.data = mechanics;
frame.first = true;
frame.spacing = 0.05;
frame.TitleHandle = 0;
frame.FontSize = 16;
frame.Color = 'w';
frame.frames = 1:20;
heatmapalpha = options.plotting.HeatMapAlpha;

% build axes with defaults
nPlots = row*column;

for n = 1:nPlots
    axes(n).type = 'composite'; % image heatmap or placeholder
    axes(n).dataType = 'DDE';
    if nargin  >= 4
        axes(n).limits.on = true;
        axes(n).limits.lims = limits;
    else
        axes(n).limits.on = false;
        axes(n).limits.lims = [];
    end
    axes(n).points.on = false;
    axes(n).cbar.on = true;
    axes(n).cbar.clims = [];
    axes(n).trustplot = 0;
    
    axes(n).Direction = 2;
    axes(n).StrainDataType = 'PrincipleE'; % 'Principle E' ; 'E' ; 'F'
    axes(n).CData = 0;
    axes(n).CDataIm = 0;
    axes(n).HeatMapAlpha = heatmapalpha;
    axes(n).Adata = 0;
    axes(n).CbarHeat =0;
    axes(n).deformations.on = false;
    
    axes(n).directions.on = false;
    axes(n).directions.type = 'x'; % 'x' for cross or '>' for simple
    axes(n).directions.color = true; % off for all same color
    axes(n).directions.colors = ['r' 'b']; % tension and compression, respectively
    axes(n).quivt = [];
    axes(n).quivc = [];
    axes(n).exponent = 2;
    axes(n).res = options.Meshing.boxSize;
    if isstruct(scale)
        axes(n).scale.on = true;
        axes(n).scale.BarLengthum = scale.BarLengthum*options.fresize; % draw a 500um scale bar  
        axes(n).scale.scale = scale.pxumscale; %add the scale length
    else
        axes(n).scale.on = false;
        axes(n).scale.BarLengthum = [];
        axes(n).scale.scale = [];
    end

end
frame.axes = reshape(axes,row,column);


end
