# Small-molecule Binding to an Intrinsically Disordered Protein Revealed by Experimental NMR 19F Transverse Spin-relaxation

These data support the manuscript entitled "Small-molecule Binding to an Intrinsically Disordered Protein Revealed by Experimental NMR 19F Transverse Spin-relaxation" by Heller, Shukla, Figueiredo, and Hansen.

This data should be used with the code provided on GitHub at https://github.com/hansenlab-ucl/R2_IDP_small_mol. Once downloaded, this directory should be extracted using the following command:

tar -xzvf Data.tar.gz

The directory should be saved with the name 'Data' placed in the same directory as the GitHub README.md file.

## This dataset contains: 
#### Nuclear Magnetic Resonance (NMR) spectroscopy data files (.ft2 format) including: 

* 1H 1D ligand-detected chemical shift titration of 5-fluoroindole (50 uM) with increasing concentrations of the protein, non-structural protein 5A, domains 2 and 3 (NS5A-D2D3), in 1H_1D_ft2_data/

* 1H pseudo-2D Diffusion Ordered SpectroscopY (DOSY) data of 5-fluoroindole (50 uM) with and without NS5A-D2D3 (75 uM) in 1H_DOSY_data/

* 1H-15N Heteronuclear Single Quantum Coherence (HSQC) measurements of NS5A-D2D3 (40 uM) in the absence and presence of 5-fluoroindole (160 and 320 uM) in 1H_15N_HSQC_ft2_and_metadata/

* 19F 1D ligand-detected chemical shift titration of 5-fluoroindole (50 uM) with increasing concentrations of NS5A-D2D3 in 19F_1D_ft2_data/

* 19F pseudo-2D ligand-detected longitudinal (spin-lattice, R1,eff) relaxation titration data of 5-fluoroindole (50 uM) with increasing concentrations of NS5A-D2D3 in 19F_R1eff_ft2_data/

* 19F pseudo-2D ligand-detected longitudinal (spin-spin, R2,eff) relaxation titration data of 5-fluoroindole (50 uM) with increasing concentrations of NS5A-D2D3 in 19F_R2eff_ft2_data/

#### Circular Dichroism (CD) data files (.txt format) including: 

* CD measurements of NS5A-D2D3 at increasing concentrations in CD_data/no_molecule/

* CD measurements of NS5A-D2D3 with and without the small molecule, 5-fluoroindole CD_data/with_molecule/

#### Metadata 

* Metadata from the Biological Magnetic Resonance Data Bank (https://bmrb.io/) used to determine scaling factors for the calculation of chemical shift perturbations in 1H_15N_HSQC_ft2_and_metadata/

