generate_md_episodes <- function() {

  # avoid ansi color characters from being printed in the output
  op <- options()
  on.exit(options(op), add = TRUE)
  options(crayon.enabled = FALSE)
  ## get the Rmd file to process from the command line, and generate the path
  ## for their respective outputs
  args  <- commandArgs(trailingOnly = TRUE)
  if (!identical(length(args), 2L)) {
    stop("input and output file must be passed to the script")
  }

  src_rmd <- args[1]
  dest_md <- args[2]

  ## knit the Rmd into markdown
  knitr::knit(src_rmd, output = dest_md)

  # Read the generated md files and add comments advising not to edit them
  add_no_edit_comment <- function(y) {
    con <- file(y)
    mdfile <- readLines(con)
    if (mdfile[1] != "---")
      stop("Input file does not have a valid header")
    mdfile <- append(
      mdfile,
      "# Please do not edit this file directly; it is auto generated.",
      after = 1
    )
    mdfile <- append(
      mdfile,
      paste("# Instead, please edit", basename(y), "in _episodes_rmd/"),
      after = 2
    )
    writeLines(mdfile, con)
    close(con)
    return(paste("Warning added to YAML header of", y))
  }

  vapply(dest_md, add_no_edit_comment, character(1))
}

generate_md_episodes()
