# Contributing

[Software Carpentry][swc-site] and [Data Carpentry][dc-site] are open source projects,
and we welcome contributions of all kinds:
new lessons,
fixes to existing material,
bug reports,
and reviews of proposed changes are all welcome.

## Contributor Agreement

By contributing,
you agree that we may redistribute your work under [our license](LICENSE.md).
In exchange,
we will address your issues and/or assess your change proposal as promptly as we can,
and help you become a member of our community.
Everyone involved in [Software Carpentry][swc-site] and [Data Carpentry][dc-site]
agrees to abide by our [code of conduct](CONDUCT.md).

## How to Contribute

The easiest way to get started is to file an issue
to tell us about a spelling mistake,
some awkward wording,
or a factual error.
This is a good way to introduce yourself
and to meet some of our community members.

1.  If you do not have a [GitHub][github] account,
    you can [send us comments by email][contact].
    However,
    we will be able to respond more quickly if you use one of the other methods described below.

2.  If you have a [GitHub][github] account,
    or are willing to [create one][github-join],
    but do not know how to use Git,
    you can report problems or suggest improvements by [creating an issue][issues].
    This allows us to assign the item to someone
    and to respond to it in a threaded discussion.

3.  If you are comfortable with Git,
    and would like to add or change material,
    you can submit a pull request (PR).
    Instructions for doing this are [included below](#using-github).

## Where to Contribute

1.  If you wish to change this lesson,
    please work in <https://github.com/swcarpentry/r-novice-gapminder>,
    which can be viewed at <https://swcarpentry.github.io/r-novice-gapminder>.
    Please _only_ include .Rmd files in pull requests (i.e. do not include 
    .md files in pull requests).

2.  If you wish to change the example lesson,
    please work in <https://github.com/carpentries/lesson-example>,
    which documents the format of our lessons
    and can be viewed at <https://carpentries.github.io/lesson-example>.

3.  If you wish to change the template used for workshop websites,
    please work in <https://github.com/carpentries/workshop-template>.
    The home page of that repository explains how to set up workshop websites,
    while the extra pages in <https://carpentries.github.io/workshop-template>
    provide more background on our design choices.

4.  If you wish to change CSS style files, tools,
    or HTML boilerplate for lessons or workshops stored in `_includes` or `_layouts`,
    please work in <https://github.com/carpentries/styles>.

## What to Contribute

There are many ways to contribute,
from writing new exercises and improving existing ones
to updating or filling in the documentation
and submitting [bug reports][issues]
about things that don't work, aren't clear, or are missing.
If you are looking for ideas,
please see [the list of issues for this repository][issues],
or the issues for [Data Carpentry][dc-issues]
and [Software Carpentry][swc-issues] projects.

Comments on issues and reviews of pull requests are just as welcome:
we are smarter together than we are on our own.
Reviews from novices and newcomers are particularly valuable:
it's easy for people who have been using these lessons for a while
to forget how impenetrable some of this material can be,
so fresh eyes are always welcome.

## What *Not* to Contribute

Our lessons already contain more material than we can cover in a typical workshop,
so we are usually *not* looking for more concepts or tools to add to them.
As a rule,
if you want to introduce a new idea,
you must (a) estimate how long it will take to teach
and (b) explain what you would take out to make room for it.
The first encourages contributors to be honest about requirements;
the second, to think hard about priorities.

We are also not looking for exercises or other material that only run on one platform.
Our workshops typically contain a mixture of Windows, Mac OS X, and Linux users;
in order to be usable,
our lessons must run equally well on all three.

## Submitting Pull Requests

If you choose to submit a pull request,
you may want to look at
[How to Contribute to an Open Source Project on GitHub][how-contribute]. In brief:

1. Fork the repository and clone it locally.
2. Create a new branch in your desktop copy of this repository.
3. Commit the change in that branch. If you'd like to suggest a change to an
episode in the lesson, please commit changes to .Rmd files in `_episodes_rmd`.
4. Preview how your changes will look when viewed in a web browser, rendering
the html pages by running `make serve` from the base of the repository.
Generating the html file(s) is required for viewing the
[online version of the lessons][online].
Building the rendered page with the Makefile requires installing some
[dependencies] first.
Changes generated by the `make serve` command should not be
committed or included in a pull request.
5. Push that branch to your fork of this repository on GitHub.
6. Submit a pull request from that branch to the main branch of the
[master repository][repo]. Please _only_ include .Rmd files in pull 
requests (i.e. do not include .md files in pull requests).
7. If you receive feedback, make changes on your desktop and push to your
branch on GitHub: the pull request will update automatically.

Each lesson has maintainers who review issues and pull requests
or encourage others to do so.
The maintainers are community volunteers,
and have final say over what gets merged into the lesson.

## Other Resources

General discussion of [Software Carpentry][swc-site] and [Data Carpentry][dc-site]
happens on the [discussion mailing list][discuss-list],
which everyone is welcome to join.
You can also [reach us by email][contact].

[contact]: mailto:admin@software-carpentry.org
[dc-issues]: https://github.com/issues?q=user%3Adatacarpentry
[dc-lessons]: http://datacarpentry.org/lessons/
[dc-site]: http://datacarpentry.org/
[discuss-list]: http://lists.software-carpentry.org/listinfo/discuss
[github]: http://github.com
[github-flow]: https://guides.github.com/introduction/flow/
[github-join]: https://github.com/join
[how-contribute]: https://egghead.io/series/how-to-contribute-to-an-open-source-project-on-github
[issues]: https://github.com/swcarpentry/r-novice-gapminder/issues
[repo]: https://github.com/swcarpentry/r-novice-gapminder
[swc-issues]: https://github.com/issues?q=user%3Aswcarpentry
[swc-lessons]: http://software-carpentry.org/lessons/
[swc-site]: http://software-carpentry.org/
