% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc_stocks.R
\name{bc_stocks}
\alias{bc_stocks}
\title{bc_stock()}
\usage{
bc_stocks(
  sample_data,
  core_id,
  sample_depth,
  element_concentration,
  maximum_depth,
  method = NULL,
  section_height = NULL,
  diagnostic_plot = FALSE
)
}
\arguments{
\item{sample_data}{Sediment sample properties, after calculating elemental concentration and correcting compaction}

\item{core_id}{Name of for core the identifier. Should be a string}

\item{sample_depth}{Name of variable for the depth at which samples were taken}

\item{element_concentration}{Name of the variable for the concentration of the element whose stock is being estimated}

\item{maximum_depth}{Depth to which to estimate the stock.}

\item{method}{Method used to estimate the stock, one of "rectangle" or "trapezoid"}

\item{diagnostic_plot}{Should a plot of how the stock was estimated be shown? FALSE (default) or TRUE}

\item{section_start}{(Optional, only for "rectangle" method) Depth at which the core section represented by each sample begins}

\item{section_end}{(Optional, only for "rectangle" method) Depth at which the core section represented by each sample ends}
}
\description{
Estimate the stock of an element contained given its concentration along
a sediment core.
}
\details{
\strong{Calculate elemental stocks:}
\enumerate{
\item Trapezoid rule (Martins, M. et al 2021)
\item Rectangle rule (Howard, J. et al 2014)
}
\itemize{
\item User provides start and end of sections represented by samples
\item Heights of sections are automatically estimated
3.(optional) - Plots how the stock is being estimated, with a special draw towards any sections that have to be extrapolated
}
}
