% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc_depth_correction.R
\name{bc_depth_correction}
\alias{bc_depth_correction}
\title{bc_depth_correction}
\usage{
bc_depth_correction(
  core_data,
  sample_data,
  sampler_length = "sampler_length",
  sampler_diameter = "sampler_diameter",
  internal_distance = "internal_distance",
  external_distance = "external_distance",
  method = "linear"
)
}
\arguments{
\item{core_data}{data.frame with core properties}

\item{sample_data}{data.frame with sample properties}

\item{sampler_length}{name of the column with the total length of the sampler tube}

\item{sampler_diameter}{name of the column with the diameter of the sampler tube}

\item{internal_distance}{name of the column with distance between sampler top and core surface}

\item{external_distance}{name of the column with distance between sampler top and sediment surface}

\item{method}{linear or exponential correction}
}
\value{
the initial sample_data with the addition of the corrected sample depth and volume
}
\description{
Calculates corrected sample depth and sample volume to account for compaction (linear or exponential methods).
User provides a core data.frame and a sample data.frame
User can specify if the sample volume is estimated from a half of the core or in another way.

The function returns the sample data.frame modified with the addition of the estimated parameters
}
