setwd("~/Dropbox/Thesis/Chapter-4/Project_Jak:Stat-pathway & tolerance/Analysis/R/csv files")

read.csv("Linear_slope.csv")
slope <- read.csv("Linear_slope.csv")

str(slope) 
summary(slope) 

## boxplot
library(ggplot2)
ggplot(data = slope) +
  aes(x = line, fill = line, weight = estimate) +
  geom_bar(position = "dodge") +
  labs(x = "FLy line",
       y = "Linear slope")  +
  theme_test(base_size = 18)+
  facet_grid(cols = vars(sex))

p<- ggplot(slope, aes(x=line, y=estimate, fill=line)) + 
  geom_bar(stat="identity", color="black",  
           position=position_dodge()) +
  geom_errorbar(aes(ymin=estimate-std_err, ymax=estimate+std_err), width=.2,
                position=position_dodge(.9)) + facet_grid(cols = vars(sex))
print(p)
# Finished bar plot
p+labs(x="Fly line", y = "Tolerance Slope 
(estimates from linear reaction norm)")+
  scale_fill_manual(values = c("gray27","indianred3","slateblue3","goldenrod","plum3"))+
  theme_classic(base_size = 22) +
  ylim(20, -55)