setwd("~/Desktop/Gut-epithelia & Jak:stat/Project_Jak:Stat-pathway & tolerance/Analysis/R/csv files")

read.csv("JakStat_riskratio.csv")
hazfn <- read.csv("JakStat_riskratio.csv")

str(hazfn) 
summary(hazfn) 


library(ggplot2)
ggplot(data = hazfn) +
  aes(x = flyline, fill = flyline, weight = estimate) +
  geom_bar(position = "dodge") +
  labs(x = "sex",
       y = "Hazard ratio (w1118 vs. gut-epithelial mutants)") +
  theme_test()

p<- ggplot(hazfn, aes(x=flyline, y=estimate, fill=flyline)) + 
  geom_bar(stat="identity", color="black",   
           position=position_dodge()) +
  geom_errorbar(aes(ymin=estimate-std_err, ymax=estimate+std_err), width=.2,
                position=position_dodge(.9)) 
print(p)
# Finished bar plot
p+labs(x="Sex", y = "Hazard ratio
       (Jak/Stat mutants/ w1118 flies)")+
  facet_grid(cols = vars(sex))+
  scale_fill_manual(values = c("indianred3","slateblue3","goldenrod","plum3"))+
  theme_classic(base_size = 24)
