setwd("~/Dropbox/Thesis/Chapter-3 & 4/Gut-epithelia & Jak:stat/Project_Jak:Stat-pathway & tolerance/Analysis/R/csv files")

kmtest <- read.csv("JakStat_SurvivalPI.csv")
str(kmtest) 

library(survminer)
library(survival)
library(magrittr)

surv_fit(Surv(hpi, censor) ~ treatment+flyline, 
         data = kmtest, group.by = "sex") %>%
  ggsurvplot(ggtheme = theme_test(),
             xlab = "Lifespan (hours)", 
             ylab = "Proportion surviving",
             palette = c("slateblue3","indianred3","goldenrod","plum3","black",
                         "slateblue3","indianred3","goldenrod","plum3","black"),
             linetype = c("dotted","dotted","dotted","dotted","dotted",
                          "solid","solid","solid","solid","dashed"),
             pval = FALSE,
             conf.int = TRUE,
             main = "Survival curve",
             font.main = 17,
             font.x =  18,
             font.y = 18,
             font.tickslab = 15,
             size = 1.5
  ) %>%
  purrr::map(function(ggsurv) {ggsurv$plot}) %>%
  ggpubr::ggarrange(plotlist = .)

library(survival)
library(coxme)
library(lme4)
library(MASS)
library(lsmeans)
library(nlme)
library(dplyr)

knitr::opts_chunk$set(echo = TRUE)


model1 <- lme(hpi~treatment*sex*flyline,random=~1|vial/block,kmtest,method="REML")
summary(model1)
anova(model1)

model2<- coxph(Surv(hpi,censor)~treatment*sex*flyline,kmtest)
model2
anova(model2)

model3 <- coxme(Surv(hpi,censor)~treatment*sex*flyline+(1|vial/block),kmtest)
model3
summary(model3)
anova(model3)

