setwd("~/Desktop/Gut-epithelia & Jak:stat/Project_Jak:Stat-pathway & tolerance/Analysis/R/csv files")

read.csv("G9a_riskratio.csv")
hazfn <- read.csv("G9a_riskratio.csv")

str(hazfn) 
summary(hazfn) 


## boxplot
library(ggplot2)
ggplot(data = hazfn) +
  aes(x = flyline, fill = sex, color = sex, weight = estimate) +
  geom_bar(position = "dodge") +
  labs(x = "Flyline",
       y = "Risk ratio (Jak/Stat mutants vs. y/w)") +
  theme_test()

p<- ggplot(hazfn, aes(x=flyline, y=estimate, fill=sex)) + 
  geom_bar(stat="identity", color="black",  
           position=position_dodge()) +
  geom_errorbar(aes(ymin=estimate-std_err, ymax=estimate+std_err), width=.2,
                position=position_dodge(.9)) 
print(p)
# Finished bar plot
p+labs(x="Flyline", y = "Risk ratio
       (G9a-/- vs. G9a+/+ flies)")+
  scale_fill_manual(values = c("maroon","steelblue"))+
  theme_classic2(base_size = 18)