setwd("~/Dropbox/Thesis/Chapter-4/Project_Jak:Stat-pathway & tolerance/Analysis/R/csv files")

loadall <- read.csv("G9a_cfus_tolerance.csv")

str(loadall) 

library(ggplot2)
ggplot(data = loadall) +
  aes(x = sex, y = log10cfu, fill = flyline) +
  geom_boxplot(alpha=0.5,
               aes(fill=flyline),
               outlier.alpha = 0)+
  labs(x = "Sex",
       y = "Mean bacterial load (Log10)") +
  geom_dotplot(position=position_dodge(0.75),
               binaxis='y',
               stackdir='center',
               stackratio=1.5,
               dotsize=1.25,
               binwidth = 0.1,
               aes(fill=flyline)) +
  theme_classic(base_size = 24) +
  scale_fill_manual(values=c("steelblue","maroon","steelblue"))+
  facet_grid(cols=vars())




##stats
# constructing two-way anova
load_an <- lm(log10cfu ~ flyline*sex, data = loadall)
names(load_an)
par(mfrow = c(2,2))
plot(load_an)
anova(load_an)
summary(load_an)