setwd("~/Desktop/Gut-epithelia & Jak:stat/Project_Jak:Stat-pathway & tolerance/Analysis/R/csv files")

read.csv("Control_rr.csv")
hazfn <- read.csv("Control_rr.csv")

str(hazfn) 
summary(hazfn) 


## boxplot
library(ggplot2)
library(wesanderson)
ggplot(data = hazfn) +
  aes(x = flyline, fill = sex, color = sex, weight = estimate) +
  geom_bar(position = "dodge") +
  labs(x = "Flyline",
       y = "Risk ratio (Outcross vs. y/w)") +
  theme_test()

p<- ggplot(hazfn, aes(x=flyline, y=estimate, fill=sex)) + 
  geom_bar(stat="identity", color="black",  
           position=position_dodge()) +
  scale_fill_manual(values = wes_palette(n=2, name = "Royal1"))+
  ylim(0,2)+
  geom_errorbar(aes(ymin=estimate-std_err, ymax=estimate+std_err), width=.2,
                position=position_dodge(.9)) 
print(p)
# Finished bar plot
p+labs(x="Flyline", y = "Risk ratio
       (Outross/ yw flies)")+
  scale_fill_manual(values = c("chocolate3","gray27"))+
  theme_classic2(base_size = 18)