setwd("~/Dropbox/Thesis/Chapter-4/Project_Jak:Stat-pathway & tolerance/Analysis/R/csv files")

loadall <- read.csv("controls_cfus.csv")

str(loadall) 

library(ggplot2)
ggplot(data = loadall) +
  aes(x = flyline, y = log10cfu, fill = sex) +
  geom_boxplot(alpha=0.5,
               aes(fill=sex),
               outlier.alpha = 0)+
  labs(x = "Sex",
       y = "Mean bacterial load (Log10)") +
  geom_dotplot(position=position_dodge(0.7),
               binaxis='y',
               stackdir='center',
               stackratio=1.5,
               dotsize=0.9,
               binwidth = 0.1,
               aes(fill=sex)) +
  theme_classic(base_size = 22) +
  scale_fill_manual(values=c("chocolate3","black","maroon","steelblue"))+
  facet_grid(cols=vars())


##stats
# constructing two-way anova
load_an <- lm(log10cfu ~ flyline*sex, data = loadall)
names(load_an)
par(mfrow = c(2,2))
plot(load_an)
anova(load_an)
summary(load_an)