#!/bin/bash

#NOTE: this is a shortened version of DARWINDOW (https://github.com/mennodejong1986/Darwindow) that contains only the main analysis.
#Written by Menno de Jong, edited by Magnus Wolf 01.12.2022
#THERE IS NO NEED TO EDIT ANYTHING IN THIS SCRIPT AS ALL PARAMETERS AND THINGS YOU MIGHT WANNE CHANGE ARE DEFINED IN THE MAIN SCRIPT OF RESEQ-to-Popanalyses!!!!!!!!!!!!


TABIX=${1?Error: not the correct amount of arguments, it needs a path to the bin in which is tabix, a name of the vcf without the gz extension, a suffix, a window size and a minimum contig length}
MYVCF=${2?Error: not the correct amount of arguments, it needs a path to the bin in which is tabix, a name of the vcf without the gz extension, a suffix, a window size and a minimum contig length}
suffix=${3?Error: not the correct amount of arguments, it needs a path to the bin in which is tabix, a name of the vcf without the gz extension, a suffix, a window size and a minimum contig length}
winsize=${4?Error: not the correct amount of arguments, it needs a path to the bin in which is tabix, a name of the vcf without the gz extension, a suffix, a window size and a minimum contig length}
mincontigbp=${5?Error: not the correct amount of arguments, it needs a path to the bin in which is tabix, a name of the vcf without the gz extension, a suffix, a window size and a minimum contig length}

###########################
biallelic=FALSE
annotated=FALSE
haploiddata=FALSE						# Set to TRUE in case of haploid data. Only useful to count alternative sites (because no heterozygous sites present anyway).

# actual analyses:
run_loop=TRUE							# only set to TRUE after having run the four preparatory steps
sample_scores=TRUE						# sliding window heterozygosity (needed for ROH-analyses)
pop_scores=FALSE
poppair_scores=FALSE
tstv_scores=FALSE
ld_scores=FALSE						
admix_scores=FALSE
###########################

###### RUN LOOP ######


if [[ "$run_loop" = TRUE ]]
	then
	echo "Starting loop..."
	
	# create files in which to store results:
	if [ -f "mywindowhe.${winsize}.${suffix}.txt" ]; then rm mywindowhe.${winsize}.${suffix}.txt; fi
	if [ -f "mywindowheader.txt" ]; then cp mywindowheader.txt mywindowhe.${winsize}.${suffix}.txt; else touch mywindowhe.${winsize}.${suffix}.txt; fi
	if [ -f "mywindowpi.${winsize}.${suffix}.txt" ]; then rm mywindowpi.${winsize}.${suffix}.txt; fi
	if [ -f "mywindowpiheader.txt" ]; then cp mywindowpiheader.txt mywindowpi.${winsize}.${suffix}.txt; else touch mywindowpi.${winsize}.${suffix}.txt; fi
	if [ -f "mywindowpoly.${winsize}.${suffix}.txt" ]; then rm mywindowpoly.${winsize}.${suffix}.txt; fi
	if [ -f "mywindowpolyheader.txt" ]; then cp mywindowpolyheader.txt mywindowpoly.${winsize}.${suffix}.txt; else touch mywindowpoly.${winsize}.${suffix}.txt; fi
	if [[ "$tstv_scores" = TRUE ]]
		then
		if [ -f "mywindowtstv.${winsize}.${suffix}.txt" ]; then rm mywindowtstv.${winsize}.${suffix}.txt; fi
		if [ -f "mywindowtstvheader.txt" ]; then cp mywindowtstvheader.txt mywindowtstv.${winsize}.${suffix}.txt; else touch mywindowtstv.${winsize}.${suffix}.txt; fi
	fi
	if [[ "$ld_scores" = TRUE ]]
		then
		if [ -f "mywindowld.${winsize}.${suffix}.txt" ]; then rm mywindowld.${winsize}.${suffix}.txt; fi
		if [ -f "mywindowldheader.txt" ]; then cp mywindowldheader.txt mywindowld.${winsize}.${suffix}.txt; else touch mywindowld.${winsize}.${suffix}.txt; fi
		else
		echo "Not calculating linkage disequilibrium scores."
	fi
	
	if [[ "$sample_scores" = TRUE ]]
		then
		nrsamples=$(wc -l myvcfsamples.txt | cut -f1 -d ' ')
		echo "Number of samples:" $nrsamples
		else
		echo "Not calculating sample specific scores."
	fi
	
	if [[ "$admix_scores" = TRUE ]]
		then
		if [ -f "mywindowadmix.${winsize}.${suffix}.txt" ]; then rm mywindowadmix.${winsize}.${suffix}.txt; fi
		touch mywindowadmix.${winsize}.${suffix}.txt
	fi
	
	if [[ "$pop_scores" = TRUE ]]
		then
		nrpops=$(wc -l mypopnames.txt | cut -f1 -d ' ')
		echo "Number of populations:" $nrpops
		if [[ "$poppair_scores" = TRUE ]]
			then
			nrpoppairs=$(wc -l mypopnames.txt | cut -f1 -d ' ')
			echo "Number of population pairs:" $nrpoppairs
			else
			echo "Not calculating population pair scores."
		fi
		else
		echo "Not calculating population scores."
	fi
	
	# How many contigs?
	nrcontigs=$(wc -l mylongcontigs.txt | cut -f1 -d ' ')
	echo "Total number of selected contigs/scaffolds (as specified in the 'mylongcontigs.txt' file):" $nrcontigs
	
	for contignr in $(seq 1 $nrcontigs)
		do
		contigname=$(awk -v myline="$contignr" 'NR==myline' mylongcontigs.txt | cut -f1)
		contiglength=$(awk -v myline="$contignr" 'NR==myline' mylongcontigs.txt | cut -f2)
		echo -e $contignr'\t'$contigname'\t'$contiglength
		contiglength2=$(( $contiglength + $winsize ))
		for endbp in $(seq $winsize $winsize $contiglength2)
			do
			startbp=$(( $endbp - $winsize + 1 ))
			if (( $endbp > $contiglength ))
				then
				endbp=$contiglength
				winsize2=$(( $endbp - $startbp + 1 ))
				else
				winsize2=$winsize
			fi
			# CALCULATE WINDOW STATS:
			$TABIX/tabix ${MYVCF}.bgz ${contigname}:${startbp}-${endbp} > myvcfregion.${winsize}.allcolumns.noindels.txt
			cut -f10- myvcfregion.${winsize}.allcolumns.noindels.txt > myvcfregion.${winsize}.noindels.txt
			cut -f1-9 myvcfregion.${winsize}.allcolumns.noindels.txt > myvcfregion.${winsize}.metainfo.noindels.txt
			totalbp=$(wc -l myvcfregion.${winsize}.metainfo.noindels.txt | cut -f1 -d ' ')
			#
			if [[ "$annotated" = TRUE ]]
				then 
				awk '$5!="A,C,G,T"' myvcfregion.${winsize}.allcolumns.noindels.txt | cut -f 4,5 > myvcfregion.${winsize}.onlypoly.alleles.txt
				awk '$5!="A,C,G,T"' myvcfregion.${winsize}.allcolumns.noindels.txt | cut -f 10- > myvcfregion.${winsize}.onlypoly.txt
				grep -v 'intergenic' -a --no-group-separator myvcfregion.${winsize}.metainfo.noindels.txt > myvcfregion.${winsize}.metainfo.coding.txt
				ncoding=$(wc -l myvcfregion.${winsize}.metainfo.coding.txt | cut -f1 -d ' ')
				awk '$5=="A,C,G,T"' myvcfregion.${winsize}.metainfo.coding.txt > myvcfregion.${winsize}.mono.txt
				awk '$5!="A,C,G,T"' myvcfregion.${winsize}.metainfo.coding.txt > myvcfregion.${winsize}.poly.txt
				low_mono=$(grep 'LOW' myvcfregion.${winsize}.mono.txt | grep -v 'HIGH' | grep -v 'MODERATE' | wc -l | cut -f1 -d ' ')
				low_poly=$(grep 'LOW' myvcfregion.${winsize}.poly.txt | grep -v 'HIGH' | grep -v 'MODERATE' | wc -l | cut -f1 -d ' ')
				high_mono=$(grep 'HIGH' myvcfregion.${winsize}.mono.txt | grep -v 'LOW' | grep -v 'MODERATE' | wc -l | cut -f1 -d ' ')
				high_poly=$(grep 'HIGH' myvcfregion.${winsize}.poly.txt | grep -v 'LOW' | grep -v 'MODERATE' | wc -l | cut -f1 -d ' ')			
				echo -e $contigname'\t'$startbp'\t'$endbp'\t'$totalbp'\t'$ncoding'\t'$low_mono'\t'$low_poly'\t'$high_mono'\t'$high_poly > mywindowhe.${winsize}.tmp.txt
				else
				awk '$5!="."' myvcfregion.${winsize}.allcolumns.noindels.txt | cut -f 4,5 > myvcfregion.${winsize}.onlypoly.alleles.txt
				awk '$5!="."' myvcfregion.${winsize}.allcolumns.noindels.txt | cut -f 10- > myvcfregion.${winsize}.onlypoly.txt
				echo -e $contigname'\t'$startbp'\t'$endbp'\t'$totalbp > mywindowhe.${winsize}.tmp.txt
			fi
			# CALCULATE LD:
			if [[ "$ld_scores" = TRUE ]]
				then 
				cat myvcf.header.txt myvcfregion.${winsize}.allcolumns.noindels.txt > myvcfregion.withheader.vcf
				$VCFTOOLS --vcf myvcfregion.withheader.vcf --geno-r2 --mac 12 --ld-window-bp 1000 --out myldscores
				awk -v FS='\t' '$5!="-nan"' myldscores.geno.ld > myldscores.nonan.txt
				nrsnps=$(wc -l myvcfregion.${winsize}.onlypoly.alleles.txt | cut -f1 -d ' ')
				nrpairs=$(wc -l myldscores.nonan.txt | cut -f1 -d ' ')
				ldmean=$(awk '{ sum += $5; n++ } END { if (n > 0) print sum / n; }' myldscores.nonan.txt )
				distmean=$(awk -v FS='\t' '$6=$3-$2' myldscores.nonan.txt | awk '{ sum += $6; n++ } END { if (n > 0) print sum / n; }')
				echo -e $contigname'\t'$startbp'\t'$endbp'\t'$totalbp'\t'$nrsnps'\t'$nrpairs'\t'$distmean'\t'$ldmean > mywindowld.${winsize}.tmp.txt
				fi
			#
			# CALCULATE 3pop-test score:
			if [[ "$admix_scores" = TRUE ]]
				then
				cat myvcf.header.txt myvcfregion.${winsize}.allcolumns.noindels.txt > myvcfregion.withheader.vcf
				${ADMIXTEST} myvcfregion.withheader.vcf
				sed -i "s/$/\t${contigname}\t${startbp}\t${endbp}/" admixtools.outtable.txt
				cat admixtools.outtable.txt >> mywindowadmix.${winsize}.${suffix}.txt
			fi
			# CALCULATE INDIVIDUAL STATS:
			if [[ "$sample_scores" = TRUE ]]
				then
				for indnr in $(seq 1 $nrsamples)
					do  
					# count number of (missing) data points per individual:
					cut -f$indnr myvcfregion.${winsize}.noindels.txt | grep -v '\./\.' > myvcfcolumn.${winsize}.txt 
					totalsites=$(wc -l myvcfcolumn.${winsize}.txt | cut -f1 -d ' ')
					missingsites=$(( $winsize2 - $totalsites ))
					# count number of heterozygous and alternative homozygous sites per individual:
					if [[ "$biallelic" = TRUE ]]
						then
						heterosites=$(grep '0/1' -a --no-group-separator myvcfcolumn.${winsize}.txt | wc -l | cut -f1 -d ' ')
						althomosites=$(grep '1/1' -a --no-group-separator myvcfcolumn.${winsize}.txt | wc -l | cut -f1 -d ' ')
						else
						if [[ "$haploiddata" = TRUE ]]
							then
							heterosites=0
							althomosites=$(cut -f1 -d ':' myvcfcolumn.${winsize}.txt | grep -v '0' -a --no-group-separator | wc -l | cut -f1 -d ' ')
							else
							heterosites=$(grep '0/1\|0/2\|0/3\|1/2\|1/3\|2/3' -a --no-group-separator myvcfcolumn.${winsize}.txt | wc -l | cut -f1 -d ' ')
							althomosites=$(grep '1/1\|2/2\|3/3' -a --no-group-separator myvcfcolumn.${winsize}.txt | wc -l | cut -f1 -d ' ')
							fi
						heterosites=$(grep '0/1\|0/2\|0/3\|1/2\|1/3\|2/3' -a --no-group-separator myvcfcolumn.${winsize}.txt | wc -l | cut -f1 -d ' ')
						althomosites=$(grep '1/1\|2/2\|3/3' -a --no-group-separator myvcfcolumn.${winsize}.txt | wc -l | cut -f1 -d ' ')
					fi
					# add scores to temporary windowhe file:
					if [[ "$annotated" = TRUE ]]
						then	
						sed -i "s/$/\t${missingsites}\t${totalsites}\t${ncoding}\t${heterosites}\t${althomosites}/" mywindowhe.${winsize}.tmp.txt
						else
						sed -i "s/$/\t${missingsites}\t${totalsites}\t${heterosites}\t${althomosites}/" mywindowhe.${winsize}.tmp.txt
					fi
					done
			fi
			# CALCULATE POPULATION STATS:
			if [[ "$pop_scores" = TRUE ]]
				then
				cut -f1-4 mywindowhe.${winsize}.tmp.txt > mywindowpi.${winsize}.tmp.txt
				cut -f1-4 mywindowhe.${winsize}.tmp.txt > mywindowpoly.${winsize}.tmp.txt
				if [[ "$tstv_scores" = TRUE ]]
					then
					cut -f1-4 mywindowhe.${winsize}.tmp.txt > mywindowtstv.${winsize}.tmp.txt
				fi
				for popnr in $(seq 1 $nrpops)
					do
					# select samples per population:
					mypopname=$(awk -v awkvar="$popnr" 'NR==awkvar' mypopnames.txt)
					awk -v awkvar="$mypopname" '$2==awkvar' $POPFILE | cut -f1 > mypopsamples.txt 
					popcolumns=$(grep -n -f 'mypopsamples.txt' myvcfsamples.txt | cut -f1 -d ':' | tr '\n' ',' | sed 's/.$//')
					npoly=$(wc -l myvcfregion.${winsize}.onlypoly.txt | cut -f1 -d ' ')
					if [[ "$npoly" == 0 ]]
						then
						echo "WARNING: 0 polymorphic sites."
						if [[ "$popnr" == 1 ]]
                            then
                            sed -i "s/$/\t${npoly}\tNA/" mywindowpi.${winsize}.tmp.txt
							echo "NA NA NA NA" > myallelefreqs.txt
							else
                            sed -i "s/$/\tNA/" mywindowpi.${winsize}.tmp.txt
							echo "NA NA NA NA" > myallelefreqs.tmp2.txt
							mv myallelefreqs.tmp2.txt myallelefreqs.txt
                        fi
						else
						cut -f$popcolumns myvcfregion.${winsize}.onlypoly.txt > myvcfregion.pop.vcf
						# allele count:
						perl -lne 'print s/0\/0//g' myvcfregion.pop.vcf | sed 's/^$/0/g' > n00.txt
						perl -lne 'print s/0\/1//g' myvcfregion.pop.vcf | sed 's/^$/0/g' > n01.txt
						perl -lne 'print s/0\/2//g' myvcfregion.pop.vcf | sed 's/^$/0/g' > n02.txt
						perl -lne 'print s/0\/3//g' myvcfregion.pop.vcf | sed 's/^$/0/g' > n03.txt
						perl -lne 'print s/1\/1//g' myvcfregion.pop.vcf | sed 's/^$/0/g' > n11.txt
						perl -lne 'print s/1\/2//g' myvcfregion.pop.vcf | sed 's/^$/0/g' > n12.txt
						perl -lne 'print s/1\/3//g' myvcfregion.pop.vcf | sed 's/^$/0/g' > n13.txt
						perl -lne 'print s/2\/2//g' myvcfregion.pop.vcf | sed 's/^$/0/g' > n22.txt
						perl -lne 'print s/2\/3//g' myvcfregion.pop.vcf | sed 's/^$/0/g' > n23.txt
						perl -lne 'print s/3\/3//g' myvcfregion.pop.vcf | sed 's/^$/0/g' > n33.txt
						perl -lne 'print s/\.\/\.//g' myvcfregion.pop.vcf | sed 's/^$/0/g' > nmiss.txt
						paste n00.txt n01.txt n02.txt n03.txt n11.txt n12.txt n13.txt n22.txt n23.txt n33.txt nmiss.txt > popgenotypes.txt
						# allele counts:
						awk -v OFS='\t' '{ print $1 + $1 + $2 + $3 + $4, $5 + $5 + $2 + $6 + $7, $8 + $8 + $3 + $6 + $9, $10 + $10 + $4 + $7 + $10, $11 + $11 ;  }' popgenotypes.txt > myallelecounts.txt
						awk -v OFS='\t' '{ print $1, $2, $3, $4, $5, $1 + $2 + $3 + $4 ; }' myallelecounts.txt > myallelecounts2.txt
						# allele frequencies:
						awk -v OFS='\t' '{ if($6 != 0) { $7 = $1 / $6; $8 = $2 / $6; $9 = $3 / $6; $10 = $4 / $6  } else {$7 = 0; $8 = 0; $9 = 0; $10 = 0} }1' myallelecounts2.txt | cut -f7- > myallelefreqs.tmp.txt
						# sequence similarity:
						awk -v OFS='\t' '{ $5 = $1 * $1 + $2 * $2 + $3 * $3 + $4 * $4 }1' myallelefreqs.tmp.txt | cut -f5 > myseqsimilarity.tmp.txt
						poppi=$(awk '{ total += $1 } END {print total/NR}' myseqsimilarity.tmp.txt)
						if [[ "$popnr" == 1 ]]
							then
							sed -i "s/$/\t${npoly}\t${poppi}/" mywindowpi.${winsize}.tmp.txt
							mv myallelefreqs.tmp.txt myallelefreqs.txt
							mv myseqsimilarity.tmp.txt myseqsimilarity.txt
							else
							sed -i "s/$/\t${poppi}/" mywindowpi.${winsize}.tmp.txt
							paste myallelefreqs.txt myallelefreqs.tmp.txt > myallelefreqs.tmp2.txt
							mv myallelefreqs.tmp2.txt myallelefreqs.txt
							paste myseqsimilarity.txt myseqsimilarity.tmp.txt > myseqsimilarity.tmp2.txt
							mv myseqsimilarity.tmp2.txt myseqsimilarity.txt
						fi
						# number of polymorphic sites:
						npoppoly=$(grep -a -w -v '1' myallelefreqs.txt | wc -l | cut -f1 -d ' ')
						npopmono=$(grep -a -w '1' myallelefreqs.txt | grep -v 'NA' | wc -l | cut -f1 -d ' ')
						npopna=$(grep -a 'NA' myallelefreqs.txt | wc -l | cut -f1 -d ' ')
						if [[ "$popnr" == 1 ]]
							then
							sed -i "s/$/\t${npoly}\t${npoppoly}\t${npopmono}\t${npopna}/" mywindowpoly.${winsize}.tmp.txt
							else
							sed -i "s/$/\t${npoppoly}\t${npopmono}\t${npopna}/" mywindowpoly.${winsize}.tmp.txt
						fi
					fi
					done
				# CALCULATE PAIRWISE POPULATION STATS (Dxy):
				if [[ "$poppair_scores" = TRUE ]]
					then
					for pairnr in $(seq 1 $npairwise)
						do
						pop1=$(awk -v awkvar="$pairnr" 'NR==awkvar' allpoppairs.txt | cut -f1)
						pop2=$(awk -v awkvar="$pairnr" 'NR==awkvar' allpoppairs.txt | cut -f2)
						firstcol1=$(( $pop1 * 4 - 4 + 1 ))
						lastcol1=$(( $pop1 * 4 ))
						firstcol2=$(( $pop2 * 4 - 4 + 1 ))
						lastcol2=$(( $pop2 * 4 ))
						pop1cols=$(seq $firstcol1 $lastcol1 | tr '\n' ',' | sed 's/.$//')
						pop2cols=$(seq $firstcol2 $lastcol2 | tr '\n' ',' | sed 's/.$//')
						cut -f$pop1cols myallelefreqs.txt > popfreqs1.txt
						cut -f$pop2cols myallelefreqs.txt > popfreqs2.txt
						paste popfreqs1.txt popfreqs2.txt > pairfreqs.txt
						# sequence similarity:
						awk -v OFS='\t' '{ $9 = $1 * $5 + $2 * $6 + $3 * $7 + $4 * $8 }1' pairfreqs.txt | cut -f9 > mydxy.txt
						poppairdxy=$(awk '{ total += $1 } END {print total/NR}' mydxy.txt)
						sed -i "s/$/\t${poppairdxy}/" mywindowpi.${winsize}.tmp.txt
						# transition similarity biallelic alleles:
						if [[ "$tstv_scores" = TRUE ]]
							then
							paste myvcfregion.${winsize}.onlypoly.alleles.txt pairfreqs.txt | grep -a -v ',' > pairfreqs.bialleles.txt
							awk '$1 == "A" && $2 == "G" || $1 == "G" && $2 == "A" || $1 == "C" && $2 == "T" || $1 == "T" && $2 == "C"' pairfreqs.bialleles.txt | cut -f3- > pairfreqs.ts.txt
							awk '$1 == "A" && $2 == "C" || $1 == "C" && $2 == "A" || $1 == "A" && $2 == "T" || $1 == "T" && $2 == "A" || $1 == "G" && $2 == "C" || $1 == "C" && $2 == "G" || $1 == "G" && $2 == "T" || $1 == "T" && $2 == "G"' pairfreqs.bialleles.txt | cut -f3- > pairfreqs.tv.txt
							awk -v OFS='\t' '{ $9 = $1 * $2 + $5 * $6 }1' pairfreqs.ts.txt | cut -f9 > mymeanpopts.txt
							awk -v OFS='\t' '{ $9 = $1 * $2 + $5 * $6 }1' pairfreqs.tv.txt | cut -f9 > mymeanpoptv.txt
							awk -v OFS='\t' '{ $9 = $1 * $6 + $6 * $1 }1' pairfreqs.ts.txt | cut -f9 > mypairts.txt
							awk -v OFS='\t' '{ $9 = $1 * $6 + $6 * $1 }1' pairfreqs.tv.txt | cut -f9 > mypairtv.txt
							meanpopts=$(awk '{ total += $1 } END {print total/NR}' mymeanpopts.txt)
							meanpoptv=$(awk '{ total += $1 } END {print total/NR}' mymeanpoptv.txt)
							poppairts=$(awk '{ total += $1 } END {print total/NR}' mypairts.txt)
							poppairtv=$(awk '{ total += $1 } END {print total/NR}' mypairtv.txt)
							if [[ "$pairnr" == 1 ]]
								then
								nts=$(wc -l pairfreqs.ts.txt | cut -f1 -d ' ')
								ntv=$(wc -l pairfreqs.tv.txt | cut -f1 -d ' ')
								sed -i "s/$/\t${npoly}\t${nts}\t${ntv}\t${meanpopts}\t${meanpoptv}\t${poppairts}\t${poppairtv}/" mywindowtstv.${winsize}.tmp.txt
								else
								sed -i "s/$/\t${meanpopts}\t${meanpoptv}\t${poppairts}\t${poppairtv}/" mywindowtstv.${winsize}.tmp.txt
							fi
						fi
						done
				fi
			fi
			# ADD STATS TO EXISTING FILE (containing stats for previous windows):
			cat mywindowhe.${winsize}.tmp.txt >> mywindowhe.${winsize}.${suffix}.txt
			if [[ "$pop_scores" = TRUE ]]
				then
				cat mywindowpoly.${winsize}.tmp.txt >> mywindowpoly.${winsize}.${suffix}.txt
				cat mywindowpi.${winsize}.tmp.txt >> mywindowpi.${winsize}.${suffix}.txt
				if [[ "$tstv_scores" = TRUE ]]
					then
					cat mywindowtstv.${winsize}.tmp.txt >> mywindowtstv.${winsize}.${suffix}.txt
				fi
			fi
			if [[ "$ld_scores" = TRUE ]]
				then
				cat mywindowld.${winsize}.tmp.txt >> mywindowld.${winsize}.${suffix}.txt
			fi
			done
		done
	
	# REMOVE INTERMEDIATE FILES:
	rm myvcf.header.txt myvcfregion*noindels.txt mywindowhe*tmp.txt
	
	if [[ "$sample_scores" = TRUE ]]
		then
		rm myvcfcolumn*txt
	fi
	
	if [[ "$ld_scores" = TRUE ]]
		then
		rm myldscores.geno.ld myldscores.nonan.txt myldscores.log myvcfregion.withheader.vcf 
	fi
	
	if [[ "$pop_scores" = TRUE ]]
		then
		rm allpoppairs.txt myallelefreqs.tmp.txt myallelefreqs.txt mypopnames.txt mypopsamples.txt mywindowpi*tmp.txt mywindowpiheader.txt 
		rm n00.txt n01.txt n02.txt n03.txt n11.txt n12.txt n13.txt n22.txt n23.txt n33.txt nmiss.txt popgenotypes.txt myallelecounts.txt myallelecounts2.txt myseqsimilarity.tmp.txt myseqsimilarity.txt  	
		rm mywindowpolyheader.txt  mywindowpoly*tmp.txt myvcfregion.pop.vcf myvcfregion*onlypoly.txt myvcfregion*onlypoly.alleles.txt
		if [[ "$poppair_scores" = TRUE ]]
			then
			pairfreqs.txt popfreqs1.txt popfreqs2.txt mydxy.txt pairfreqs.bialleles.txt
		fi
		if [[ "$tstv_scores" = TRUE ]]
			then
			rm mymeanpopnrs.ts.tmp.txt mymeanpopnrs.tv.tmp.txt mymeanpopts.txt mymeanpoptv.txt mypairts.txt mypairtv.txt mywindowtstv*tmp.txt mywindowtstvheader.txt pairfreqs.ts.txt pairfreqs.tv.txt
		fi
	fi
	
	echo "Analysis finished."
	else
	echo "Flag run_loop is set to FALSE. Not running analyses. Exiting."
fi





################################################

