import matplotlib.cm
import matplotlib.pyplot as plt
import pandas as pd
import matplotlib.patches as mpatches

PATH = "../convergence/"
FORM = "fes_x_y.dat"

cmap = [matplotlib.cm.get_cmap("Oranges"), matplotlib.cm.get_cmap("Greens")]

for x in range(20, 120, 20):
    for i, direction in enumerate(["forward", "reverse"]):
        filename = PATH + FORM.replace("x", str(x)).replace("y", direction)
        data = pd.read_table(filename, header=None, comment="#")
        plt.plot(data[0], data[1], color=cmap[i](x / 100))


orange_patch = mpatches.Patch(color="orange", label="Forward")
green_patch = mpatches.Patch(color="green", label="Reverse")
plt.legend(handles=[orange_patch, green_patch], loc="upper center")

plt.xlabel("DFG-loop DRMSD / nm")
plt.ylabel("PMF / kcal mol$^{-1}$")
plt.savefig("convergence.pdf")
plt.show()
