import matplotlib.cm
import matplotlib.pyplot as plt
import pandas as pd
import matplotlib.patches as mpatches
import numpy as np

PATH = ["../opening/convergence/", "../closing/convergence/"]
LABELS = ["DFG-in → DFG-out", "DFG-out → DFG-in"]
FORM = "fes_x_y.dat"
colors = ['C0', 'C1', 'C2']

patches = []


fig = plt.figure(figsize=(3.15,3.15))
plt.rcParams['font.size'] = '11'
plt.rcParams['font.family'] = 'sans-serif'

for i in range(len(PATH)):
    middle_line = pd.read_table(PATH[i] + "fes_100_forward.dat", header=None, comment="#")
    forward_60 = pd.read_table(PATH[i] + "fes_60_forward.dat", header=None, comment="#")
    reverse_60 = pd.read_table(PATH[i] + "fes_60_reverse.dat", header=None, comment="#")

    plt.plot(middle_line[0], middle_line[1], color=colors[i])

    min_line = np.amin([forward_60[1], reverse_60[1],middle_line[1]],axis=0)
    max_line = np.amax([forward_60[1], reverse_60[1],middle_line[1]],axis=0)
    
    plt.fill_between(forward_60[0],min_line,max_line, color=colors[i], alpha=0.15)
    patches.append(mpatches.Patch(color=colors[i], label=LABELS[i]))

plt.legend(handles=patches, loc="upper left")

plt.xlabel("DFG-loop DRMSD / nm")
plt.ylabel("PMF / kcal mol$^{-1}$")
plt.xlim(-0.65,0.65)
plt.ylim(-1,18)
plt.text(-0.6,6,"DFG-in")
plt.text(0.08,2.52,"DFG-out")
plt.tight_layout()
plt.savefig("fes_comparison.pdf")
plt.show()
