import matplotlib.cm
import matplotlib.pyplot as plt
import pandas as pd
import matplotlib.patches as mpatches

PATH = "../convergence/"
FORM = "fes_x_y.dat"

cmap = [matplotlib.cm.get_cmap("Oranges"), matplotlib.cm.get_cmap("Greens")]


data_full = pd.read_table(PATH+"fes_100_forward.dat", header=None, comment="#")
plt.plot(data_full[0], data_full[1])

data_60_forward = pd.read_table(PATH+"fes_60_forward.dat", header=None, comment="#")
data_60_reverse = pd.read_table(PATH+"fes_60_reverse.dat", header=None, comment="#")

plt.fill_between(data_full[0], data_60_forward[1], data_60_reverse[1], alpha=0.3)


plt.xlabel("LID-NMP distance / nm")
plt.ylabel("PMF / kcal mol$^{-1}$")
plt.savefig("fes.pdf")
plt.show()
