# Author: Benoit Tabone, benoit.tabone@universite-paris-saclay.fr
# This script plots fig. 2 presented in Tabone et al. 2023, Nat. Astro. from the data file J160532_fig2_Tabone23.dat
# It shows the spectral region where benzene, CO2 and C4H2 are detected by MIRI-MRS toward J160532 with the best fit models

import os,sys
import numpy as np
import matplotlib.pyplot as plt



###### Figure 2 ######
fig, ax = plt.subplots(2,1,figsize=(12,5),sharex=True,sharey=True)
plt.rcParams['mathtext.default'] = 'regular'


wlth_obs                = np.loadtxt("J160532_fig2_Tabone23.dat", usecols=0,skiprows=5)
flux_obs                = np.loadtxt("J160532_fig2_Tabone23.dat", usecols=1,skiprows=5)
flux_tot_mod_resampled  = np.loadtxt("J160532_fig2_Tabone23.dat", usecols=2,skiprows=5)
flux_resampled_CO2      = np.loadtxt("J160532_fig2_Tabone23.dat", usecols=3,skiprows=5)
flux_resampled_13CO2    = np.loadtxt("J160532_fig2_Tabone23.dat", usecols=4,skiprows=5)
flux_resampled_C6H6     = np.loadtxt("J160532_fig2_Tabone23.dat", usecols=5,skiprows=5)
flux_resampled_C4H2     = np.loadtxt("J160532_fig2_Tabone23.dat", usecols=6,skiprows=5)




fig.subplots_adjust(bottom=0.4,left=0.5,hspace=.5,wspace=.5)
fig.tight_layout()

ax[0].tick_params(axis='both', which='major', labelsize=14)
ax[0].minorticks_on()

ax[0].fill_between(wlth_obs,flux_tot_mod_resampled,step='mid',lw=1.5,color='firebrick',zorder=0,alpha=0.5)
ax[0].step(wlth_obs,flux_obs,'k',lw=1.5,where='mid', label='Continuum subtracted spectrum')


####### Zoom-in #########
ax[1].tick_params(axis='both', which='major', labelsize=14)
ax[1].minorticks_on()
ax[1].set_xlabel('Wavelength [$\mu$m]', fontsize=14)
ax[1].set_ylabel('Flux above the continuum [mJy]', fontsize=14)


ax[1].fill_between(wlth_obs,flux_resampled_CO2,step='mid',lw=1.5,color='darkblue',zorder=0,alpha=0.9)
ax[1].fill_between(wlth_obs,flux_resampled_13CO2,step='mid',lw=1.5,color='blue',zorder=0,alpha=0.9)
ax[1].fill_between(wlth_obs,flux_resampled_C4H2,step='mid',lw=1.5,color='darkorange',zorder=0,alpha=0.65)
ax[1].fill_between(wlth_obs,flux_resampled_C6H6,step='mid',lw=1.5,color='red',zorder=0,alpha=0.6)


fig.tight_layout()



plt.show()




