# Author: Benoit Tabone, benoit.tabone@universite-paris-saclay.fr
# This script plots fig. 1 presented in Tabone et al. 2023, Nat. Astro. from the data file J160532_fig1_Tabone23.dat
# It shows the spectral region where prominent C2H2 is detected by MIRI-MRS toward J160532
# The spectrum is well reproduced by 2 components of C2H2: a compact and highly optically thick and a more extended and optically thinner component.

import os,sys
import numpy as np
import matplotlib.pyplot as plt



###### Figure 1 ######


# Create the figure
fig, ax = plt.subplots(1,1,figsize=(9,5),sharex=True,sharey=True)
plt.rcParams['mathtext.default'] = 'regular'

# Load the MIRI-MRS spectrum and the best fit models
wlth_obs                  = np.loadtxt("J160532_fig1_Tabone23.dat", usecols=0,skiprows=4)
flux_obs                  = np.loadtxt("J160532_fig1_Tabone23.dat", usecols=1,skiprows=4)
flux_tot_mod_resampled    = np.loadtxt("J160532_fig1_Tabone23.dat", usecols=2,skiprows=4)
flux_resampled_C2H2_thick = np.loadtxt("J160532_fig1_Tabone23.dat", usecols=3,skiprows=4)


fig.subplots_adjust(bottom=0.4,left=0.5,hspace=.5,wspace=.5)
fig.tight_layout()
ax.tick_params(axis='both', which='major', labelsize=14)
ax.minorticks_on()

ax.fill_between(wlth_obs,flux_tot_mod_resampled,step='mid',lw=1.5,color='firebrick',zorder=0,alpha=0.5)
ax.step(wlth_obs,flux_obs,'k',lw=1.5,where='mid', label='Continuum subtracted spectrum')
ax.step(wlth_obs,flux_resampled_C2H2_thick,'b',lw=1.5,where='mid', label='Continuum subtracted spectrum')


ax.set_xlabel('Wavelength [$\mu$m]', fontsize=14)
ax.set_ylabel('Flux above the continuum [mJy]', fontsize=14)
ax.set_xlim((12.8,14.8))



fig.tight_layout()






plt.show()




