<div align="center">
  <img src="./images/SG - Horizontal Glow 2.png" width="600"/>
 <br/><br/>
  

</div>


# SuperGradients

## Introduction
Welcome to SuperGradients, a free, open-source training library for PyTorch-based deep learning models.
SuperGradients allows you to train or fine-tune SOTA pre-trained models for all the most commonly applied computer vision tasks with just one training library. We currently support object detection, image classification and semantic segmentation for videos and images.


## Why use SuperGradients?
 
### Built-in SOTA Models

Easily load and fine-tune production-ready, [pre-trained SOTA models](model_zoo.md) that incorporate best practices and validated hyper-parameters for achieving best-in-class accuracy (Yolox, PP-YoloE, STDC, DDRNet, and PP-LiteSeg).

### Easily Reproduce our Results
       
Why do all the grind work, if we already did it for you? leverage tested and proven [recipes](https://github.com/Deci-AI/super-gradients/tree/master/src/super_gradients/recipes) & [code examples](https://github.com/Deci-AI/super-gradients/tree/master/src/super_gradients/examples) for a wide range of computer vision models generated by our team of deep learning experts. Easily configure your own or use plug & play hyperparameters for training, dataset, and architecture.
    
### Production Readiness and Ease of Integration
    
All SuperGradients models’ are production ready in the sense that they are compatible with deployment tools such as TensorRT (Nvidia) and OpenVINO (Intel) and can be easily taken into production. With a few lines of code you can easily integrate the models into your codebase.
   
## Getting Started
Check out our [Quickstart tutorial](QuickstartBasicToolkit.md) to get learn the basic of SuperGradients.

You can also start from our tutorial on [Detection](ObjectDetection.md), [Segmentation](Segmentation.md) or [Pose Estimation](PoseEstimation.md).
 
## What's New
__________________________________________________________________________________________________________
* 【1/3/2023】 Lion optimizer was added  
* 【27/2/2023】 Pose Estimation models and utilities were added to SuperGradients! 
* 【20/2/2023】 PP-Yolo-E implementation 
* 【17/1/2023】 Quantization Aware Training (QAT) and Post Training Quantization (PTQ) - including selective quantization 
* 【17/11/2022】 Integration with ClearML
* 【06/9/2022】 PP-LiteSeg - new pre-trained [checkpoints](http://bit.ly/3EGfKD4) and [recipes](http://bit.ly/3gfLw07) for Cityscapes with SOTA mIoU scores (~1.5% above paper)🎯
* 【07/08/2022】DDRNet23 - new pre-trained [checkpoints](http://bit.ly/3EGfKD4) and [recipes](http://bit.ly/3gfLw07) for Cityscapes with SOTA mIoU scores (~1% above paper)🎯
* 【27/07/2022】YOLOX models (object detection) - recipes and pre-trained checkpoints.
* 【07/07/2022】SSD Lite MobileNet V2,V1 - Training [recipes](http://bit.ly/3gfLw07) and pre-trained [checkpoints](http://bit.ly/3EGfKD4) on COCO - Tailored for edge devices! 📱
* 【07/07/2022】 STDC  - new pre-trained [checkpoints](http://bit.ly/3EGfKD4) and [recipes](http://bit.ly/3gfLw07) for Cityscapes with super SOTA mIoU scores (~2.5% above paper)🎯

Check out SG full [release notes](https://github.com/Deci-AI/super-gradients/releases).

## Coming soon
__________________________________________________________________________________________________________

- [ ] Tools for faster training 
- [ ] Tools for training health monitoring 
- [ ] Integration with more professional 3rd party tools.
- [ ] SegFormers
## Citation

If you are using SuperGradients library in your research, please cite SuperGradients deep learning training library.


[//]: # (### BibTeX)

[//]: # ()
[//]: # (```bibtex)

[//]: # (@misc{rw2019timm,)

[//]: # (  title = {SuperGradients},)

[//]: # (  year = {2021},)

[//]: # (  publisher = {GitHub},)

[//]: # (  journal = {GitHub repository},)

[//]: # (  doi = {},)

[//]: # (  howpublished = {\url{https://github.com/Deci-AI/super-gradients}})

[//]: # (})

[//]: # (```)

[//]: # ()
[//]: # (### Latest DOI)

[//]: # ()
[//]: # ([![DOI]&#40;https://zenodo.org/badge/.svg&#41;]&#40;https://zenodo.org/badge/latestdoi/&#41;)

## Community

If you want to be a part of SuperGradients growing community, hear about all the exciting news and updates, need help, request for advanced features,
    or want to file a bug or issue report, we would love to welcome you aboard!

* Slack is the place to be and ask questions about SuperGradients and get support. [Click here to join our Slack](
  https://join.slack.com/t/supergradients-comm52/shared_invite/zt-10vz6o1ia-b_0W5jEPEnuHXm087K~t8Q)
    
* To report a bug, [file an issue](https://github.com/Deci-AI/super-gradients/issues) on GitHub.

* Join the [SG Newsletter](https://www.supergradients.com/#Newsletter)
  for staying up to date with new features and models, important announcements, and upcoming events.

## License

This project is released under the [Apache 2.0 license](LICENSE).
    
## Citing

### BibTeX

```bibtex
@misc{supergradients,
  doi = {10.5281/ZENODO.7789328},
  url = {https://zenodo.org/record/7789328},
  author = {Aharon,  Shay and {Louis-Dupont} and {Ofri Masad} and Yurkova,  Kate and {Lotem Fridman} and {Lkdci} and Khvedchenya,  Eugene and Rubin,  Ran and Bagrov,  Natan and Tymchenko,  Borys and Keren,  Tomer and Zhilko,  Alexander and {Eran-Deci}},
  title = {Super-Gradients},
  publisher = {GitHub},
  journal = {GitHub repository},
  year = {2021},
}
```

### Latest DOI

[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.7789328.svg)](https://doi.org/10.5281/zenodo.7789328)
