/*This do file creates the Figure 2 schematic (showing how
benefits of SNAP are expected to occur w/ equal and unequal 
returns by age*/

*Prelims
clear
set more off, perm
cap log close



*Create data
import excel using "fig2schematic.xlsx", ///
	firstrow clear

** Label one
g twenty24 = 24
g twenty23 = 23
g twenty22 = 22
g twenty21 = 21

g varlab0 = "Cohorts" if age == -1
g varlab1 = "in counties" if age == -1
g varlab2 = "with FSP before" if age == -1
g varlab3 = "conception" if age == -1



sort age
drop if age > 18

tw 	line ben_uneq age, 						///
		lcolor(navy) lpattern(solid) 	|| 	///
	line ben_eq age, 						///
		lcolor(maroon) lpattern(dash) 	|| 	///
	line ben_uneq_post5 age, 				///
		lcolor(blue) lpattern(dot) 		||	///
	scatter twenty24 age, 					///
		msymbol(i) xaxis(2) 				///
		mlabel(varlab0) 					///
		mlabcolor(black) 					///
		mlabsize(small)						///
		mlabposition(10)      			|| 	///
	scatter twenty23 age, 					///
		msymbol(i)  xaxis(2) 				///
		mlabel(varlab1) 					///
		mlabcolor(black) 					///
		mlabsize(small)						///
		mlabposition(10) 				|| 	///
	scatter twenty22 age, 					///
		msymbol(i) xaxis(2) 				///
		mlabel(varlab2) 					///
		mlabcolor(black) 					///
		mlabsize(small)						///
		mlabposition(10) 				|| 	///
	scatter twenty21 age, 					///
		msymbol(i) xaxis(2) 				///
		mlabel(varlab3) 					///
		mlabcolor(black) 					///
		mlabsize(small)						///
		mlabposition(10) 					///	
	 text( 7 -3 "Born prior" "to FSP",  	///
		 size(small) box just(left) 		///
		 fcolor(none) lwidth(vthin) 		///
		 margin(small) )					///
	ytitle("Effect of FSP on cohort") 		///
	ylabel(0(5)25, 							///
		notick labc(white) nogrid) 			///
	xtitle("Age at Food Stamps Rollout in County of Birth") ///
	xlab(-5(5)18) 							///
	xsc(lcolor(black) axis(1) ) 			///
	xtitle(" ", axis(2)) 					///
	xlabel(-1 "Conception",	labsize(small) notick axis(2)) ///
	xline(-1, lcolor(black) lpattern(dash)) xsc(lcolor(white) axis(2) ) ///
	legend(order(1 2 3) 										///
		label(1 "Exposure at early ages matters more") 			///
		label(2 "Each year of exposure matters equally") 		///
		label(3 "Exposure in later childhood doesn't matter") 	///
		region(lstyle(none)) 									///
		size(small) rows(3)) 									///
	graphregion(fcolor(white) color(white) icolor(white))

gr save "$output/Figureschematic.gph", replace
cap gr export "$output/Figureschematic.png", replace
cap gr export "$output/Figureschematic.pdf", replace
cap gr export "$output/Figureschematic.eps", replace

cap log close



		
