/******************************************************************************/
/* Code to produce several tables in "Is the Social Safety Net a Long-Term Investment?
 Large-Scale Evidence from the Food Stamps Program,” 
 by Martha J. Bailey, Hilary Hoynes, Maya Rossin-Slater, and Reed Walker	
 
 The inputs are Excel files with results disclosed from the RDC*/
 /******************************************************************************/

ssc install labutil
ssc install sxpose
ssc install gtools
gtools, upgrade

/*******************************************************************************
* Utilities
*******************************************************************************/
* Label the subindices
cap prog drop subindex
prog def subindex
	args grp subi num l1 l2 l3 l4 l5 l6 l7
	cap g subindex = ""
	local label = ""
	forvalues x = 1/7 {
		local label = "`label' " + "`l`x'' "
		}
		local label = strtrim(subinstr("`label'", "  ", " ", .))
	replace subindex = "`label'" if VARIABLES == "`subi'_`num'_`grp'"
end

*** Label the subindices for the subgroup analysis (no group id needed)
cap prog drop subindex2
prog def subindex2
	args subi num l1 l2 l3 l4 l5 l6 l7
	cap g subindex = ""
	local label = ""
	forvalues x = 1/7 {
		local label = "`label' " + "`l`x'' "
		}
		local label = strtrim(subinstr("`label'", "  ", " ", .))
	replace subindex = "`label'" if VARIABLES == "`subi'_`num'"
end

*** Tidy program for subindices
cap program drop tidy
program define tidy
	args grp table

	** Import
	import excel "fs_subindices_`grp'_normalizedNo.xls", cellrange(A2) clear
	
	** Drop blank or irrelevant rows
	keep if inlist(_n, 1, 3, 4, 12, 13, 14, 15)

	** Clean up
	replace A= "se" if A==""
	
	** Transpose
	sxpose, clear

	** Move first row to variable names
	forval i = 1/7 { 
		 local name = strtoname(_var`i'[1]) 
		 capture rename _var`i'  `name' 
	}

	drop in 1

	** Drop duplicate row
	
	** Clean up
	rename shareFSPageIU_5 b
	destring *, replace

	*Label variables

	subindex `grp' hc 1		Yrs schooling
	subindex `grp' hc 2 		HS/GED or more
	subindex `grp' hc 3		Some college or more
	subindex `grp' hc 4		4 yrs college or more
	subindex `grp' hc 5		Graduate degree or more
	subindex `grp' hc 6		Professional occupation

	subindex `grp' ess 1		In labor force
	subindex `grp' ess 2		Worked last yr
	subindex `grp' ess 3 		# wks worked last yr
	subindex `grp' ess 4 		Usual hrs worked/wk
	subindex `grp' ess 5		Log labor income
	subindex `grp' ess 6		Log non-labor income, excl public source
	subindex `grp' ess 8		Log fam income to pov
	subindex `grp' ess 9		Not in pov
	subindex `grp' ess 10		-1 x Log(public source income)
	subindex `grp' ess 5_1	Labor income >0
	subindex `grp' ess 6_1	Non-labor income excl public source >0
	subindex `grp' ess 8_1 	Family income >0
	subindex `grp' ess 10_1	No public source income

	subindex `grp' nei 1		Log house value
	subindex `grp' nei 2		Log gross rent
	subindex `grp' nei 3		Home ownership
	subindex `grp' nei 4		Single family residence
	subindex `grp' nei 5		Log mean fam income to pov (tract)
	subindex `grp' nei 6		-1 x teen pregnancy rate (tract)
	subindex `grp' nei 7 		-1 x share single HOH (tract)
	subindex `grp' nei 8		-1 x child pov rate (tract)
	subindex `grp' nei 9		Mean home ownership (tract)
	subindex `grp' nei 10		Log median value of home (tract)
	subindex `grp' nei 11		Log median gross rent (tract)
	subindex `grp' nei 12		Absolute upward mobility (CH)

	subindex `grp' nei 1_1 	House value >0
	subindex `grp' nei 5_1 	Mean fam income (tract) >0

	subindex `grp' dis 1		No work disability
	subindex `grp' dis 2 		No ambulatory difficulty
	subindex `grp' dis 3		No cognitive difficulty
	subindex `grp' dis 4		No independent learning difficulty
	subindex `grp' dis 5		No vision/hearing difficulty
	subindex `grp' dis 6 		No self-care difficulty

	gen order = .
	local n = 1
	local v1 "hc_1 hc_2 hc_3 hc_4 hc_5 hc_6"
	local v2 "ess_1	ess_2 ess_3 ess_4 ess_5 ess_6 ess_8	ess_9 ess_10"
	local v3 "ess_5_1 ess_6_1 ess_8_1 ess_10_1"
	local v4 "nei_1	nei_2 nei_3	nei_4 nei_5	nei_6 nei_7 nei_8 nei_9 nei_10 nei_11 nei_12"
	local v5 "nei_1_1 nei_5_1"
	local v6 "dis_1	dis_2 dis_3	dis_4 dis_5	dis_6"
	local vars "`v1' `v2' `v3' `v4' `v5' `v6'"
	foreach var in `vars' {
		replace order = `n' if VARIABLES=="`var'_`grp'"
		qui sum order
		if `r(max)'==`n' local n = `n'+1
	}
	sort order
	
	drop if order==.
	drop in 13 // ad hoc; get rid of duplicate row
	
end

*** Tidy program for the Romano-Wolf p-values
cap program drop tidy_rw
program define tidy_rw
	args index grp table

	** Import
	import excel "rwolf_`index'_`grp'_subindices.xls", cellrange(A2) /*firstrow*/ clear

	** Transpose
	tostring *, replace
	sxpose, clear
	
	** Move first row to variable names
	/*
	forval i = 1/2 { 
		 local name = strtoname(_var`i'[1]) 
		 capture rename _var`i'  `name' 
	}
	*/
	
	drop in 1
	rename _var1 VARIABLES
	rename _var2 rw_p_`grp'
	destring rw_p_`grp', replace

	** Clean up

	*Label variables
	if "`index'" == "hc"{
		subindex `grp' hc 1		Yrs schooling
		subindex `grp' hc 2 		HS/GED or more
		subindex `grp' hc 3		Some college or more
		subindex `grp' hc 4		4 yrs college or more
		subindex `grp' hc 5		Graduate degree or more
		subindex `grp' hc 6		Professional occupation
	}

	*local index ess
	*local grp all
	if "`index'" == "ess"{
		subindex `grp' ess 1		In labor force
		subindex `grp' ess 2		Worked last yr
		subindex `grp' ess 3 		# wks worked last yr
		subindex `grp' ess 4 		Usual hrs worked/wk
		subindex `grp' ess 5		Log labor income
		subindex `grp' ess 6		Log non-labor income, excl public source
		subindex `grp' ess 8		Log fam income to pov
		subindex `grp' ess 9		Not in pov
		subindex `grp' ess 10		-1 x Log(public source income)
		subindex `grp' ess 5_1	Labor income >0
		subindex `grp' ess 6_1	Non-labor income excl public source >0
		subindex `grp' ess 8_1 	Family income >0
		subindex `grp' ess 10_1	No public source income
	}

	if "`index'" == "nei"{
		subindex `grp' nei 1		Log house value
		subindex `grp' nei 2		Log gross rent
		subindex `grp' nei 3		Home ownership
		subindex `grp' nei 4		Single family residence
		subindex `grp' nei 5		Log mean fam income to pov (tract)
		subindex `grp' nei 6		-1 x teen pregnancy rate (tract)
		subindex `grp' nei 7 		-1 x share single HOH (tract)
		subindex `grp' nei 8		-1 x child pov rate (tract)
		subindex `grp' nei 9		Mean home ownership (tract)
		subindex `grp' nei 10		Log median value of home (tract)
		subindex `grp' nei 11		Log median gross rent (tract)
		subindex `grp' nei 12		Absolute upward mobility (CH)

		subindex `grp' nei 1_1 	House value >0
		subindex `grp' nei 5_1 	Mean fam income (tract) >0
	}

	if "`index'" == "dis"{
		subindex `grp' dis 1		No work disability
		subindex `grp' dis 2 		No ambulatory difficulty
		subindex `grp' dis 3		No cognitive difficulty
		subindex `grp' dis 4		No independent learning difficulty
		subindex `grp' dis 5		No vision/hearing difficulty
		subindex `grp' dis 6 		No self-care difficulty
	}
	
	drop VARIABLES
	
end

*** Tidy program for the p-values from testing whether differences in subgroups are statistically significant (relative to white males)
cap program drop tidy_subgroups_subindices
program define tidy_subgroups_subindices
	args index table
	
	** Import
	import excel "test_`index'_subindices_subgroups_new_repaired.xlsx", clear

	** Transpose
	tostring *, replace
	sxpose, clear
	
	** Move first row to variable names
	drop in 1
	rename _var1 VARIABLES
	drop _var2 _var7
	rename _var3 sb_p_wm
	rename _var4 sb_p_wf
	rename _var5 sb_p_nm
	rename _var6 sb_p_nf
	destring sb_*, replace
	
	
	
	foreach group in wf nm nf {
	gen sb_stars_`group' = ""
	replace sb_stars_`group' = "*" if sb_p_`group' < 0.1
	replace sb_stars_`group' = "**" if sb_p_`group' < 0.05
	replace sb_stars_`group' = "***" if sb_p_`group' < 0.01
	}

	** Clean up

	*Label variables
	if "`index'" == "hc"{
		subindex2 hc 1		Yrs schooling
		subindex2 hc 2 		HS/GED or more
		subindex2 hc 3		Some college or more
		subindex2 hc 4		4 yrs college or more
		subindex2 hc 5		Graduate degree or more
		subindex2 hc 6		Professional occupation
	}

	if "`index'" == "ess"{
		subindex2 ess 1		In labor force
		subindex2 ess 2		Worked last yr
		subindex2 ess 3 		# wks worked last yr
		subindex2 ess 4 		Usual hrs worked/wk
		subindex2 ess 5		Log labor income
		subindex2 ess 6		Log non-labor income, excl public source
		subindex2 ess 8		Log fam income to pov
		subindex2 ess 9		Not in pov
		subindex2 ess 10		-1 x Log(public source income)
		subindex2 ess 5_1	Labor income >0
		subindex2 ess 6_1	Non-labor income excl public source >0
		subindex2 ess 8_1 	Family income >0
		subindex2 ess 10_1	No public source income
	}

	if "`index'" == "nei"{
		subindex2 nei 1		Log house value
		subindex2 nei 2		Log gross rent
		subindex2 nei 3		Home ownership
		subindex2 nei 4		Single family residence
		subindex2 nei 5		Log mean fam income to pov (tract)
		subindex2 nei 6		-1 x teen pregnancy rate (tract)
		subindex2 nei 7 		-1 x share single HOH (tract)
		subindex2 nei 8		-1 x child pov rate (tract)
		subindex2 nei 9		Mean home ownership (tract)
		subindex2 nei 10		Log median value of home (tract)
		subindex2 nei 11		Log median gross rent (tract)
		subindex2 nei 12		Absolute upward mobility (CH)

		subindex2 nei 1_1 	House value >0
		subindex2 nei 5_1 	Mean fam income (tract) >0
	}

	if "`index'" == "dis"{
		subindex2 dis 1		No work disability
		subindex2 dis 2 		No ambulatory difficulty
		subindex2 dis 3		No cognitive difficulty
		subindex2 dis 4		No independent learning difficulty
		subindex2 dis 5		No vision/hearing difficulty
		subindex2 dis 6 		No self-care difficulty
	}
	
	drop VARIABLES
	
end


*** Tidy program for the p-values from testing whether differences in subgroups are statistically significant (relative to white males)
cap program drop tidy_subgroups
program define tidy_subgroups
	args index table
	
	*local index LE3
	
	** Import
	import excel "test_`index'_subgroups.xlsx", clear

	** Transpose
	tostring *, replace
	sxpose, clear
	
	** Move first row to variable names
	drop in 1
	rename _var1 index
	drop _var2 _var7
	rename _var3 sb_p_wm
	rename _var4 sb_p_wf
	rename _var5 sb_p_nm
	rename _var6 sb_p_nf
	destring sb_*, replace
	

	
	foreach group in wf nm nf {
	gen sb_stars_`group' = ""
	replace sb_stars_`group' = "*" if sb_p_`group' < 0.1
	replace sb_stars_`group' = "**" if sb_p_`group' < 0.05
	replace sb_stars_`group' = "***" if sb_p_`group' < 0.01
	}
	
end

** Tidy program for the exposure model
cap program drop tidy_exposure
program define tidy_exposure
	args index grp table
	

	** Import
	if "`index'"!="LE3"{
	import excel "`index'.xls",  sheet("`grp'") cellrange(A3) firstrow clear
	replace VARIABLES = "b" if VARIABLES == "shareFSPageIU_5"
	}
	
	if "`index'"=="LE3"{
	import excel "`index'__outputTables.xls",  sheet("`grp'") firstrow clear
	rename Model3 Exposure3
	replace VARIABLES = "b" if VARIABLES == "shareFSPage0_5"
	}
	
	drop in 1
	keep VARIABLES Exposure3
	keep if Exposure3 !=""
	*keep in 1/2
	keep if VARIABLES == "b" | VARIABLES[_n-1] == "b" | VARIABLES == "Cells" | VARIABLES == "Counties" | VARIABLES == "nobs"
	replace VARIABLES = "se" if VARIABLES == ""
	
	* Round to 4 decimal places
	destring Exposure3, replace
	replace Exposure3 = round(Exposure3, 0.0001) if VARIABLES == "b" | VARIABLES == "se"
	tostring Exposure3, replace force

	** Transpose
	sxpose, clear
	
	** Move first row to variable names
	forval i = 1/5 { 
		 local name = strtoname(_var`i'[1]) 
		 capture rename _var`i'  `name'_`grp' 
	}
	
	drop in 1
	gen index = "`index'"
	order index

	
end


/*******************************************************************************
* Appendix Table 1 and 2
*******************************************************************************/

/*******************************************************************************
* Run and append Romano-Wolf
*******************************************************************************/

** Clean all
foreach group in all wm wf nm nf {
	foreach index in ess hc nei{
		tidy_rw `index' `group'
		tempfile sub`index'`group'
		save `sub`index'`group''
	}
}

** Merge groups within index
foreach index in ess hc nei{
use `sub`index'all', clear
foreach group in wm wf nm nf {
	merge 1:1 subindex using `sub`index'`group'', nogen
	tempfile sub`index'
	save `sub`index''
}
}

* Append indexes
use `subess', clear
foreach index in hc nei{
	append using `sub`index''
}

order subindex

foreach group in all wm wf nm nf {
	gen rw_stars_`group' = ""
	replace rw_stars_`group' = "*" if rw_p_`group' < 0.1
	replace rw_stars_`group' = "**" if rw_p_`group' < 0.05
	replace rw_stars_`group' = "***" if rw_p_`group' < 0.01
}

tempfile rw_p
save `rw_p'

/*******************************************************************************
* Run and append p-values from subgroup testing
*******************************************************************************/

** Clean all
foreach index in ess hc nei{
	tidy_subgroups_subindices `index' 
	tempfile sub`index'
	save `sub`index''
}

* Append indexes
use `subess', clear
foreach index in hc nei{
	append using `sub`index''
}

order subindex

tempfile sb_p
save `sb_p'


/*******************************************************************************
* Run and append main models
*******************************************************************************/

frame change default

** Clean all
foreach group in all wm wf nm nf {
	tidy `group'
	gen grp = "`group'"
	tempfile sub`group'
	save `sub`group''
}

** Append all
use `suball'
foreach group in wm wf nm nf {
	append using `sub`group''
}

/*******************************************************************************
* Tidy
*******************************************************************************/


drop VARIABLES

** Max observations by group
gegen cells = max(Cells), by(grp)
gegen counties = max(Counties), by(grp)
gegen obs = max(nobs), by(grp)

drop Cells Counties nobs

** Reshape
reshape wide mdv b se cells counties obs, i(subindex order) j(grp) string
local maxobs = _N + 3
set obs `maxobs'

replace subindex = "Number of observations" if _n==_N-2
replace subindex = "Number of cells" if _n==_N-1
replace subindex = "Number of counties" if _n==_N
replace order = _n if _n>=_N-2

foreach grp in all wm wf nm nf {
	foreach stat in mdv b se {
		replace `stat'`grp' = obs`grp'[1] if _n==_N-2
		replace `stat'`grp' = cells`grp'[1] if _n==_N-1
		replace `stat'`grp' = counties`grp'[1] if _n==_N
	}
}


drop cells* counties* obs*

** Clean up
sort order
foreach stat in b se mdv {
	rename `stat'* `stat'_*
	label var `stat'_all "All"
	label var `stat'_wm "White males"
	label var `stat'_wf "White females"
	label var `stat'_nm "Nonwhite males"
	label var `stat'_nf "Nonwhite females"
}

/*******************************************************************************
* Merge Romano-Wolf P-values
*******************************************************************************/
merge 1:1 subindex using `rw_p', keep(1 3) nogen

/*******************************************************************************
* Subgroup testing P-values
*******************************************************************************/
merge 1:1 subindex using `sb_p', keep(1 3) nogen

/*******************************************************************************
* Appendix Table 1
*******************************************************************************/

frame copy default ta1, replace
frame change ta1

** Clean up to match what's in Tables-07212
* Drop or filter vars
drop b* se*
drop if subindex=="House value >0"

* Reshape
foreach stat in mdv {
	rename `stat'_* *`stat'
}

reshape long all nf nm wm wf, i(subindex order) j(stat) string

* Re-order
sort order stat
order subindex order stat all wm wf nm nf
drop order stat

br

/*******************************************************************************
* Appendix Table 2
*******************************************************************************/

frame copy default ta2, replace
frame change ta2


drop if subindex=="House value >0" 

* Round b and se to 4 decimal places
foreach grp in all wm wf nm nf {
replace b_`grp' = round(b_`grp', 0.0001)
replace se_`grp' = round(se_`grp', 0.0001)
}

* Reshape
foreach stat in b se rw_p rw_stars /*sb_stars sb_p*/ {
	rename `stat'_* *`stat'
}

*drop mdv_*
drop mdv_* sb_*

tostring *, force replace

* Add stars to coefficients
foreach grp in all wm wf nm nf {
	egen `grp'_stars = concat(`grp'b `grp'rw_stars)
	
	drop `grp'_stars
}

reshape long all nf nm wm wf, i(subindex order) j(stat) string

* After checking, remove the subgroup stars / p-values
*drop if stat == "sb_stars" | stat == "sb_p"
drop if stat == "rw_stars"



merge m:1 subindex using `sb_p', keep(1 3) nogen keepusing(sb_stars*)
merge m:1 subindex using `rw_p', keep(1 3) nogen keepusing(rw_stars*)

* Re-order
destring order, replace
replace order = order + 0.5 if stat=="rw_p"
sort order stat
order subindex order stat all wm wf nm nf
replace subindex="" if stat=="se"
replace subindex ="Romano-Wolf p" if stat=="rw_p"
drop order stat

* Drop rows without romano-wolf p-value (disability index, number of observations)
drop if all == "."

* Drop the obs count rows manually that we don't want to display -- make sure to manually check these rows if change any of the format above
drop in 104
drop in 105
drop in 106

* Drop the disability outcomes -- make sure to manually check these rows if change any of the format above
drop in 91/102

* Add 0's to the start
gen O = "0"
gen sb_stars_all = ""
gen sb_stars_wm = ""
foreach grp in all wm wf nm nf {
	*local grp wf
	
	* Identify if the value is negative
	cap drop neg 
	gen neg = "-" if regexm(`grp', "-") == 1
	
	* Take off the negative
	gen `grp'_pos = `grp' 
	replace `grp'_pos = substr(`grp', 2, .) if neg == "-" 
	
	* Calculate the length of this substring
	* If 4, need to add a 0 to the end so that we always have 4 digits after the decimal place
	gen `grp'_pos_len = strlen(`grp'_pos)
	egen `grp'_pos_0 = concat(`grp'_pos O) if `grp'_pos_len == 4
	replace `grp'_pos = `grp'_pos_0 if `grp'_pos_len == 4 
	
	* Don't add stars to the SE or Romano-Wolf p-values
	replace rw_stars_`grp' = "" if subindex == "" | subindex == "Romano-Wolf p"
	
	* Add bolding for statistically different from white male group
	cap drop b1 b2
	gen b1 = "\textbf{" if sb_stars_`grp' != ""
	gen b2 = "}" if sb_stars_`grp' != ""
	
	* Don't add bolding to the SE or Romano-Wolf p-values
	replace b1 = "" if subindex == "" | subindex == "Romano-Wolf p"
	replace b2 = "" if subindex == "" | subindex == "Romano-Wolf p"
	
	* Put all the pieces together to get the fomatted number: 
	* bold start + negative + leading 0 + value + stars + bold end
	egen `grp'new = concat(b1 neg O `grp'_pos rw_stars_`grp' b2)
	
	* Leave true 1 and true 0 alone
	replace `grp'new = "1.0000" if `grp' == "1"
	replace `grp'new = "0.0000" if `grp' == "0"
	
	* Drop the construction variables
	drop neg `grp'_pos `grp'_pos_len `grp'_pos_0 b1 b2
	
	* Leave the counting variables as they were
	replace `grp'new = `grp' if subindex == "Number of observations" | subindex == "Number of cells" | subindex == "Number of counties"
	
}

drop O rw_stars* sb_stars*

foreach grp in all wm wf nm nf {
	replace `grp' = `grp'new
	drop `grp'new
}



gen p1 = "("
gen p2 = ")"

foreach grp in all wm wf nm nf {
	tostring `grp', replace
	egen `grp'_se = concat(p1 `grp' p2)
	replace `grp' = `grp'_se if subindex==""
	drop `grp'_se
}
drop p1 p2



* Drop the Romano-Wolf p-value
drop if subindex=="Romano-Wolf p"

br

* Save Table for reference
export excel using "AppT2.xlsx", replace keepcellfmt




// Then, use Excel2Latex to get it in the correct format


/*******************************************************************************
* Appendix Table 4 ( Romano-Wolf p-values Table)
*******************************************************************************/

frame change default


* Drop
*drop b* drop se*
drop if subindex=="House value >0" 

* Round b and se to 4 decimal places
foreach grp in all wm wf nm nf {
replace b_`grp' = round(b_`grp', 0.0001)
replace se_`grp' = round(se_`grp', 0.0001)
}

* Reshape
foreach stat in b se rw_p rw_stars /*sb_stars sb_p*/ {
	rename `stat'_* *`stat'
}

*drop mdv_*
drop mdv_* sb_*

tostring *, force replace

* Add stars to coefficients
foreach grp in all wm wf nm nf {
	egen `grp'_stars = concat(`grp'b `grp'rw_stars)
	*replace `grp'b = `grp'_stars
	drop `grp'_stars
}

reshape long all nf nm wm wf, i(subindex order) j(stat) string

* Keep the Romano-Wolf p-value
keep if stat == "rw_p"

* Re-order
destring order, replace
sort order
order subindex order stat all wm wf nm nf
drop order stat

* Drop rows without romano-wolf p-value (disability index, number of observations)
drop if all == "."

* Add 0's to the start
gen O = "0"
foreach grp in all wm wf nm nf {
	*local grp wf
	
	* Identify if the value is negative
	cap drop neg 
	gen neg = "-" if regexm(`grp', "-") == 1
	
	* Take off the negative
	gen `grp'_pos = `grp' 
	replace `grp'_pos = substr(`grp', 2, .) if neg == "-" 
	
	* Calculate the length of this substring
	* If 4, need to add a 0 to the end so that we always have 4 digits after the decimal place
	gen `grp'_pos_len = strlen(`grp'_pos)
	egen `grp'_pos_0 = concat(`grp'_pos O) if `grp'_pos_len == 4
	replace `grp'_pos = `grp'_pos_0 if `grp'_pos_len == 4 
	
	* Put all the pieces together to get the fomatted number: 
	* bold start + negative + leading 0 + value + stars + bold end
	egen `grp'new = concat(neg O `grp'_pos)
	
	* Leave true 1 and true 0 alone
	replace `grp'new = "1.0000" if `grp' == "1"
	replace `grp'new = "0.0000" if `grp' == "0"
	
	* Drop the construction variables
	drop neg `grp'_pos `grp'_pos_len `grp'_pos_0

	
}

drop O

foreach grp in all wm wf nm nf {
	replace `grp' = `grp'new
	drop `grp'new
}


br

* Save Table for reference
export excel using "AppT4.xlsx", replace keepcellfmt


/*******************************************************************************
* Table 4 
*******************************************************************************/

frame change default

foreach index in z_hc z_ess z_nei z_dis dis_9 ess_7{
	
*local index z_hc
	
tidy_subgroups `index'
tempfile `index'_temp
save ``index'_temp'

** Clean all
foreach group in all wm wf nm nf {
	tidy_exposure `index' `group'
	tempfile sub`group'
	save `sub`group''
}

** Append all
use `suball'
foreach group in wm wf nm nf {
	merge 1:1 index using `sub`group'', nogen
}

* Reshape
foreach stat in b se Cells Counties nobs{
	rename `stat'_* *`stat'
}

reshape long all nf nm wm wf, i(index) j(stat) string

merge m:1 index using ``index'_temp', nogen keepusing(sb_stars*)

* Add 0's to the start
gen O = "0"
gen sb_stars_all = ""
gen sb_stars_wm = ""
foreach grp in all wm wf nm nf {
	
	*local grp all
	
	* Identify if the value is negative
	cap drop neg 
	gen neg = "-" if regexm(`grp', "-") == 1
	
	* Take off the negative
	gen `grp'_pos = `grp' 
	replace `grp'_pos = substr(`grp', 2, .) if neg == "-" 
	
	* Calculate the length of this substring
	* If 4, need to add a 0 to the end so that we always have 4 digits after the decimal place
	gen `grp'_pos_len = strlen(`grp'_pos)
	egen `grp'_pos_0 = concat(`grp'_pos O) if `grp'_pos_len == 4
	replace `grp'_pos = `grp'_pos_0 if `grp'_pos_len == 4 
	
	* Don't add stars to the SE
	replace sb_stars_`grp' = "" if stat == "se"
	
	* Add bolding for statistically different from white male group
	cap drop b1 b2
	gen b1 = "\textbf{" if sb_stars_`grp' != ""
	gen b2 = "}" if sb_stars_`grp' != ""
	
	* Don't add bolding to the SE
	replace b1 = "" if stat == "se"
	replace b2 = "" if stat == "se"
	
	* Put all the pieces together to get the fomatted number: 
	* bolding start + negative + leading 0 + value /*+ stars*/ + bolding end
	egen `grp'new = concat(b1 neg O `grp'_pos /*sb_stars_`grp'*/ b2)
	
	* Leave true 1 and true 0 alone
	replace `grp'new = "1.0000" if `grp' == "1"
	replace `grp'new = "0.0000" if `grp' == "0"
	
	* Drop the construction variables
	drop neg `grp'_pos `grp'_pos_len `grp'_pos_0 b1 b2
	
	* Leave the counting variables as they were
	replace `grp'new = `grp' if stat == "Cells" | stat == "Counties" | stat == "nobs"
	
}

drop O sb_stars*

foreach grp in all wm wf nm nf {
	replace `grp' = `grp'new
	drop `grp'new
}

tempfile `index'_temp
save ``index'_temp'

}

use `z_hc_temp', clear
foreach index in z_ess z_nei z_dis /*LE3*/ dis_9 ess_7{
	append using ``index'_temp'
}

* Add parentheses to the SE
gen p1 = "("
gen p2 = ")"

foreach grp in all wm wf nm nf {
	tostring `grp', replace
	egen `grp'_se = concat(p1 `grp' p2)
	replace `grp' = `grp'_se if stat=="se"
	drop `grp'_se
}
drop p1 p2

* Reshape again
reshape wide all wm wf nm nf, i(index) j(stat) string

local obs = _N + 1
set obs `obs'
foreach v in index allb wmb wfb nmb nfb allse wmse wfse nmse nfse{
	replace `v' = "`v'" in 7
}
foreach v in allCells wmCells wfCells nmCells nfCells allCounties wmCounties wfCounties nmCounties nfCounties allnobs wmnobs wfnobs nmnobs nfnobs{
	replace `v' = "`v'" in 7
}

** Transpose
sxpose, clear

** Move first row to variable names
forval i = 1/7 { 
	local name = strtoname(_var`i'[1]) 
	capture rename _var`i'  `name' 
}
drop in 1

gen order = .
replace order = 1 if index == "allb"
replace order = 2 if index == "allse"
replace order = 3 if index == "allnobs"
replace order = 4 if index == "allCells"
replace order = 5 if index == "allCounties"
replace order = 6 if index == "wmb"
replace order = 7 if index == "wmse"
replace order = 8 if index == "wmnobs"
replace order = 9 if index == "wmCells"
replace order = 10 if index == "wmCounties"
replace order = 11 if index == "wfb"
replace order = 12 if index == "wfse"
replace order = 13 if index == "wfnobs"
replace order = 14 if index == "wfCells"
replace order = 15 if index == "wfCounties"
replace order = 16 if index == "nmb"
replace order = 17 if index == "nmse"
replace order = 18 if index == "nmnobs"
replace order = 19 if index == "nmCells"
replace order = 20 if index == "nmCounties"
replace order = 21 if index == "nfb"
replace order = 22 if index == "nfse"
replace order = 23 if index == "nfnobs"
replace order = 24 if index == "nfCells"
replace order = 25 if index == "nfCounties"


order index z_hc z_ess z_nei z_dis /*LE3*/ dis_9 ess_7
sort order

drop order

* Save Table for reference
export excel using "T4.xlsx", replace keepcellfmt firstrow(var)



/*******************************************************************************
* End of file
*******************************************************************************/
