* fs_dtacr_1.do
* Bryan Stuart
* Process food stamps treatment data and other data sources
* Updated 2/16/2016 (new REIS data from HH)
* Updated 7/11/2016 (Incorporate geographically consistent "super counties")

cap log close
log using "$output/fs_dtacr_1.log", replace

* Define programs that edit county codes
do "$dofile/countyStandardizeGNIS1950.do"

* Minor processing of county-level treatment data
use "$datap/countyLevel/FSP_startdate.dta", clear
gen fips = 1000*stfips + countyfips
gen fips_ = fips
countyFipsToREISfips, county(fips)
fixCounty, county(fips)
bys fips: gen count = _N
quietly sum count
local n = r(max)
forval i = 1/`n' {
	sort fips fs_year fs_month
	bys fips: gen fips_`i' = fips_[`i']
	bys fips: gen fs_year_`i' = fs_year[`i']
	bys fips: gen fs_month_`i' = fs_month[`i']
}
drop fips_
collapse (first) st_fips=stfips fips_* fs_* (count) ncounties=fs_year (sd) conflict=fs_year, by(fips)
tab ncounties, m
drop ncounties
*replace countyfips=86 if stfips==12 & countyfips==25	// Miami, FL 
*isid stfips countyfips
isid fips
gen co_fips_1 = fips-1000*st_fips
drop fs_year fs_month
gen fsconflict = (conflict > 0 & conflict < .)
tab fsconflict, m
list st_fips co_fips_1 fs_year_* if fsconflict == 1
drop conflict
compress
save "$datatemp/fs_dtacr_1_1.dta", replace

* Minor processing of REIS transfer data: NEED POP DATA TO UPDATE
* Not using this right now anyway
use "$datap/reis_transfers_1959_2010.dta", clear
rename TpcRet tranpcret
rename TpcMedCARE1 tranpcmcare1
rename TpcIncPA1 tranpcpa1
*replace countyfips=86 if stfips==12 & countyfips==25	// Miami, FL 
rename year birthyr
keep if inrange(birthyr,1959,1980)
isid stfips countyfips birthyr
gen fips = 1000*stfips + countyfips
countyFipsToREISfips, county(fips)
fixCounty, county(fips)
collapse (first) stfips (mean) tran*, by(fips birthyr)	/* NOTE THIS IS INAPPROPRIATE; WE NEED POP DATA */
rename stfips st_fips
gen co_fips_1 = fips - 1000*st_fips
keep birthyr st_fips co_fips_1 tranpcpa1 tranpcmcare1 tranpcret 
compress

save "$datatemp/fs_dtacr_1_2.dta", replace

* Minor processing of 1960 county data book 
* First bring in ICPSR data with acreage
use "$datap/02896-0075-Data.dta", clear
rename var3 area59
drop if counfip==0	/* State-level obsevations */
drop if statefip==2	/* Alaska */
drop if statefip==15	/* Hawaii */
replace fips = 29186 if fips==29193	/* Ste. Genevieve County, Mo */
keep area59 fips
tempfile area
save "`area'"
clear
use "$datap/countyLevel/cityctydb60.dta", clear
drop if stfips==2
drop if stfips==15
gen fips = 1000*stfips + countyfips
drop if fips==29186
replace fips =29186 if fips==29193	/* Ste. Genevieve County, Mo */
merge 1:1 fips using "`area'", gen(areamerge)

countyFipsToREISfips, county(fips)
fixCounty, county(fips)

preserve
collapse (first) stfips countyname (rawsum) pop60 (mean) inc3k60 urban60 rural60 black60 ///
	age560 age6560 employagpct60 [aw=pop60], by(fips)
tempfile db60
save "`db60'"
restore
collapse (mean) farmlandpct60 [aw=area59], by(fips)
merge 1:1 fips using "`db60'", gen(farmmerge)

rename stfips st_fips
gen co_fips_1 = fips-1000*st_fips
compress
save "$datatemp/fs_dtacr_1_3.dta", replace


* Births by county, 1960
use "$datap/geo/births_im_mort_att_1915_2010_restricted_final.dta", clear
rename cofips fips
replace _h_id_50_90 = _h_id_60_90 if _h_id_50_90 == 36999 /* NYC boroughs */
countyFipsToREISfips, county(fips)
fixCounty, county(fips)
collapse (rawsum) births60_all=births_res pop (first) fips countyname st_fips=statefip ///
	(sd) sdfips=fips, by(_h_id_50_90 year)
assert sdfips==0 | sdfips == .	/* BEA fips are constant within Horan supercounty */
collapse (rawsum) births60 pop (first) countyname st_fips, by(fips year)
tab year, m	/* Should be constant number within year after 1950 */
keep if year == 1960
drop year
gen co_fips_1 = fips-1000*st_fips
compress
save "$datatemp/fs_dtacr_1_4.dta", replace


* Transfer data
use "$datap/countyLevel/reis_transfers.dta", clear
keep stfips countyfips year annualpop tranpcret tranpcmcare1 tranpcpa1
gen fips = 1000*stfips + countyfips
countyFipsToREISfips, county(fips)
fixCounty, county(fips)
collapse (mean) tran* [aw=annualpop], by(fips year)
gen st_fips = floor(fips/1000)
gen co_fips_1 = fips - 1000*st_fips
rename year birthyr
drop fips
lab var tranpcret "REIS retirement and SSDI benefits per capita, thousands, 2006$"
lab var tranpcmcare1 "REIS Medicare and military benefits per capita, thousands, 2006$"
lab var tranpcpa1 "REIS public assistance per capita, thousands, 2006$"
compress
save "$datatemp/fs_dtacr_1_5.dta", replace

* Number of hospitals per capita
use "$datap/countyLevel/aha.dta", clear
keep year fipscode popn nhosp_pc beds_pc
rename fipscode fips
countyFipsToREISfips, county(fips)
fixCounty, county(fips)
collapse (mean) nhosp_pc beds_pc [aw=popn], by(year fips)
gen st_fips = floor(fips/1000)
gen co_fips_1 = fips - 1000*st_fips
drop fips
rename year birthyr
lab var nhosp_pc "Thousands of hospitals per capita"
lab var beds_pc "Thousands of hospital beds per capita"
compress
save "$datatemp/fs_dtacr_1_6.dta", replace

* CHC implementation
use "$datap/aer_data.dta", clear
keep fips chc_year_exp
countyFipsToREISfips, county(fips)
fixCounty, county(fips)
collapse (min) chc_year_exp, by(fips)
gen st_fips = floor(fips/1000)
gen co_fips_1 = fips - 1000*st_fips
drop fips
lab var chc_year_exp "Year of first non-planning CHC grant"
compress
save "$datatemp/fs_dtacr_1_7.dta", replace

* Further 1960 county statistics -- hunger deaths, for stratified analysis
use "$datap/county-stratify.dta", clear
cap drop fips
gen fips = 1000*stfips + countyfips
countyFipsToREISfips, county(fips)
fixCounty, county(fips)

collapse (mean) hungrate hungshare [aw=pop60], by(fips)

gen st_fips=floor(fips/1000)
gen co_fips_1 = fips-1000*st_fips
compress
save "$datatemp/fs_dtacr_1_8.dta", replace


log close
