* Combine census and NUMIDENT collapsed data
* Bryan Stuart
* This do-file merges the Census/ACS data from dtacr_23 with the NUMIDENT data
* from dtacr_24
* Updated 5/2/2016 (use birth month for food stamps)
* Updated 5/23/2016 (use birth year)
* Updated 7/11/2016 (Incorporate geographically consistent "super counties")

cap log close
log using "$output/dtacr_25_newsub.log", replace

use "$datatemp/dtacr_23_newsub.dta", clear	// census data
merge m:1 st_fips co_fips_1 birthyr /*birthmo*/ exactmatch ///
	using "$datatemp/dtacr_24_newsub.dta", gen(_mergessa) // numident

tab st_fips _mergessa if _mergessa != 3
tab year _mergessa if _mergessa != 3
tab birthyr _mergessa if _mergessa != 3
gen fips = 1000*st_fips+co_fips_1
tab fips if _mergessa == 1


* Quick check of samples
foreach y in obs obs_dis obs_inc {
	foreach g in all wf wm nf nm {
		sum `y'_`g' if exactmatch==0
		di "`r(sum)'"
	}
}
egen tag = tag(st_fips co_fips_1 birthyr)
foreach y in  num_births num_deaths {
	foreach g in all wf wm nf nm {
		sum `y'_`g' if tag==1
		di "`r(sum)'"
	}
}
drop tag


* Not using this for now, because the disability index no longer includes
* the variables from the NUMIDENT
/* Update health and composite index
foreach x in all white nonwhite men women {

rename z_dis_`x' cenz_dis_`x'	// based only on census/ACS data
drop z_composite_`x'		// based on above

egen z_dis_`x' = rowmean(z_dis_1_`x' z_dis_2_`x' z_dis_3_`x' z_dis_4_`x' z_dis_5_`x' ///
	z_dis_6_`x') 
egen z_composite_`x' = rowmean(z_hc_`x' z_ess_`x' z_dis_`x' z_nei_`x')

la var cenz_dis_`x' "Physical health sub-index from census data only, `x'"
la var z_dis_`x' "Physical health sub-index, `x'"
la var z_composite_`x' "Composite index, `x'"

}
*/

compress
save "$datatemp/dtacr_25_newsub.dta", replace


log close
