* Combine census and NUMIDENT collapsed data
* Bryan Stuart
* Updated 5/2/2016 (use birth month for food stamps)
* Updated 5/23/2016 (use birth year)
* Updated 7/11/2016 (Incorporate geographically consistent "super counties")

cap log close
log using "$output/dtacr_25_birthmo.log", replace

use "$datatemp/dtacr_23_birthmo.dta", clear	// census data
merge m:1 st_fips co_fips_1 birthyr birthmo exactmatch ///
	using "$datatemp/dtacr_24_birthmo.dta", gen(_mergessa) // numident

tab st_fips _mergessa if _mergessa != 3
tab year _mergessa if _mergessa != 3
tab birthyr _mergessa if _mergessa != 3
gen fips = 1000*st_fips+co_fips_1
tab fips if _mergessa == 1

/* Identify counties that may be problems for constant county groups
gen badmerge = (_mergessa == 1 | _mergessa == 2)
bys st_fips co_fips_1: gen total = _N
bys st_fips co_fips_1: egen totbadmerge = total(badmerge)
gen sharebad = totbadmerge/total
drop totbadmerge total badmerge
tab fips _mergessa if sharebad==1
drop sharebad fips
*/




* Not using this for now, because the disability index does not currently include
* the variables from the NUMIDENT
/* Update health and composite index
foreach x in all white nonwhite men women {

rename z_dis_`x' cenz_dis_`x'	// based only on census/ACS data
drop z_composite_`x'		// based on above

egen z_dis_`x' = rowmean(z_dis_1_`x' z_dis_2_`x' z_dis_3_`x' z_dis_4_`x' z_dis_5_`x' ///
	z_dis_6_`x') 
egen z_composite_`x' = rowmean(z_hc_`x' z_ess_`x' z_dis_`x' z_nei_`x')

la var cenz_dis_`x' "Physical health sub-index from census data only, `x'"
la var z_dis_`x' "Physical health sub-index, `x'"
la var z_composite_`x' "Composite index, `x'"

}
*/

compress
save "$datatemp/dtacr_25_birthmo.dta", replace

log close
