﻿* countyStandardizeGNIS1950.do
* The goal here is to alter the FIPS codes from GNIS, as merged to the Census/ACS, Numident,
* to create county groups that represents consistent geographic units from 1950-1980
* July 2016. The starting point is the first program and a half, which were
* provided by the BEA via Reed Walker.
* Updated by Brenden Timpe, 7/8/2016


/*---------------------------------------------------------*/
**** rename county fips codes to REIS-BEA county equivalents ****
/*---------------------------------------------------------*/
capture program drop countyFipsToREISfips
program define countyFipsToREISfips
syntax, county(string)

	*combine fips codes to match REIS combined fips regions (mostly for Virginia) - adapted SAS code from Jeffrey.Newman@bea.gov
	replace `county'=15901 if `county'==15005
	replace `county'=15901 if `county'==15009
	replace `county'=51901 if `county'==51003
	replace `county'=51903 if `county'==51005
	replace `county'=51907 if `county'==51015
	replace `county'=51909 if `county'==51019
	replace `county'=51911 if `county'==51031
	replace  `county'=51913 if `county'==51035 
	replace  `county'=51918 if `county'==51053
	replace  `county'=51919 if `county'==51059
	replace  `county'=51921 if `county'==51069
	replace  `county'=51923 if `county'==51081
	replace  `county'=51929 if `county'==51089
	replace  `county'=51931 if `county'==51095
	replace  `county'=51933 if `county'==51121
	replace  `county'=51939 if `county'==51143
	replace  `county'=51941 if `county'==51149
	replace  `county'=51942 if `county'==51153
	replace  `county'=51944 if `county'==51161
	replace  `county'=51945 if `county'==51163 
	replace  `county'=51947 if `county'==51165
	replace  `county'=51949 if `county'==51175
	replace  `county'=51951 if `county'==51177
	replace  `county'=51953 if `county'==51191
	replace  `county'=51955 if `county'==51195
	replace  `county'=51958 if `county'==51199
	replace  `county'=51909 if `county'==51515
	replace  `county'=51953 if `county'==51520
	replace  `county'=51945 if `county'==51530
	replace  `county'=51901 if `county'==51540
	replace  `county'=51903 if `county'==51560
	replace  `county'=51918 if `county'==51570
	replace  `county'=51903 if `county'==51580
	replace  `county'=51939 if `county'==51590
	replace  `county'=51923 if `county'==51595
	replace  `county'=51919 if `county'==51600
	replace  `county'=51919 if `county'==51610
	replace  `county'=51949 if `county'==51620
	replace  `county'=51951 if `county'==51630
	replace  `county'=51913 if `county'==51640
	replace  `county'=51947 if `county'==51660
	replace  `county'=51941 if `county'==51670
	replace  `county'=51945 if `county'==51678
	replace  `county'=51911 if `county'==51680
	replace  `county'=51942 if `county'==51683
	replace  `county'=51942 if `county'==51685
	replace  `county'=51929 if `county'==51690
	replace  `county'=51955 if `county'==51720
	replace  `county'=51918 if `county'==51730
	replace  `county'=51958 if `county'==51735
	replace  `county'=51933 if `county'==51750
	replace  `county'=51944 if `county'==51775
	replace  `county'=51083 if `county'==51780
	replace  `county'=51907 if `county'==51790
	replace  `county'=51907 if `county'==51820
	replace  `county'=51931 if `county'==51830
	replace  `county'=51921 if `county'==51840

end

/*---------------------------------------------------------*/
**** rename county fips codes to address splits/changes
/*---------------------------------------------------------*/
capture program drop fixCounty
program define fixCounty
syntax, county(string)

	drop if `county'-floor(`county'/1000)*1000 == 999
	drop if `county'==.
	*drop alaska and hawaii
	drop if floor(`county'/1000)==2 | floor(`county'/1000)==15 | floor(`county'/1000)>=60 | floor(`county'/1000)==0
	*Arizona, 1980s: La Paz county is created out of parts of Yuma county. FIPS code 4012 appears.
	replace `county' =4027 if `county' == 4012
	*Dade county changes name to Miami-Dade. FIPS code is changed from 12025 to 12086 in order to preserve alphabetical sequence of county codes;
	replace `county'=12025 if `county'==12086
	*New Mexico, 1980s: Cibola county is created out of parts of Valencia county. FIPS code 35006 appears.
	replace `county' = 35061 if `county'==35006
	*Data for the two Wisconsin counties 55078 and 55115 is sometimes combined and reported under FIPS code 55901.
	replace `county' = 55901 if `county'==55078 | `county'==55115
	*In 2002, Broomfield Cnty, CO (08014) created from parts of Adams (08001), Boulder (08013), Jefferson (08059), and Weld (08123) counties
	*According to Wikipedia, QQQ county lost about QQQ inhabitants to QQQ county in 2001. In turn, QQQ's website indicates a 
	*population of QQQ for 2003 which suggests that most of QQQ's population came from QQQ county.
	replace `county' = 8013 if `county' == 8014
	
	
	* Extra counties added by Brenden, July 2016
	* The goal here is to get the GNIS codes, which were merged with the ACS/Census/Numident,
	* to match constant geographic "super counties" as laid out by the Horan file
	
	* Armstrong County, SD: Assign to Dewey, which absorbed it in 1952.
	replace `county' = 46041 if `county' == 46001
	* Galax, VA: Split from Carroll and Grayson counties in 1953, so combine all
	* three into one for the entire time period
	* Note Galax and Carroll were already merged above
	replace `county' = 51913 if `county' == 51640 | `county' == 51077
	* Virginia Beach: This combined assigns the VA Beach code to Princess Anne Cty,
	* Portsmouth, Norfolk city, Norfolk County, and Chesapeake city
	replace `county' = 51810 if `county' == 51151 | `county' == 51740 | ///
		`county' == 51710 | `county' == 51129 | `county' == 51550
	* Menominee County, WI: Merge with Shawano and Oconto counties, per Horan
	* Note Shawano and Menominee were already  merged above
	replace `county' = 55901 if `county' == 55083 | `county' == 55078
	* Ormsby County and Carson City, NV: Here we just adjust the old FIPS
	* code to the new one
	replace `county' = 32510 if `county' == 32025
	* Delete Yellowstone Natl Park in ID and WY
	drop if `county' == 16089 | `county' == 56047
	* Merge Washabaugh County with Jackson County, SD
	replace `county' = 46071 if `county' == 46131
	
end
