set trace on 
set tracedepth 2


capture program drop main
program define main
	paths 
	
	* Make the mover dependent variable 
	*makeMoverData, sample(100)
	local masterData "$datasource/fs_dtacr_2_exactmatch0_newsub.dta"
	local masterDataBirthmo "$datasource/fs_hsacr_1_newsub_exactmatch0.dta"
	local moverData "$datatemp/shareMoved.dta"
	local moverDataBirthmo "$datatemp/shareMoved_birthmo.dta"
	* Merge the new variable to the master data
	mergeToMaster, masterData(`masterData') masterDataBirthmo(`masterDataBirthmo') moverData(`moverData') moverDataBirthmo(`moverDataBirthmo')
	
	
	local data1 "$datatemp/analysisWithMover_birthmo.dta"
	local data2 "$datatemp/analysisWithMover.dta"
	local sample = 100
	* Estimate all models on mover variable
	foreach o in moved{
		outputTables, dataExposure(`data1') dataEvent(`data2') sample(`sample') indexType("`o'")
	}
	
	local data1 "$datasource/fs_hsacr_1_newsub_exactmatch0.dta"
	* Eventstudy and spline data 
	local data2 "$datasource/fs_dtacr_2_exactmatch0_newsub.dta"
	local shareVar "FSPshareIU_5"
	
	
	
	* Calculate right standard errors for each component of the spline 
	foreach o in z_composite z_ess z_hc z_dis z_nei dis_9 ess_7 {
		*splineSE,  data(`data2') sample(100) indexType("`o'") 
	}
	local data2 "$datatemp/analysisWithMover.dta"
	foreach o in moved {
		*splineSE,  data(`data2') sample(100) indexType("`o'") 
	}
	
	

end 



capture program drop paths 
program define paths 

  /*
  global datap "/projects/data"
 
  global datasource "/projects/disclosure/20181010/support/data"
  global datatemp "/projects/disclosure/20190418/data"
  global dofile "/projects/disclosure/20190418/support"
  global tables "/projects/disclosure/20190418/tables"
  global output $tables
  */

  global datap "/projects/data"		// project-wide data 
  
  global datatemp_basic "/projects/programs/foodstamps/master_folder/basicprocessing/datatemp" // basic processing data
  global datasource "/projects/programs/foodstamps/master_folder/datatemp"
  global datatemp "/projects/programs/foodstamps/master_folder/datatemp"
  global dofile "/projects/programs/foodstamps/master_folder/disclosure20191014"
  global tables "/projects/programs/foodstamps/master_folder/disclosure20191014/output"
  global output $tables
  	

end 

capture program drop makeMoverData
program define makeMoverData
syntax, [sample(int 5)]
* Census data at micro level
log using $dofile/makeMoverData2.log, replace 
use  "$datatemp_basic/dtacr_20.dta", clear



* Limit by birth cohort and age 
keep if birthyr>=1950 & birthyr<=1980 & age>=25 & age<=64  

* Drop if sex is missing 
drop if female==.
* Generate race 
gen race = race_white + 2*race_black + 3*race_other
* Drop if missing
drop if race==.

* Limit to obs with non missing birth county
drop if co_fips_1==. 		
drop if st_fips==.	


gen birth_fips = st_fips*1000+co_fips_1
gen obs_fips = statefip *1000 + coufip 
gen moved = cond(birth_fips != obs_fips,1,0)



* Drop if missing pik (shouldn't do anything)
drop if pik==""

* Drop obs if PIK appears more than once in a given year
gen one = 1
sort year pik
bys year pik: egen num_pik = total(one)
gen mult_pik = num_pik>1 & num_pik!=.
bys pik: egen num_mult_pik = total(mult_pik)
drop if num_mult_pik>0 & num_mult_pik!=.
 
* Drop if birth month is missing
su birthyr birthmo
drop if birthmo==. 
 


* Sample cuts made here;
*** Another check, added 1/23/2017
* Here we want to generate a complete-information sample, except that we will
* allow people to be missing either house value or rent, and we will allow them to 
* be missing labor income
gen fullinfo = 1
replace fullinfo = 0 if !inrange(age,25,54)	
replace fullinfo = 0 if ess_7 == 0		
gen neiflag = nei_1==. & nei_2==.
replace fullinfo = 0 if neiflag == 1		









* FINALLY, keep people who are incarcerated, as a separate incarcerated sample
gen incarc = ess_7 == 0 if inrange(age,25,54) & inrange(year,2006,2013)
sum perwt if ess_7 == 0


** KEEP only disclosure sample
keep if fullinfo==1 | incarc == 1	


**** END OF SAMPLE CUTS FOR DISCLOSURE ****
tempfile fulldata
save `fulldata'



**** Super counties ****
* Convert county codes to "super counties" that are
* consistent from 1950-1990
do "$dofile/countyStandardizeGNIS1950.do"
gen fips = 1000*st_fips + co_fips_1
* Save original fips
gen fips_orig = fips
countyFipsToREISfips, county(fips)
fixCounty, county(fips)
* Replace county fips code with new version
replace co_fips_1 = fips - 1000*st_fip



* Collapse into birth-year/survey-year/county cells

***** Share of birth cohort moving
* Collapse for all matches
preserve
* Keep only ages 25-54
keep if birthyr>=1950 & birthyr<=1980 & age>=25 & age<=54
keep if fullinfo==1 | incarc==1
collapse (mean) moved [aw=perwt], by(st_fips co_fips_1 birthyr birthmo year)
rename moved moved_all 
gen exactmatch=0
tempfile temp_all
save `temp_all'
restore


* Collapse for white males
preserve
keep if race_white==1 & female==0
keep if birthyr>=1950 & birthyr<=1980 & age>=25 & age<=54
keep if fullinfo==1 | incarc==1
collapse (mean) moved [aw=perwt], by(st_fips co_fips_1 birthyr birthmo year)
rename moved moved_wm
tempfile temp_wm
save `temp_wm'
restore

* Collapse for white females
preserve
keep if race_white==1 & female==1
keep if birthyr>=1950 & birthyr<=1980 & age>=25 & age<=54
keep if fullinfo==1 | incarc==1
collapse (mean) moved [aw=perwt], by(st_fips co_fips_1 birthyr birthmo year)
rename moved moved_wf
tempfile temp_wf
save `temp_wf'
restore

* Collapse for nonwhite males
preserve
keep if female==0 & (race_black==1 | race_other==1)
keep if birthyr>=1950 & birthyr<=1980 & age>=25 & age<=54
keep if fullinfo==1 | incarc==1
collapse (mean) moved [aw=perwt], by(st_fips co_fips_1 birthyr birthmo year)
rename moved moved_nm
tempfile temp_nm
save `temp_nm'
restore

* Collapse for nonwhite women
preserve
keep if female==1 & (race_black==1 | race_other==1)
keep if birthyr>=1950 & birthyr<=1980 & age>=25 & age<=54
keep if fullinfo==1 | incarc==1
collapse (mean) moved [aw=perwt], by(st_fips co_fips_1 birthyr birthmo year)
rename moved moved_nf
tempfile temp_nf
save `temp_nf'
restore



*** MERGE
* Creates birth cohort by survey year data set of share moving 
use `temp_all', clear
merge 1:1 st_fips co_fips_1 birthyr  birthmo year using `temp_wm', gen(_mergewm)
merge 1:1 st_fips co_fips_1 birthyr  birthmo year using `temp_wf', gen(_mergewf)
merge 1:1 st_fips co_fips_1 birthyr  birthmo year using `temp_nm', gen(_mergenm)
merge 1:1 st_fips co_fips_1 birthyr  birthmo year using `temp_nf', gen(_mergenf)


label var moved_all "Share of birth cohort that moved away from birth county, all"
label var moved_wm "Share of birth cohort that moved away from birth county, wm"
label var moved_wf "Share of birth cohort that moved away from birth county, wf"
label var moved_nm "Share of birth cohort that moved away from birth county, nm"
label var moved_nf "Share of birth cohort that moved away from birth county, nf"
compress
save "$datatemp/shareMoved_birthmo.dta", replace


************************* Do again for birth year only (no birthmonth) *********************************
use `fulldata', clear 
***** Share of birth cohort moving
* Collapse for all matches
preserve
* Keep only ages 25-54
keep if birthyr>=1950 & birthyr<=1980 & age>=25 & age<=54

collapse (mean) moved [aw=perwt], by(st_fips co_fips_1 birthyr  year)
rename moved moved_all 
gen exactmatch=0
tempfile temp_all
save `temp_all'
restore


* Collapse for white males
preserve
keep if race_white==1 & female==0
keep if birthyr>=1950 & birthyr<=1980 & age>=25 & age<=54
keep if fullinfo==1 | incarc==1
collapse (mean) moved [aw=perwt], by(st_fips co_fips_1 birthyr  year)
rename moved moved_wm
tempfile temp_wm
save `temp_wm'
restore

* Collapse for white females
preserve
keep if race_white==1 & female==1
keep if birthyr>=1950 & birthyr<=1980 & age>=25 & age<=54
keep if fullinfo==1 | incarc==1
collapse (mean) moved [aw=perwt], by(st_fips co_fips_1 birthyr  year)
rename moved moved_wf
tempfile temp_wf
save `temp_wf'
restore

* Collapse for nonwhite males
preserve
keep if female==0 & (race_black==1 | race_other==1)
keep if birthyr>=1950 & birthyr<=1980 & age>=25 & age<=54
keep if fullinfo==1 | incarc==1
collapse (mean) moved [aw=perwt], by(st_fips co_fips_1 birthyr  year)
rename moved moved_nm
tempfile temp_nm
save `temp_nm'
restore

* Collapse for nonwhite women
preserve
keep if female==1 & (race_black==1 | race_other==1)
keep if birthyr>=1950 & birthyr<=1980 & age>=25 & age<=54
keep if fullinfo==1 | incarc==1
collapse (mean) moved [aw=perwt], by(st_fips co_fips_1 birthyr  year)
rename moved moved_nf
tempfile temp_nf
save `temp_nf'
restore



*** MERGE
* Creates birth cohort by survey year data set of share moving 
use `temp_all', clear
merge 1:1 st_fips co_fips_1 birthyr  year using `temp_wm', gen(_mergewm)
merge 1:1 st_fips co_fips_1 birthyr  year using `temp_wf', gen(_mergewf)
merge 1:1 st_fips co_fips_1 birthyr  year using `temp_nm', gen(_mergenm)
merge 1:1 st_fips co_fips_1 birthyr  year using `temp_nf', gen(_mergenf)

label var moved_all "Share of birth cohort that moved away from birth county, all"
label var moved_wm "Share of birth cohort that moved away from birth county, wm"
label var moved_wf "Share of birth cohort that moved away from birth county, wf"
label var moved_nm "Share of birth cohort that moved away from birth county, nm"
label var moved_nf "Share of birth cohort that moved away from birth county, nf"
compress
save "$datatemp/shareMoved.dta", replace


cap log close 
end 


capture program drop mergeToMaster
program define mergeToMaster
syntax, [masterData(string) masterDataBirthmo(string) moverData(string) moverDataBirthmo(string)]

	* not birthmo 
	use `masterData', clear 
	merge 1:1 st_fips co_fips_1 birthyr  year using `moverData',  gen(mergeMover)
	save $datatemp/analysisWithMover.dta, replace 
	*stop;
	* birthmo data
	use `masterDataBirthmo', clear 
	merge 1:1 st_fips co_fips_1 birthyr birthmo year using `moverDataBirthmo' , gen(mergeMover)
	save $datatemp/analysisWithMover_birthmo.dta, replace 
	
end



capture program drop outputTables
program define outputTables
syntax, [dataExposure(string) dataEvent(string)  sample(int 100) indexType(string) shareVar(string) ]


	* First do exposure model specifications and then add event-study and spline due to different datasets 
	log using $dofile/mobilityRegressions.log, replace 
	use if runiform() <= `sample'/100 using `dataExposure', clear

	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen state_year = group(st_fips birthyr)
	

	foreach g in all wm wf nm nf {
		
		* Table names 
		if "`indexType'" == "z_composite" local title "Composite Index, `g'"
		if "`indexType'" == "z_ess" local title "Economic Self Sufficiency Index, `g'"
		if "`indexType'" == "z_hc"  local title  "Human Capital Index, `g'" 
		if "`indexType'" == "z_dis" local title "Disability Index, `g'" 
		if "`indexType'" == "z_nei" local title "Living Quality Index"	
		if "`indexType'" == "dis_7" local title "Share That Lived to 2000, `g'"
		if "`indexType'" == "dis_8" local title "Age at Death, `g'"
		if "`indexType'" == "dis_9" local title "Share That Lived to 2012, `g'"	
		if "`indexType'" == "moved" local title "Share that moved away from birth county, `g'"
		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		
		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"



		
		* Identify sample for exposure models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' `shareVar' shareFSPageIU_5 birthyr birthmo year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 )
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv = round(r(mean), .0001)
		
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 

		* Run exposure models
		local r "replace"  
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		if "`g'" == "all"{
			reghdfe `outcome' `shareVar' shareFSPageIU_5  if sample==1 [aw=`obs'], absorb(fips birthyr birthmo year) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster  nor2 ///
				keep(`shareVar' shareFSP* ) ctitle("Model 1") ///
				adds(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv', nobs, `nobs') ///
				addtext(Birth year,"Yes", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				title("`title'") dec(4) bdec(4) sdec(4) fmt(g) dta
			local r "append"
		}
		if "`g'" == "all"{
		reghdfe `outcome' `shareVar' shareFSPageIU_5 `trends'  if sample==1 [aw=`obs'] , absorb(fips birthyr birthmo year) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
		local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(`shareVar' shareFSP*) ctitle("Model 2" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
				
		local r "append" 
		}
		reghdfe `outcome' `shareVar' shareFSPageIU_5 `trends'  if sample==1 [aw=`obs'] , absorb(fips state_year birthmo year) vce(cluster fips) 
		local cells = round(`e(N)', 1000) 
		local R2 = round(`e(r2)', .0001)
		local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(`shareVar' shareFSP*) ctitle("Model 3" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta		
		restore 
	
	}
	
	
	*** Estimate event-study and spline models using other data 
	use if runiform() <= `sample'/100 using `dataEvent', clear 	 
	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1
	sort fips birthyr
	egen inNumidentSamp=tag(fips birthyr)
	replace inNumidentSamp=. if fips==. | !inrange(birthyr,1950,1980)
	egen state_year = group(st_fips birthyr)	
	
	foreach g in all wm wf nm nf{
		* Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"
		* Identify sample for event study/spline models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' birthyr year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 _TB_exp_*)
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv = r(mean)
		
		* Run event study models	
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 
		rename _TB_exp_* TB_exp_*
		local r "append"
		if "`g'" == "all"{
			reghdfe `outcome' TB_exp_*    if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		}
		reghdfe `outcome' TB_exp_*  if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes",  ///
				State x Birth Year,"Yes",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		if "`g'" == "all"{
			reghdfe `outcome' TB_exp_* `trends'  if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		}	
		reghdfe `outcome' TB_exp_* `trends'  if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year  ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', Counties , `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes",  ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
	
		* Run spline models
		local nonparam1 "TB_exp_1-TB_exp_2 TB_exp_19-TB_exp_25"

		local LSRvars "`nonparam1' spline1_1 spline1_2 spline1_3"			
		* Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 
		if "`g'" == "all"{
			reghdfe `outcome' `LSRvars'  if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year ) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Spline 0") ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		}		
		reghdfe `outcome' `LSRvars'  if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year  ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Spline 1") ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		if "`g'" == "all"{
			reghdfe `outcome' `LSRvars' `trends' if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year  ) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Spline 2") ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		}
		reghdfe `outcome' `LSRvars' `trends'  if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year  ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Spline 3") ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		restore 
	}

	
	
	* Make table 	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 
	foreach g in all wm wf nm nf {
		use $output/table_`indexType'_`g'_dta, clear 
		export excel using $output/`indexType', sheet("`g'", replace )  
	}
	
	cap log close 

end 


capture program drop splineSE
program define splineSE
syntax, [data(string) sample(int 100) indexType(string)]


	*** Estimate event-study and spline models using other data 
	use if runiform() <= `sample'/100 using `data', clear 	 
	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1
	sort fips birthyr
	egen inNumidentSamp=tag(fips birthyr)
	replace inNumidentSamp=. if fips==. | !inrange(birthyr,1950,1980)
	egen state_year = group(st_fips birthyr)	
	* Some modifications to certain indices 
	if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
		* These observations are at the county/birth-month level. No survey-year variation.
		* So get rid of the extra survey years of data
		egen tag = tag(fips birthyr  exactmatch)
		tab birthyr tag, m
		tab year tag, m
		keep if tag==1 & exactmatch==0
		drop tag
	} 
	* make new spline 
	mkspline spline2_1 -2 spline2_2 5 spline2_3 11 spline2_4 = exp
	replace spline2_1=0 if !inrange(exp,-5,17) & exp != .
	replace spline2_2=0 if !inrange(exp,-5,17) & exp != .
	replace spline2_3=0 if !inrange(exp,-5,17) & exp != .
	replace spline2_4=0 if !inrange(exp,-5,17) & exp != .

	local r "replace"

	foreach g in all wm wf nm nf{
	
		* Set weights 
		*if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		*else local obs "obs_`g'"
		if "`indexType'" != "dis_7" & "`indexType'" != "dis_8" & "`indexType'" != "dis_9" & "`indexType'" !="ess_7" & "`indexType'_`g'"!="z_dis_`g'"  {
			local obs "obs_`g'"
		}
		* change if one of special outcomes
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		if "`indexType'"=="ess_7" local obs "obs_inc_`g'"
		if "`indexType'"=="z_dis" local obs "obs_dis_`g'"

		

		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"
		* Identify sample for event study/spline models 
		preserve 
		
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' birthyr year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 _TB_exp_*)
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv = r(mean)
		
		* Run spline models	
		rename _TB_exp_* TB_exp_*
	
		local nonparam1 "TB_exp_1 TB_exp_25"
		local LSRvars "`nonparam1' spline2_1 spline2_2 spline2_3 spline2_4"	
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"

		
		
		 reghdfe `outcome' `LSRvars' `trends' if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year  ) vce(cluster fips) 
		 nlcom   (_b[spline2_1]*(-5+1) - 7*_b[spline2_2] - 4*_b[spline2_3]) (_b[spline2_1]*(-4+1) - 7*_b[spline2_2] - 4*_b[spline2_3]) (_b[spline2_1]*(-3+1) - 7*_b[spline2_2] - 4*_b[spline2_3]) (_b[spline2_1]*(-2+1) - 7*_b[spline2_2] - 4*_b[spline2_3]) ( (-1)*_b[spline2_2]*(6- (-1)) - 4*_b[spline2_3]) ( (-1)*_b[spline2_2]*(6 ) - 4*_b[spline2_3]) ( (-1)*_b[spline2_2]*(6- 1) - 4*_b[spline2_3]) ( (-1)*_b[spline2_2]*(6- 2) - 4*_b[spline2_3]) ( (-1)*_b[spline2_2]*(6- 3) - 4*_b[spline2_3]) ( (-1)*_b[spline2_2]*(6- 4) - 4*_b[spline2_3]) ( (-1)*_b[spline2_2]*(6- 5) - 4*_b[spline2_3]) ( (-1)*_b[spline2_2]*(6- 5) - 4*_b[spline2_3]) ( _b[spline2_3] * (6 - 10) ) ( _b[spline2_3] * (7 - 10) ) ( _b[spline2_3] * (8 - 10) ) ( _b[spline2_3] * (9 - 10) ) ( _b[spline2_3] * (10 - 10) ) ( _b[spline2_3] * (11 - 10) ) ( _b[spline2_3] +  _b[spline2_4]* (12 - 11) ) ( _b[spline2_3] +  _b[spline2_4]* (13 - 11) ) ( _b[spline2_3] +  _b[spline2_4]* (14 - 11) ) ( _b[spline2_3] +  _b[spline2_4]* (15 - 11) ) ( _b[spline2_3] +  _b[spline2_4]* (16 - 11) ) ( _b[spline2_3] +  _b[spline2_4]* (17 - 11) ) ( _b[spline2_3] +  _b[spline2_4]* (18 - 11) ) , post
		 outreg2 using "$tables/splineSE_`indexType'.csv", `r' noparen noaster noobs nor2 ///
				ctitle("`outcome'") ///
				addtext(Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) excel
		local r "append"
		restore 	
	}	
	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 

end


main
