* fs_an_32.do
* Brenden Timpe
* June 2019
* Incarceration regressions using sum of sampling weights and sum of observations to weight regressions
* Updated August 13, 2019: This file is identical to fs_an_31, except that
* it tweaks the way weights are called in the regressions so that the output
* reports the means calculated using the desired weights

global datatemp"/projects/programs/foodstamps/master_folder/datatemp"
global datatempold"/projects/programs/foodstamps/master_folder/disclosure20191014/old_data"
global output "/projects/programs/foodstamps/master_folder/disclosure20191014/output"

cap log close
log using "$output/fs_an_32.log", replace

clear
set matsize 11000

*local test "if runiform(0,1)<.01"	// Comment out unless testing code

* Data at birth county - birth year - year level (not imposing exact matches)
*use "$datatemp/fs_dtacr_2_exactmatch0_newsub_201906.dta" `test', clear
use "$datatemp/fs_dtacr_2_exactmatch0_newsub.dta" `test', clear

keep if inrange(birthyr,1950,1980)

* Create fips for clustering
capture drop fips
gen fips = st_fips*1000+co_fips_1

drop if fips==.
drop if exp==.

* make new spline (4-part)
cap drop spline*
mkspline spline2_1 -2 spline2_2 5 spline2_3 11 spline2_4 = exp
replace spline2_1=0 if !inrange(exp,-5,17) & exp != .
replace spline2_2=0 if !inrange(exp,-5,17) & exp != .
replace spline2_3=0 if !inrange(exp,-5,17) & exp != .
replace spline2_4=0 if !inrange(exp,-5,17) & exp != .
* Create list of event-time dummies to include in spline specification: Those corresponding to event time outside [-5,17]
local spline dummies ""
foreach v of varlist _TB_exp_* {
	su exp if `v'==1
	if !inrange(`r(mean)',-5,17) {
		local splinedummies "`splinedummies' `v'"
	}
}
di "`splinedummies'"


* Run regressions
local r2 replace
foreach g in all nf nm wf wm {
		
	* Loop through outcomes
	foreach y in ess_7_`g' {
	
		local r replace

			
		* SPECIFICATIONS: NEW 7/14/2016
		*local X0 "i.birthyr i.year [pw=`obs']"
		*local X1 "i.birthyr#i.st_fips i.year [pw=`obs']"
		local X2 "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560) [pw=obs_inc_`g']"
		local X2fe "i.birthyr#i.st_fips i.year i.fips"
		local weight2 "obs_inc_`g'"
		local X3 "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560) [pw=perwt_`g']"
		local X3fe "i.birthyr#i.st_fips i.year i.fips"
		
		* Identify sample
		cap drop sample
		egen tmp = rowmiss(`y' birthyr year fips obs_`g' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 _TB_exp_*)
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat obs_inc_`g', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and sample mean			
		sum `y' [aw=obs_inc_`g'] if sample==1
		local nobs = r(sum_w)
		local mdv_2 = `r(mean)'
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `y' [aw=obs_inc_`g'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv5054_2 = r(mean)
		
		* Means using person weights
		sum `y' [aw=perwt_`g'] if sample==1
		local mdv_3 = `r(mean)'
		sum `y' [aw=perwt_`g'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv5054_3 = r(mean)

		* Loop through each group of covariates
		forval i=2/3 {
		
			* EVENT STUDY
			di "reghdfe `y' _TB_exp_* `X`i'' if sample == 1, a(`X`i'fe') vce(cluster fips)"
			di "$S_TIME $S_DATE"
			
			reghdfe `y' _TB_exp_* `X`i'' if sample == 1, a(`X`i'fe') vce(cluster fips)

			outreg2 using "$output/fs_an_32_`y'.txt", `r' noparen noaster ///
				keep(*exp*) ctitle(X`i') ///
				addstat(mdv,`mdv_`i'',mdv 1950-54,`mdv5054_`i'',nobs,`nobs') ///
				adec(11) afmt(g)
			local r append
			
			
			* FOUR-PART SPLINE
			di "reghdfe `y' spline2_? `splinedummies' `X`i'' if sample==1, a(`X`i'fe') vce(cluster fips)"
			di "$S_TIME $S_DATE"
			
			reghdfe `y' spline2_? `splinedummies' `X`i'' if sample==1, a(`X`i'fe') vce(cluster fips)
			
			outreg2 using "$output/fs_an_32_spline.txt", `r2' /*noparen noaster*/ ///
				keep(spline*) ctitle(`y',X`i') ///
				addstat(mdv,`mdv_`i'',mdv 1950-54,`mdv5054_`i'',nobs,`nobs') ///
				adec(11) afmt(g)
			local r2 append
			
			
		}
	}
}

* For ease of looking through spline results: Convert results to Excel
preserve
import delimited using "$output/fs_an_32_spline.txt", clear
export excel using "$output/fs_an_32_spline.xls", replace
restore




*** EXPOSURE MODELS ***
* Switch to dataset collapsed to birth-month level
*use "$datatemp/fs_hsacr_1_newsub_exactmatch0_201906.dta" `test', clear
use "$datatemp/fs_hsacr_1_newsub_exactmatch0.dta" `test', clear

keep if inrange(birthyr,1950,1980)

* Create fips for clustering
capture drop fips
gen fips = st_fips*1000+co_fips_1


* Loop through subgroups
local r replace
foreach g in all nf nm wf wm {
		
	* Loop through outcomes
	foreach y in ess_7_`g' {
	

	
		* SPECIFICATIONS: NEW 7/14/2016
		*local X0 "i.birthyr i.year [pw=`obs']"
		*local X1 "i.birthyr#i.st_fips i.year [pw=`obs']"
		local X2 "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560) [pw=obs_inc_`g']"
		local X2fe "i.birthyr#i.st_fips i.year i.fips i.birthmo"
		local X3 "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560) [pw=perwt_`g']"
		local X3fe "i.birthyr#i.st_fips i.year i.fips i.birthmo"
		
		* Identify sample
		cap drop sample
		egen tmp = rowmiss(`y' birthyr birthmo year fips obs_`g' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 shareFSPageIU_5)
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat obs_`g', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and sample mean			
		sum `y' [aw=obs_inc_`g'] if sample==1
		local nobs = r(sum_w)
		local mdv_2 = `r(mean)'
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `y' [aw=obs_inc_`g'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv5054_2 = r(mean)
		*/
		
		* Means using person weights
		sum `y' [aw=perwt_`g'] if sample==1
		local mdv_3 = `r(mean)'
		sum `y' [aw=perwt_`g'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv5054_3 = `r(mean)'
		
		forval i=2/3 {
		
		
			* Regression
			di "reghdfe `y' shareFSPageIU_5 `X`i'' if sample == 1, a(`X`i'fe') vce(cluster fips)"
			di "$S_TIME $S_DATE"
			
			reghdfe `y' shareFSPageIU_5 `X`i'' if sample == 1, a(`X`i'fe') vce(cluster fips)
		
			outreg2 using "$output/fs_an_32_exposure.txt", `r' /*noparen noaster*/ ///
				keep(shareFSP*) ctitle(`y',X`i') ///
				addstat(mdv,`mdv_`i'',mdv 1950-54,`mdv5054_`i'',nobs,`nobs') ///
				adec(11) afmt(g)
			local r append
		}
	}
}

* For ease of looking through results: Convert results to Excel
preserve
import delimited using "$output/fs_an_32_exposure.txt", clear
export excel using "$output/fs_an_32_exposure.xls", replace
restore


log close
exit


		
