
clear all 
set more off 
set trace on
set tracedepth 2 
*set matsize 11000



*** This set of programs will produce spline models, estimates of main models by 
*** mobility status, models with additional exposure measures, and subindex 
*** models by subgroup .  

	
capture program drop main 
program define main 
	paths
	cap log close 
	log using "$results/mobility_final.log", replace

	*** Exposure, Event study, and spline models ***
	* Exposure model data 
	local data1 "$datatemp/fs_hsacr_1_newsub_exactmatch0.dta"
	* Eventstudy and spline data 
	local data2 "$datatemp/fs_dtacr_2_exactmatch0_newsub.dta"
	local sample = 100	
		
	* merge on fs share variable for 6-18
	/*
	use "`data1'", clear 
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr	discl
	merge m:1 fips birthyr birthmo using $datatemp/FSshare6_18.dta, gen(mergeFSshare518)
	drop fips 
	save "`data1'", replace 
	*/
	
	** Models with both food stamp exposure variables **
	local shareVar "FSshare6_18"
	foreach o in z_composite z_ess z_hc z_dis z_nei {
		outputTables, dataExposure(`data1') dataEvent(`data2') sample(`sample') indexType("`o'") shareVar("`shareVar'")
	}
	local rest ""
	*outcomes for special subindices 
	foreach o in dis_7 dis_8 dis_9 ess_7 {
		outputTablesSpecial, dataExposure(`data1') dataEvent(`data2') sample(`sample') indexType("`o'") shareVar("`shareVar'")
	}
	
	** Do separately for stayers and non-stayers **
	local stayerData1 "$datatemp/fs_hsacr_1_newsub_exactmatch0_withStayers.dta"
	local stayerData2 "$datatemp/fs_dtacr_2_exactmatch0_newsub_withStayers.dta"
	foreach o in z_composite z_ess z_hc z_dis z_nei {
		outputTablesWithStayers, dataExposure(`stayerData1') dataEvent(`stayerData2') sample(`sample') indexType("`o'")
	}

	local vars "dis_7 dis_8 dis_9 ess_7"
	foreach o in dis_7 dis_8 dis_9 ess_7{
		outputTablesSpecialWithStayers, dataExposure(`stayerData1') dataEvent(`stayerData2') sample(`sample') indexType("`o'")
	}
	*/
	local rest "z_composite z_ess z_hc"
	foreach o in z_composite z_ess z_hc z_dis z_nei {
		spline5_17, data(`data2') indexType("`o'") sample(`sample') 
	}
	local vars "dis_9 ess_7"
	foreach o of local vars {
		spline5_17, data(`data2') indexType("`o'") sample(`sample') 
	}
	
	
	** Subindex Models **
	* only unnormalized for full sample 
	local normalized " No"
	local groups "all"
	foreach n of local normalized{
		foreach group of local groups{
			subindexOutputTable, data(`data1') sample(`sample') group("`group'") normalized("`n'")
		}
	}
	* Do unnormalized and normalized for rest of subgroups
	local normalized "No Yes"
	local groups "wf wm nf nm"
	foreach n of local normalized{
		foreach group of local groups{
			subindexOutputTable, data(`data1') sample(`sample') group("`group'") normalized("`n'")
		}
	}
	


end 

capture program drop paths
program define paths

	/*
	global datatemp "/projects/disclosure/20181010/support/data/"
	global output "/projects/disclosure/20181010/old/temp_results"
	global data "/projects/data"
	global countydata "/projects/data/countyLevel"
	global empData "/projects/programs/rwalker/chris/dataSTATA"
	global results "/projects/disclosure/20181010/output"
	*/
	
	global datatemp"/projects/programs/foodstamps/master_folder/datatemp"
	global output "/projects/programs/foodstamps/master_folder/disclosure20181010/temp_results"
	global data "/projects/data"		// project-wide data 
	global countydata "/projects/data/countyLevel"
	global empData "/projects/programs/rwalker/chris/dataSTATA"
	global results "/projects/programs/foodstamps/master_folder/disclosure20181010/results"
	

end 



/******************************************************************************
* outputTables
*
* Produces tables for food stamp exposure, spline and event-study models. 
* 
*
*******************************************************************************/ 

capture program drop outputTables
program define outputTables
syntax, [dataExposure(string) dataEvent(string)  sample(int 100) indexType(string) shareVar(string) ]


	* First do exposure model specifications and then add event-study and spline due to different datasets 
	use if runiform() <= `sample'/100 using `dataExposure', clear

	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen state_year = group(st_fips birthyr)
	

	foreach g in all wm wf nm nf {
		
		* Table names 
		if "`indexType'" == "z_composite" local title "Composite Index, `g'"
		if "`indexType'" == "z_ess" local title "Economic Self Sufficiency Index, `g'"
		if "`indexType'" == "z_hc"  local title  "Human Capital Index, `g'" 
		if "`indexType'" == "z_dis" local title "Disability Index, `g'" 
		if "`indexType'" == "z_nei" local title "Living Quality Index"	
		if "`indexType'" == "dis_7" local title "Share That Lived to 2000, `g'"
		if "`indexType'" == "dis_8" local title "Age at Death, `g'"
		if "`indexType'" == "dis_9" local title "Share That Lived to 2012, `g'"	
		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		
		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"



		
		* Identify sample for exposure models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' `shareVar' shareFSPageIU_5 birthyr birthmo year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 )
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv = round(r(mean), .0001)
		
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 

		* Run exposure models
		local r "replace"  
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		if "`g'" == "all"{
			reghdfe `outcome' `shareVar' shareFSPageIU_5  if sample==1 [aw=`obs'], absorb(fips birthyr birthmo year) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster  nor2 ///
				keep(`shareVar' shareFSP* ) ctitle("Model 1") ///
				adds(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv', nobs, `nobs') ///
				addtext(Birth year,"Yes", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				title("`title'") dec(4) bdec(4) sdec(4) fmt(g) dta
			local r "append"
		}
		if "`g'" == "all"{
		reghdfe `outcome' `shareVar' shareFSPageIU_5 `trends'  if sample==1 [aw=`obs'] , absorb(fips birthyr birthmo year) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
		local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(`shareVar' shareFSP*) ctitle("Model 2" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
				
		local r "append" 
		}
		reghdfe `outcome' `shareVar' shareFSPageIU_5 `trends'  if sample==1 [aw=`obs'] , absorb(fips state_year birthmo year) vce(cluster fips) 
		local cells = round(`e(N)', 1000) 
		local R2 = round(`e(r2)', .0001)
		local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(`shareVar' shareFSP*) ctitle("Model 3" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta		
		restore 
	
	}
	
	
	
	* Make table 	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 
	foreach g in all wm wf nm nf {
		use $output/table_`indexType'_`g'_dta, clear 
		export excel using $results/both/`indexType', sheet("`g'", replace )  
	}
	
end 


/******************************************************************************
* outputTablesSpecial 
*
* Similar to previous subprogram but specific to a specific set of indices. 
*
*******************************************************************************/
capture program drop outputTablesSpecial 
program define outputTablesSpecial
syntax, [dataExposure(string) dataEvent(string)  sample(int 100) indexType(string) shareVar(string)]


	* First do exposure model specifications and then add event-study and spline due to different datasets 
	use if runiform() <= `sample'/100 using `dataExposure', clear

	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen inNumidentSamp=tag(fips birthyr)
	replace inNumidentSamp=. if fips==. | !inrange(birthyr,1950,1980)
	egen state_year = group(st_fips birthyr)
	
	* Some modifications to certain indices 
	if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
		* These observations are at the county/birth-month level. No survey-year variation.
		* So get rid of the extra survey years of data
		egen tag = tag(fips birthyr birthmo exactmatch)
		tab birthyr tag, m
		tab year tag, m
		keep if tag==1 & exactmatch==0
		drop tag
	} 
	

	foreach g in all wm wf nm nf {
		
		* Table names 
		if "`indexType'" == "z_composite" local title "Composite Index, `g'"
		if "`indexType'" == "z_ess" local title "Economic Self Sufficiency Index, `g'"
		if "`indexType'" == "z_hc"  local title  "Human Capital Index, `g'" 
		if "`indexType'" == "z_dis" local title "Disability Index, `g'" 
		if "`indexType'" == "z_nei" local title "Living Quality Index"	
		if "`indexType'" == "dis_7" local title "Share That Lived to 2000, `g'"
		if "`indexType'" == "dis_8" local title "Age at Death, `g'"
		if "`indexType'" == "dis_9" local title "Share That Lived to 2012, `g'"	
		if "`indexType'" == "ess_7" local title "Share Not Incarcerated, `g'"

		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		if "`indexType'"=="ess_7" local obs "obs_inc_`g'"

		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"



		
		* Identify sample for exposure models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' `shareVar' shareFSPageIU_5 birthyr year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 )
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		

		if "`indexType'" == "ess_7" {
		  * Capture number of underlying observations				
		  sum `obs' if sample==1
		  local nobs = r(sum)
		  sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) 	
		  local mdv = r(mean)
		}
		
		* report following additional statistics for these indices 
	*	if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {					
			* Calculate mean for 1950-54
			sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1
			local mdv5054 = r(mean)
			local sd5054 = r(sd)
		
			* Calculate mean for 1950-80
			sum `indexType'_`g' [aw=`obs'] if sample==1
			local mdv = r(mean)
			local sd = r(sd)
			local nobs = r(sum_w)
	*	}
		
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 

		* Run exposure models
		* Models 0 and 2 not estimated for subgroups
		local r "replace"  
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		if "`g'" == "all"{
			reghdfe `outcome' `shareVar' shareFSPageIU_5 if sample==1 [aw=`obs'], absorb(fips birthyr birthmo year ) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(`shareVar' shareFSP*) ctitle("Model 1" ) ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
			local r "append"
		}
		if "`g'"=="all"{
			reghdfe `outcome' `shareVar' `trends' shareFSPageIU_5  if sample==1 [aw=`obs'] , absorb(fips birthyr birthmo year ) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(`shareVar' shareFSP*) ctitle("Model 2" ) ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
				
			local r "append" 
		}		
		reghdfe `outcome' `shareVar' `trends' shareFSPageIU_5 if sample==1 [aw=`obs'] , absorb(fips state_year birthmo year ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
		local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(`shareVar' shareFSP*) ctitle("Model 3" ) ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta		
		restore 
	
	}

	
	* Make table 	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 
	foreach g in all wm wf nm nf {
		use $output/table_`indexType'_`g'_dta, clear 
		export excel using $results/both/`indexType', sheet("`g'", replace )  
	}
	
end



capture program drop outputTablesWithStayers
program define outputTablesWithStayers
syntax, [dataExposure(string) dataEvent(string)  sample(int 100) indexType(string) ]


	* First do exposure model specifications and then add event-study and spline due to different datasets 
	use if runiform() <= `sample'/100 using `dataExposure', clear

	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen state_year = group(st_fips birthyr)
	
	
	foreach g in all  {
		
		* Table names 
		if "`indexType'" == "z_composite" local title "Composite Index, `g'"
		if "`indexType'" == "z_ess" local title "Economic Self Sufficiency Index, `g'"
		if "`indexType'" == "z_hc"  local title  "Human Capital Index, `g'" 
		if "`indexType'" == "z_dis" local title "Disability Index, `g'" 
		if "`indexType'" == "z_nei" local title "Living Quality Index"	
		if "`indexType'" == "dis_7" local title "Share That Lived to 2000, `g'"
		if "`indexType'" == "dis_8" local title "Age at Death, `g'"
		if "`indexType'" == "dis_9" local title "Share That Lived to 2012, `g'"	
		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		
		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"



		
		* Identify sample for exposure models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' shareFSPageIU_5 birthyr birthmo year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 )
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1 & stayer == 1
		local nobsStayer = round(r(sum), 1000)
		sum `obs' if sample==1 & stayer == 0
		local nobsMover = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1 & stayer== 1
		local mdvStayer = round(r(mean), .0001)
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1 & stayer== 0
		local mdvMover = round(r(mean), .0001)

		
		*Order of models 
		* birthyr year 
		* stateyr year 
		* birthyr year trends * in subgroup
		* stateyear year trends *in subgroup

		* Run exposure models
		* Models 1 and 2 not estimated for subgroups
		local r "replace"  
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		
		* Only Model 4 	
		reghdfe `outcome' `shareVar' shareFSPageIU_5 `trends'  if sample==1 & stayer== 1  [aw=`obs'] , absorb(fips state_year birthmo year) vce(cluster fips) 
		local cells = round(`e(N)', 1000) 
		local R2 = round(`e(r2)', .0001)
		local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(`shareVar' shareFSP*) ctitle("Model 3" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdvStayer',nobs,`nobsStayer') ///
				addtext(Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes", Stayer, "Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		
		local r "append"
		reghdfe `outcome' `shareVar' shareFSPageIU_5 `trends'  if sample==1 & stayer== 0  [aw=`obs'] , absorb(fips state_year birthmo year) vce(cluster fips) 
		local cells = round(`e(N)', 1000) 
		local R2 = round(`e(r2)', .0001)
		local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(`shareVar' shareFSP*) ctitle("Model 3" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdvMover',nobs,`nobsMover') ///
				addtext(Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes", Stayer, "No") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta		
		restore 
	
	}
	
	
	* Make table 	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 
	foreach g in all  {
		use $output/table_`indexType'_`g'_dta, clear 
		export excel using $results/bymobility/`indexType'_withStayers, sheet("`g'", replace )  
	}
	
	
end 


/******************************************************************************
* outputTablesSpecial 
*
* Similar to previous subprogram but specific to a specific set of indices. 
*
*******************************************************************************/
capture program drop outputTablesSpecialWithStayers 
program define outputTablesSpecialWithStayers
syntax, [dataExposure(string) dataEvent(string)  sample(int 100) indexType(string) ]


	* First do exposure model specifications and then add event-study and spline due to different datasets 
	use if runiform() <= `sample'/100 using `dataExposure', clear

	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen inNumidentSamp=tag(fips birthyr)
	replace inNumidentSamp=. if fips==. | !inrange(birthyr,1950,1980)
	egen state_year = group(st_fips birthyr)
	
	* Some modifications to certain indices 
	if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
		* These observations are at the county/birth-month level. No survey-year variation.
		* So get rid of the extra survey years of data
		egen tag = tag(fips birthyr birthmo stayer exactmatch)
		tab birthyr tag, m
		tab year tag, m
		keep if tag==1 & exactmatch==0
		drop tag
	} 
	

	foreach g in all  {
		
		* Table names 
		if "`indexType'" == "z_composite" local title "Composite Index, `g'"
		if "`indexType'" == "z_ess" local title "Economic Self Sufficiency Index, `g'"
		if "`indexType'" == "z_hc"  local title  "Human Capital Index, `g'" 
		if "`indexType'" == "z_dis" local title "Disability Index, `g'" 
		if "`indexType'" == "z_nei" local title "Living Quality Index"	
		if "`indexType'" == "dis_7" local title "Share That Lived to 2000, `g'"
		if "`indexType'" == "dis_8" local title "Age at Death, `g'"
		if "`indexType'" == "dis_9" local title "Share That Lived to 2012, `g'"	
		if "`indexType'" == "ess_7" local title "Share Not Incarcerated, `g'"

		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		if "`indexType'"=="ess_7" local obs "obs_inc_`g'"

		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"



		
		* Identify sample for exposure models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' shareFSPageIU_5 birthyr year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 )
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1 & stayer == 1
		local nobsStayer = round(r(sum), 1000)
		sum `obs' if sample==1 & stayer == 0
		local nobsMover = round(r(sum), 1000)
		
			
		* Calculate mean for 1950-54
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1 & stayer ==1
		local mdvStayer = r(mean)
		local sdStayer = r(sd)
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1 & stayer ==0
		local mdvMover = r(mean)
		local sdMover = r(sd)


	
		* Run exposure models
		* Models 1 and 2 not estimated for subgroups
		local r "replace"  
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		
		
		reghdfe `outcome' `shareVar' shareFSPageIU_5 `trends'  if sample==1 & stayer== 1  [aw=`obs'] , absorb(fips state_year birthmo year) vce(cluster fips) 
		local cells = round(`e(N)', 1000) 
		local R2 = round(`e(r2)', .0001)
		local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(`shareVar' shareFSP*) ctitle("Model 3" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdvStayer',nobs,`nobsStayer') ///
				addtext(Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes", Stayer, "Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		
		local r "append"
		reghdfe `outcome' `shareVar' shareFSPageIU_5 `trends'  if sample==1 & stayer== 0  [aw=`obs'] , absorb(fips state_year birthmo year) vce(cluster fips) 
		local cells = round(`e(N)', 1000) 
		local R2 = round(`e(r2)', .0001)
		local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(`shareVar' shareFSP*) ctitle("Model 3" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdvMover',nobs,`nobsMover') ///
				addtext(Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes", Stayer, "No") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta		
		restore 
	
	}
	
	
	
	* Make table 	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 
	foreach g in all wm wf nm nf {
		use $output/table_`indexType'_`g'_dta, clear 
		export excel using $results/bymobility/`indexType'_withStayers, sheet("`g'", replace )  
	}
	
end



/******************************************************************************
* subindexOutputTable
*
* FSP exposure models where the outcome variables are subindices that compose the 
* indices explored in other tables. 
*
*******************************************************************************/
capture program drop subindexOutputTable
program define subindexOutputTable
syntax, [data(string) sample(int 100) normalized(string) group(string)]

	use if runiform() <=`sample'/100 using `data', clear 
	keep if inrange(birthyr,1950,1980)

	drop if birthmo==.  // Shouldn't do anything

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1

	egen state_year = group(st_fips birthyr)
	drop ess_11_* ess_7_* 
	/*
	* Determine which subindices make it to final table
	local si ""
	foreach y of varlist ess_*_all hc_*_all  nei_*_all{
		local si "`si' `y'"
	}


	local dis "dis_1_all dis_2_all dis_3_all dis_4_all dis_5_all dis_6_all dis_7_all dis_8_all"
	local si "`si' `dis'"
	di "`si'"
	*/
	local stubs_ess "ess_1 ess_2 ess_3 ess_4 ess_5 ess_5_1 ess_6 ess_6 ess_8 ess_8_1 ess_9 ess_10 "
	local stubs_hc "hc_1 hc_2 hc_3 hc_4 hc_5 hc_6"
	local stubs_nei "nei_1 nei_1_1 nei_2  nei_3 nei_4 nei_5 nei_5_1 nei_6 nei_7 nei_8 nei_9 nei_10 nei_11 nei_12"
	local stubs_dis "dis_1 dis_2 dis_3 dis_4 dis_5 dis_6 dis_7 dis_8"
	local stubs "`stubs_ess' `stubs_hc' `stubs_nei' `stubs_dis'"
	
	* Determine which group analysis will be done over 
	if("`group'" == "all"){
		local si ""
		foreach s of local stubs{
			local si "`si' `s'_all"
		}
	}
	if("`group'" == "wm"){
		local si ""
		foreach s of local stubs{
			local si "`si' `s'_wm"
		}
	}
	if("`group'" == "wf"){
		local si ""
		foreach s of local stubs{
			local si "`si' `s'_wf"
		}
	}
	if("`group'" == "nm"){
		local si ""
		foreach s of local stubs{
			local si "`si' `s'_nm"
		}
	}
	if("`group'" == "nf"){
		local si ""
		foreach s of local stubs{
			local si "`si' `s'_nf"
		}
	}
	
	
	
	
	* Determine if using normalized or not 
	if ("`normalized'"=="Yes"){ 
		local newsi ""
		foreach s of local si {
			local newsi "`newsi' z_`s'"
		}
		local si "`newsi'"
	}
	
	


	local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
	
	* Make table 
	local r "replace"
	foreach subindex of varlist `si'{
		
		* we don't have data for this subindex for nm 
		if "`subindex'" == "z_nei_1_1_nm"{
			continue
		}
		preserve
		*set weights
		if (substr("`subindex'",1,3)=="dis" & "`normalized'" != "Yes") | (substr("`subindex'",3,3)=="dis" & "`normalized'"=="Yes") local obs "obs_dis_`group'"
		else local obs "obs_`group'"
						
		
		* Identify sample
		cap drop sample
		egen tmp = rowmiss(`subindex' shareFSPageIU_5 birthyr birthmo year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60)
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
			
		* Capture number of underlying observations				
		sum `subindex' [aw=`obs'] if inrange(birthyr,1950,1980) & sample==1	
		local mdv = round(r(mean), .0001)
		local nobs = round(r(sum_w), 1000)
		
		* State-year model 
		reghdfe `subindex' shareFSPageIU_5 `trends'  if sample==1 [aw=`obs'], absorb(fips state_year birthmo year) vce(cluster fips) 
		local cells = round(e(N), 1000)
		local counties = e(N_clust)
		outreg2 using "$results/subindex/fs_subindices_`group'_normalized`normalized'", `r' noparen noaster noobs ///
					keep(shareFSP*) ctitle("`subindex'") ///
					addstat(Cells, `cells', Counties, `counties', mdv, `mdv', nobs,`nobs') ///
					addtext(Birth year,"No",Birth month,"Yes", Survey year,"Yes",  ///
					State x Birth Year,"Yes", County trends,"Yes") ///
					dec(4) bdec(4) fmt(g) excel
		local r "append"
		restore 

	}

end 






capture program drop spline5_17
program define spline5_17
syntax, [data(string) sample(int 100) indexType(string)]

	use if runiform() <= `sample'/100 using `data', clear 	 
	keep if inrange(birthyr,1950,1980)
	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1
	sort fips birthyr
	egen inNumidentSamp=tag(fips birthyr)
	replace inNumidentSamp=. if fips==. | !inrange(birthyr,1950,1980)
	egen state_year = group(st_fips birthyr)	

		
	* Some modifications to certain indices 
	if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
		* These observations are at the county/birth-month level. No survey-year variation.
		* So get rid of the extra survey years of data
		egen tag = tag(fips birthyr  exactmatch)
		tab birthyr tag, m
		tab year tag, m
		keep if tag==1 & exactmatch==0
		drop tag
	} 


	
	* make new spline 
	mkspline spline2_1 -2 spline2_2 5 spline2_3 11 spline2_4 = exp
	replace spline2_1=0 if !inrange(exp,-5,17) & exp != .
	replace spline2_2=0 if !inrange(exp,-5,17) & exp != .
	replace spline2_3=0 if !inrange(exp,-5,17) & exp != .
	replace spline2_4=0 if !inrange(exp,-5,17) & exp != .



	foreach g in all wm wf nm nf{
	
		* Set weights 
		*if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		*else local obs "obs_`g'"
		if "`indexType'" != "dis_7" & "`indexType'" != "dis_8" & "`indexType'" != "dis_9" & "`indexType'" !="ess_7" & "`indexType'_`g'"!="z_dis_`g'"  {
			local obs "obs_`g'"
		}
		* change if one of special outcomes
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		if "`indexType'"=="ess_7" local obs "obs_inc_`g'"
		if "`indexType'"=="z_dis" local obs "obs_dis_`g'"

		

		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"
		* Identify sample for event study/spline models 
		preserve 
		
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' birthyr year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 _TB_exp_*)
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv = r(mean)
		
		* Run spline models
		/*
		local nonparam1 "TB_exp_1-TB_exp_2 TB_exp_19-TB_exp_25"
		local LSRvars "`nonparam1' spline1_1 spline1_2 spline1_3"					
		reghdfe `outcome' `LSRvars'  `trends' if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year  ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Spline 1") ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		*/	
			rename _TB_exp_* TB_exp_*
	
		local nonparam1 "TB_exp_1 TB_exp_25"
		local LSRvars "`nonparam1' spline2_1 spline2_2 spline2_3 spline2_4"	
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"

		local r "replace"
		if "`g'"=="all"{
		  reghdfe `outcome' `LSRvars' if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year  ) vce(cluster fips) 
		  local cells = round(`e(N)', 1000)
		  local R2 = round(`e(r2)', .0001)
		  local counties = e(N_clust)
		  outreg2 using "$output/splinem5_p17_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Model 1") ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		  local r "append"	
		  reghdfe `outcome' `LSRvars'  `trends' if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year  ) vce(cluster fips) 
		  local cells = round(`e(N)', 1000)
		  local R2 = round(`e(r2)', .0001)
		  local counties = e(N_clust)
		  outreg2 using "$output/splinem5_p17_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Model 2")  ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		  local r "append"
		 }
		 reghdfe `outcome' `LSRvars'  `trends' if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year  ) vce(cluster fips) 
		 local cells = round(`e(N)', 1000)
		 local R2 = round(`e(r2)', .0001)
		 local counties = e(N_clust)
		 outreg2 using "$output/splinem5_p17_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Model 3") ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"No", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta	
		restore 	
	}	
	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 
	foreach g in all wm wf nm nf {
		use $output/splinem5_p17_`indexType'_`g'_dta, clear 
		export excel using $results/spline/splinem5_p17_`indexType', sheet("`g'", replace )  
	}
end

main
