* Originally from disclosure 04/08/2018

* Edit 4/16/2021 by Kate Moulton: replaced `e(K1)' with `e(N_clust)' since e(K1) does not exist

clear all 
set more off 
set trace on
set tracedepth 2 
*set matsize 11000


	
capture program drop main 
program define main 
	paths
	cap log close 
	log using "$output/disclosure20180408.log", replace

	*** Exposure, Event study, and spline models ***
	* Exposure model data 
	local data1 "$datatemp/fs_hsacr_1_newsub_exactmatch0.dta"
	* Eventstudy and spline data 
	local data2 "$datatemp/fs_dtacr_2_exactmatch0_newsub.dta"
	* Sample sets what percent of the data to use
	local sample = 100
	
	* tables for index outcomes
	foreach o in z_composite z_ess z_hc z_dis z_nei{
		outputTables, dataExposure(`data1') dataEvent(`data2') sample(`sample') indexType("`o'")
	}
	*outcomes for special subindices 
	foreach o in dis_7 dis_8 dis_9 ess_7{
		outputTablesSpecial, dataExposure(`data1') dataEvent(`data2') sample(`sample') indexType("`o'")
	}


	* Models 2 and 4 for all subindices
	subindexOutputTable, data(`data1') sample(`sample')


	*** Balance Tables ***
	local reisData "$data/reis_combine.dta"
	local wicData "$countydata/WIC_startdate.dta"
	local transfersData "$data/reis_transfers_1959_2010.dta"
	local aerData "$data/aer_data.dta"
	local hsData "$data/treatment_dtacr_6.dta"
	local output "$data/shareFSPBalanceData.dta"
	local empData "$empData/preppedData_county_birthyr_birthmo_year100100.dta"
	local trendData "$countydata/cityctydb60.dta"
	makeBalanceTableData, shareFSPData(`data1') empData(`empData') reisData(`reisData') wicData(`wicData') transfersData(`transfersData') aerData(`aerData') hsData(`hsData') outputData(`output') trendData(`trendData')

	balanceTable1share, data(`output') sample(`sample') unrestricted("Yes") collapse("Yes")

	balanceTable2, data(`output')

	*** Robustness tables ***	
	robustnessPop, data(`output') sample(`sample') // code for the "all" models 


	

end 

capture program drop paths
program define paths

/*Old paths
	global datatemp "/projects/programs/btimpe/foodstamps/datatemp/"
	global output "/projects/disclosure/20180408/temp_results"
	global data "/projects/data"
	global countydata "/projects/data/countyLevel"
	global empData "/projects/programs/rwalker/chris/dataSTATA"
*/

* New paths
	global datatemp"/projects/programs/foodstamps/master_folder/datatemp"
	global output "/projects/programs/foodstamps/master_folder/disclosure20180408/output"
	global data "/projects/data"		// project-wide data 
	global countydata "/projects/data/countyLevel"
	global empData "/projects/programs/rwalker/chris/dataSTATA"

end 

/******************************************************************************
* outputTables
*
* Produces tables for food stamp exposure, spline and event-study models. 
* 
*
*******************************************************************************/ 

capture program drop outputTables
program define outputTables
syntax, [dataExposure(string) dataEvent(string)  sample(int 100) indexType(string) ]


	* First do exposure model specifications and then add event-study and spline due to different datasets 
	use if runiform() <= `sample'/100 using `dataExposure', clear

	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen state_year = group(st_fips birthyr)
	

	foreach g in all wm wf nm nf {
		
		* Table names 
		if "`indexType'" == "z_composite" local title "Composite Index, `g'"
		if "`indexType'" == "z_ess" local title "Economic Self Sufficiency Index, `g'"
		if "`indexType'" == "z_hc"  local title  "Human Capital Index, `g'" 
		if "`indexType'" == "z_dis" local title "Disability Index, `g'" 
		if "`indexType'" == "z_nei" local title "Living Quality Index"	
		if "`indexType'" == "dis_7" local title "Share That Lived to 2000, `g'"
		if "`indexType'" == "dis_8" local title "Age at Death, `g'"
		if "`indexType'" == "dis_9" local title "Share That Lived to 2012, `g'"	
		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		
		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"



		
		* Identify sample for exposure models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' shareFSPageIU_5 birthyr birthmo year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 )
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv = round(r(mean), .0001)
		
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 

		* Run exposure models
		* Models 0 and 2 not estimated for subgroups
		* Model 0
		local r "replace"  
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		if "`g'" == "all"{
			reghdfe `outcome' shareFSPageIU_5  if sample==1 [aw=`obs'], absorb(fips birthyr birthmo year) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster  nor2 ///
				keep(shareFSPageIU_5) ctitle("Exposure 0") ///
				adds(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv', nobs, `nobs') ///
				addtext(Birth year,"Yes", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				title("`title'") dec(4) bdec(4) sdec(4) fmt(g) dta
			local r "append"
		}
				
		* Model 1
		reghdfe `outcome' shareFSPageIU_5  if sample==1 [aw=`obs'] , absorb(fips state_year birthmo year) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(shareFSP*) ctitle("Exposure 1" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"No") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		local r "append"
		if "`g'" == "all"{
			* Model 2
			reghdfe `outcome' shareFSPageIU_5 `trends'  if sample==1 [aw=`obs'] , absorb(fips birthyr birthmo year) vce(cluster fips) 
 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(shareFSP*) ctitle("Exposure 2" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
				
			local r "append" 
		}
		* Model 3 (preferred model)
		reghdfe `outcome' shareFSPageIU_5 `trends'  if sample==1 [aw=`obs'] , absorb(fips state_year birthmo year) vce(cluster fips) 
		local cells = round(`e(N)', 1000) 
		local R2 = round(`e(r2)', .0001)
		local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(shareFSP*) ctitle("Exposure 3" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta		
		restore 
	
	}
	
	
	*** Estimate event-study and spline models using other data 
	use if runiform() <= `sample'/100 using `dataEvent', clear 	 
	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1
	sort fips birthyr
	egen inNumidentSamp=tag(fips birthyr)
	replace inNumidentSamp=. if fips==. | !inrange(birthyr,1950,1980)
	egen state_year = group(st_fips birthyr)	
	
	foreach g in all wm wf nm nf{
		* Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"
		* Identify sample for event study/spline models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' birthyr year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 _TB_exp_*)
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv = r(mean)
		
		* Run event study models	
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 
		rename _TB_exp_* TB_exp_*
		local r "append"
		if "`g'" == "all"{
			reghdfe `outcome' TB_exp_*    if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		}
		reghdfe `outcome' TB_exp_*  if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes",  ///
				State x Birth Year,"Yes",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		if "`g'" == "all"{
			reghdfe `outcome' TB_exp_* `trends'  if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		}	
		reghdfe `outcome' TB_exp_* `trends'  if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year  ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', Counties , `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes",  ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
	
		* Run spline models
		local nonparam1 "TB_exp_1-TB_exp_2 TB_exp_19-TB_exp_25"

		local LSRvars "`nonparam1' spline1_1 spline1_2 spline1_3"			
		* Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 
		if "`g'" == "all"{
			reghdfe `outcome' `LSRvars'  if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year ) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Spline 0") ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		}		
		reghdfe `outcome' `LSRvars'  if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year  ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Spline 1") ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		if "`g'" == "all"{
			reghdfe `outcome' `LSRvars' `trends' if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year  ) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Spline 2") ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		}
		reghdfe `outcome' `LSRvars' `trends'  if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year  ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Spline 3") ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		restore 
	}

	
	
	* Make table 	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 
	foreach g in all wm wf nm nf {
		use $output/table_`indexType'_`g'_dta, clear 
		export excel using $output/`indexType', sheet("`g'", replace )  
	}
	
end 


/******************************************************************************
* outputTablesSpecial 
*
* Similar to previous subprogram but specific to a specific set of indices. 
*
*******************************************************************************/
capture program drop outputTablesSpecial 
program define outputTablesSpecial
syntax, [dataExposure(string) dataEvent(string)  sample(int 100) indexType(string) ]


	* First do exposure model specifications and then add event-study and spline due to different datasets 
	use if runiform() <= `sample'/100 using `dataExposure', clear

	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen inNumidentSamp=tag(fips birthyr) //special
	replace inNumidentSamp=. if fips==. | !inrange(birthyr,1950,1980) //special
	egen state_year = group(st_fips birthyr)
	
	* Some modifications to certain indices //special
	if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
		* These observations are at the county/birth-month level. No survey-year variation.
		* So get rid of the extra survey years of data
		egen tag = tag(fips birthyr birthmo exactmatch)
		tab birthyr tag, m
		tab year tag, m
		keep if tag==1 & exactmatch==0
		drop tag
	} 
	

	foreach g in all wm wf nm nf {
		
		* Table names 
		if "`indexType'" == "z_composite" local title "Composite Index, `g'"
		if "`indexType'" == "z_ess" local title "Economic Self Sufficiency Index, `g'"
		if "`indexType'" == "z_hc"  local title  "Human Capital Index, `g'" 
		if "`indexType'" == "z_dis" local title "Disability Index, `g'" 
		if "`indexType'" == "z_nei" local title "Living Quality Index"	
		if "`indexType'" == "dis_7" local title "Share That Lived to 2000, `g'"
		if "`indexType'" == "dis_8" local title "Age at Death, `g'"
		if "`indexType'" == "dis_9" local title "Share That Lived to 2012, `g'"	
		if "`indexType'" == "ess_7" local title "Share Not Incarcerated, `g'"

		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		if "`indexType'"=="ess_7" local obs "obs_inc_`g'"

		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"



		
		* Identify sample for exposure models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' shareFSPageIU_5 birthyr year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 ) //special does not include birthmo
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
	
		if "`indexType'" == "ess_7" {
		  * Capture number of underlying observations	// special			
		  sum `obs' if sample==1
		  local nobs = r(sum)
		  sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) 	
		  local mdv = r(mean)
		}
		
		* report following additional statistics for these indices 
	*	if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {					
			* Calculate mean for 1950-54
			sum `indexType'_`g' if inrange(birthyr,1950,1954) & sample==1
			local mdv5054 = r(mean)
			local sd5054 = r(sd)
		
			* Calculate mean for 1950-80
			sum `indexType'_`g' [aw=`obs'] if sample==1
			local mdv = r(mean)
			local sd = r(sd)
			local nobs = r(sum_w)
	*	}
		
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 

		* Run exposure models
		* Models 0 and 2 not estimated for subgroups
		local r "replace"  
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		if "`g'" == "all"{
			reghdfe `outcome' shareFSPageIU_5  if sample==1 [aw=`obs'], absorb(fips birthyr birthmo year ) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(shareFSP*) ctitle("Exposure 0" ) ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
			local r "append"
		}
		reghdfe `outcome' shareFSPageIU_5   if sample==1 [aw=`obs'] , absorb(fips state_year birthmo year ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(shareFSP*) ctitle("Exposure 1" ) ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"No") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		local r "append"
		if "`g'" == "all"{
			reghdfe `outcome' shareFSPageIU_5 `trends'   if sample==1 [aw=`obs'] , absorb(fips birthyr birthmo year ) vce(cluster fips) 
 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(shareFSP*) ctitle("Exposure 2" ) ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
				
			local r "append" 
		}		
		reghdfe `outcome' shareFSPageIU_5 `trends'  if sample==1 [aw=`obs'] , absorb(fips state_year birthmo year ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(shareFSP*) ctitle("Exposure 3" ) ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta		
		restore 
	
	}
	
	*** Estimate event-study and spline models using other data 
	use if runiform() <= `sample'/100 using `dataEvent', clear 	 
	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1
	sort fips birthyr
	egen inNumidentSamp=tag(fips birthyr)
	replace inNumidentSamp=. if fips==. | !inrange(birthyr,1950,1980)
	egen state_year = group(st_fips birthyr)	
	
	* Some modifications to certain indices // special
	if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
		* These observations are at the county/birth-month level. No survey-year variation.
		* So get rid of the extra survey years of data
		egen tag = tag(fips birthyr  exactmatch)
		tab birthyr tag, m
		tab year tag, m
		keep if tag==1 & exactmatch==0
		drop tag
	} 
	
	
	foreach g in all wm wf nm nf{
		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* Specific weights for these indices // special
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		if "`indexType'"=="ess_7" local obs "obs_inc_`g'"

		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"
		* Identify sample for event study/spline models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' birthyr year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 _TB_exp_* spline1_1 spline1_2 spline1_3) // special includes spline
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv = r(mean)
		
		* Calculate mean for 1950-54 // special
		sum `outcome' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1
		local mdv5054 = r(mean)
		local sd5054 = r(sd)
		
		* Calculate mean for 1950-80
		sum `outcome' [aw=`obs'] if sample==1
		local mdv = r(mean)
		local sd = r(sd)
		local nobs = r(sum_w)
		
		* Run event study models	
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 
		rename _TB_exp_* TB_exp_*
		local r "append"
		if "`g'" == "all"{
			reghdfe `outcome' TB_exp_* if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year  ) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		}
		reghdfe `outcome' TB_exp_*  if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year ) vce(cluster fips)
		local cells = round(`e(N)', 1000) 
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes",  ///
				State x Birth Year,"Yes",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		if "`g'" == "all"{
			reghdfe `outcome' TB_exp_* `trends'  if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
			outreg2 using "$output/table_`outcome'", `r' noparen noaster nobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		}	
		reghdfe `outcome' TB_exp_* `trends'  if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes",  ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
	
		* Run spline models
		local nonparam1 "TB_exp_1-TB_exp_2 TB_exp_19-TB_exp_25"

		local LSRvars "`nonparam1' spline1_1 spline1_2 spline1_3"			
		* Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 
		if "`g'" == "all"{
			reghdfe `outcome' `LSRvars'  if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year ) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Spline 0") ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		}		
		reghdfe `outcome' `LSRvars' if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Spline 1") ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		if "`g'" == "all"{
			reghdfe `outcome' `LSRvars' `trends'  if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year ) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Spline 2") ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		}
		reghdfe `outcome' `LSRvars' `trends'  if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = e(N_clust)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Spline 3") ///
				addstat(Cells, `cells', R squared, `R2', mdv,`mdv',sd,`sd',mdv5054,`mdv5054',sd5054,`sd5054', Counties, `counties', k, `e(df_m)',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		restore 
	}

	
	
	* Make table 	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 
	foreach g in all wm wf nm nf {
		use $output/table_`indexType'_`g'_dta, clear 
		export excel using $output/`indexType', sheet("`g'", replace )  
	}
	
end


/******************************************************************************
* subindexOutputTable
*
* FSP exposure models where the outcome variables are subindices that compose the 
* indices explored in other tables. 
*
*******************************************************************************/
capture program drop subindexOutputTable
program define subindexOutputTable
syntax, [data(string) sample(int 100)]

	use if runiform() <=`sample'/100 using `data', clear 
	
	keep if inrange(birthyr,1950,1980)

	drop if birthmo==.  // Shouldn't do anything

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1

	egen state_year = group(st_fips birthyr)

	* Determine which subindices make it to final table
	local si ""
	* Find total number of obs for superindex and only keep subindices with same number of observations (probably those were used to build superindex)
	sum z_ess_all
	local nobs = e(N)
	foreach y of varlist z_ess_*_all   {
		sum `y'
		if e(N) == `nobs' local si "`si' `y'"
	}

	sum z_hc_all
	local nobs = e(N)
	foreach y of varlist z_hc_*_all{
		sum `y'
		if e(N) == `nobs' local si "`si' `y'"
	}


	sum z_dis_all
	local nobs = e(N)
	foreach y of varlist z_dis_*_all{
		sum `y'
		if e(N) == `nobs' local si "`si' `y'"
	}

	sum z_nei_all
	local nobs = e(N)
	foreach y of varlist z_nei_*_all{
		sum `y'
		if e(N) == `nobs' local si "`si' `y'"
	}
	local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"

	* Make table 
	local r "replace"
	foreach subindex of varlist `si'{
		if "`subindex'" == "z_ess_11" | "`subindex'" == "z_dis_7" | "`subindex'" == "z_dis_8"{
			continue
		}
		preserve
		*set weights
		if substr("`subindex'",3,3)=="dis" local obs "obs_dis_all"
		else local obs "obs_all"
						
		
		* Identify sample
		cap drop sample
		egen tmp = rowmiss(`subindex' shareFSPageIU_5 birthyr birthmo year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60)
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
			
		* Capture number of underlying observations				
		sum `subindex' [aw=`obs'] if inrange(birthyr,1950,1980) & sample==1	
		local mdv = round(r(mean), .0001)
		local nobs = round(r(sum_w), 1000)
				
		reghdfe `subindex' shareFSPageIU_5  if sample==1 [aw=`obs'], absorb(fips state_year birthmo year) vce(cluster fips) 
		local cells = round(e(N), 1000)
		local counties = e(N_clust)
		outreg2 using "$output/fs_subindices_all", `r' noparen noaster noobs ///
					keep(shareFSP*) ctitle("`subindex'") ///
					addstat(Cells, `cells', Counties, `counties', mdv, `mdv', nobs,`nobs') ///
					addtext(Birth year,"Yes",Birth month,"Yes", Survey year,"Yes",  ///
					State x Birth Year,"No", County  trends,"Yes") ///
					dec(4) bdec(4) fmt(g) excel
		local r "append"
		
		* State-year model 
		reghdfe `subindex' shareFSPageIU_5 `trends'  if sample==1 [aw=`obs'], absorb(fips state_year birthmo year) vce(cluster fips) 
		local cells = round(e(N), 1000)
		local counties = e(N_clust)
		outreg2 using "$output/fs_subindices_all", `r' noparen noaster noobs ///
					keep(shareFSP*) ctitle("`subindex'") ///
					addstat(Cells, `cells', Counties, `counties', mdv, `mdv', nobs,`nobs') ///
					addtext(Birth year,"No",Birth month,"Yes", Survey year,"Yes",  ///
					State x Birth Year,"Yes", County trends,"Yes") ///
					dec(4) bdec(4) fmt(g) excel
		local r "append"
		restore 

	}

end 


/******************************************************************************
* makeBalanceTableData
* 
* Merges county observables to the main data to assess internal validity
*
*******************************************************************************/
capture program drop makeBalanceTableData
program define makeBalanceTableData
syntax, [shareFSPData(string) empData(string) reisData(string) wicData(string) transfersData(string) aerData(string) hsData(string) outputData(string) trendData(string)]
	
	use `shareFSPData', clear 
*	collapse (mean) shareFSPageIU_5 , by(st_fips co_fips_1 birthyr birthmo fs_year fs_month)
	gen fips = st_fips*1000+co_fips_1
	rename year surveyyear
	rename birthyr year 
	tempfile shareVar
	save `shareVar'
	
	use `empData', clear 
	rename county fips
	drop year
	rename birthyr year 
	collapse (mean) emp lemp, by(fips year) 
	tempfile emp
	save `emp'
	
	* county level data 
	use `reisData', clear 
	destring fips, replace
	drop if year > 1980 
	tempfile reis
	save `reis'
	
	*wic data 
	use `wicData', clear 
	gen fips = stfips*1000+countyfips
	* identify first year available 
	bys fips WIC: egen firstyr = min(year)
	gen startyr = 1 if WIC==1 & firstyr ==year		
	replace startyr = 0 if startyr==. 
	drop firstyr 
	gen fyr = year if startyr==1
	bys fips: egen firstyr = mean(fyr)
	drop fyr 
	replace WIC = 0 if year < firstyr
	replace WIC = 1 if year >=firstyr	
	tempfile wic
	drop if year > 1980
	duplicates drop fips year , force 
	save `wic'
	
	*transfers data 
	use `transfersData', clear
	gen fips = stfips*1000+countyfips
	tempfile transfers
	save `transfers'
	
	* hs, chc, medicare 
	use `aerData', clear
	keep fips year copop_* copop grant_* pcrfund_* imr_* amr imr nnmr pnmr 
	drop if year > 1980
	tempfile aer
	save `aer'
	
	* hs data 
	use `hsData', clear 
	keep fips year grant_hs fund_hs
	tempfile hs
	save `hs'
	
	* merge 1960 data 
	use `trendData', clear
	gen fips = stfips*1000+countyfips
	tempfile trend
	save `trend'
	
	* state var 
	use `trendData', clear 
	gen fips = stfips*1000+countyfips
	keep fips stfips
	tempfile state
	save `state'
	
	
	
	
	
	use `shareVar', clear
	merge m:1 fips year using `reis' , gen(merge_reis)
	merge m:1 fips year using `wic' , gen(merge_wic)
	merge m:1 fips year using `transfers' , gen(merge_transfers)
	merge m:1 fips year using `aer', gen(merge_aer)
	merge m:1 fips year using `hs' , gen(merge_hs)
	merge m:1 fips using `trend', gen(merge_trend)
	cap drop st_fips co_fips_1 stfips countyfips
	merge m:1 fips using `state'
	save `outputData', replace 	
	

end



/******************************************************************************
* balanceTable2
* Explores how the timing of food stamp program implementation is correlated with
* 1960 Census county observables. 
*
*******************************************************************************/
capture program drop balanceTable2
program define balanceTable2
syntax, [data(string)]
	use `data', clear
*	drop if year > 1980 | year<1960
*	drop if shareFSPageIU_5 ==.


	local countychars "pop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60"
	gen month = 12*(fs_year - 1961) + fs_month
	collapse (mean) `countychars' month, by(fips stfips )
	label var month "Calendar month food stamps implemented in county (January 1961 normalized to one)"
	drop if month==.
	drop if stfips==.
	*drop alaskan counties 
	drop if stfips==2
	*drop small counties
	*drop if pop60<1000

	gen lpop60 = ln(pop60)	
		local countychars "farmlandpct60 inc3k60 urban60 black60 age560 age6560 lpop60"


	*identify southern states 
	gen atlantic = inlist(stfips, 10, 12, 13, 24, 37, 45, 51, 54)
	gen east_central = inlist(stfips, 1,21,28, 47)
	gen west_central = inlist(stfips, 5, 22, 40, 48)
	gen south = 1 if atlantic==1| east_central==1 | west_central==1
	replace south = 0 if south ==.
	drop if farmlandpct60 >100
	label var farmlandpct60 "Percent of land in farming"
	label var inc3k60 "Percent of population with income < $3000"
	label var urban60 "Percent of population urban"
	label var black60 "Percent of population black"
	label var age560 "Percent of population age <5"
	label var age6560 "Percent of population age >65"
	label var lpop60 "Log Population"
	label var south "South" 
	
		* drop counties w/ missing obs
	egen miss = rowmiss(`countychars' month stfips south)
	keep if miss==0
	
	
	local south_interactions "c.(south)#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560 c.farmlandpct60)"
	
	foreach inter of local countychars{
		gen s_`inter' = south*`inter'
	}
	label var s_farmlandpct60 "South x Percent of land in farming"
	label var s_inc3k60 "South x Percent of population with income < $3000"
	label var s_urban60 "South x Percent of population urban"
	label var s_black60 "South x Percent of population black"
	label var s_age560 "South x Percent of population age <5"
	label var s_age6560 "South x Percent of population age >65"
	label var s_lpop60 "South x Log Population"
	label var south "South"
	
	* drop DC
	drop if fips ==11001
	
	reg month `countychars' [aweight=pop60], r 
	outreg2 using "$output/balanceTable2", replace noparen noaster label(proper) ///
				addtext(State fixed effects,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) excel  
	reghdfe month `countychars' [aweight=pop60], absorb(stfips) vce(robust)
	outreg2 using "$output/balanceTable2", append noparen noaster ///
				addtext(State fixed effects,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) excel label(proper)
	reghdfe month `countychars' `south_interactions' [aweight=pop60], absorb(stfips) vce(robust)
	outreg2 using "$output/balanceTable2", append noparen noaster ///
				addtext(State fixed effects,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) excel label(proper)

end 



/*******************************************************************************
* robustnessPop
* 
* To assess how much the correlation between fsp share and population affects 
* the baseline estimates, this subprogram produces tables including population
* as a control. The tradeoff is that population is available for less years of 
* coverage than the full set of baseline results. 
*
*******************************************************************************/
capture program drop robustnessPop
program define robustnessPop
syntax, [data(string) sample(int 100)]

	use if runiform() < `sample'/100 using `data', clear 
	
	*use `data' , clear 
	rename (year surveyyear) (birthyr year)
	
		keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
*	capture drop fips
*	gen fips = stfips*1000+cofips_1	
	sort fips birthyr
	egen state_year = group(stfips birthyr)
	
	gen lnpop = ln(copop)
	local controls "grant_hs grant_chc TpcRet TpcMedCARE1 TpcIncPA1 lnpop" 
	
	local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
	
	cap drop sample
	egen tmp = rowmiss(z_composite_all shareFSPageIU_5 birthyr birthmo year fips obs_all lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 `controls')
	gen sample = tmp==0
	
		
	* Capture number of underlying observations and round 			
	sum obs_all if sample==1
	local nobs = round(r(sum), 1000)
		
	* Mean of dependent variable, 1959-1963 cohorts
	sum z_composite_all [aw=obs_all] if inrange(birthyr,1959,1963) & sample==1	
	local mdv = round(r(mean), .0001)	

	* Estimate baseline model in years where lpop data is available 
	reghdfe z_composite_all shareFSPageIU_5 `trends' [aweight=obs_all]  if sample==1, absorb(fips birthyr birthmo year) vce(cluster fips)
	local cells = round(`e(N)', 1000)
	local R2 = round(`e(r2)', .001)
	local counties = e(N_clust) //e(K1)
	outreg2 using "$output/robustnessPop", replace noparen noaster noobs nor2 ///
		keep(shareFSPageIU_5) ctitle("Baseline 2 ") ///
		addstat(Cells, `cells', R squared, `R2', Counties, `counties', nobs,`nobs') ///
		addtext(State x birth year,"No", Birth year, "Yes", Birth month, "Yes", Survey year,"Yes", ///
		County Char Trends,"Yes", Controlling for population, "Yes", Other Controls, "No") ///
		dec(4)  afmt(g) fmt(g) excel

	reghdfe z_composite_all shareFSPageIU_5  `trends' [aweight=obs_all] if sample==1, absorb(fips state_year birthmo year) vce(cluster fips)
	local cells = round(`e(N)', 1000)
	local R2 = round(`e(r2)', .001)
	local counties = e(N_clust) //e(K1)
	outreg2 using "$output/robustnessPop", append noparen noaster noobs nor2 ///
		keep(shareFSPageIU_5) ctitle("Baseline 2  ") ///
		addstat(Cells, `cells', R squared, `R2', Counties, `counties', nobs,`nobs') ///
		addtext(State x birth year,"Yes", Birth year, "No", Birth month, "Yes", Survey year,"Yes", ///
		County Char Trends,"Yes", Controlling for population, "Yes", Other Controls, "No") ///
		dec(4)  afmt(g) fmt(g) excel


	* Estimate Baseline Models 2 and 4 controlling for log population
	* Model 2 
	reghdfe z_composite_all shareFSPageIU_5 lnpop `trends' [aweight=obs_all] if sample==1, absorb(fips birthyr birthmo year) vce(cluster fips)
	local cells = round(`e(N)', 1000)
	local R2 = round(`e(r2)', .001)
	local counties = e(N_clust) //e(K1)
	outreg2 using "$output/robustnessPop", append noparen noaster noobs nor2 ///
		keep(shareFSPageIU_5) ctitle("With pop - 2") ///
		addstat(Cells, `cells', R squared, `R2', Counties, `counties', nobs,`nobs') ///
		addtext(State x birth year,"No", Birth year, "Yes", Birth month, "Yes", Survey year,"Yes", ///
		County Char Trends,"Yes", Controlling for population, "Yes", Other Controls, "No") ///
		dec(4)  afmt(g) fmt(g) excel
	
	* Model 4
	reghdfe z_composite_all shareFSPageIU_5 lnpop `trends' [aweight=obs_all] if sample==1, absorb(fips state_year birthmo year) vce(cluster fips) 
	local cells = round(`e(N)', 1000)
	local R2 = round(`e(r2)', .001)
	local counties = e(N_clust) //e(K1)
	outreg2 using "$output/robustnessPop", append noparen noaster noobs nor2 ///
		keep(shareFSPageIU_5) ctitle("With Pop - 4") ///
		addstat(Cells, `cells', R squared, `R2', Counties, `counties', nobs,`nobs') ///
		addtext(State x birth year,"Yes", Birth year, "No", Birth month, "Yes", Survey year,"Yes", ///
		County Char Trends,"Yes", Controlling for population, "Yes", Other Controls, "No") ///
		dec(4)  afmt(g) fmt(g) excel
	
	** estimate model 2 and 4 controlling for population and other factors
	* Model 2 
	reghdfe z_composite_all shareFSPageIU_5 `controls' `trends' [aweight=obs_all] if sample==1, absorb(fips birthyr birthmo year) vce(cluster fips)
	local cells = round(`e(N)', 1000)
	local R2 = round(`e(r2)', .001)
	local counties = e(N_clust) //e(K1)
	outreg2 using "$output/robustnessPop", append noparen noaster noobs nor2 ///
		keep(shareFSPageIU_5) ctitle("Pop + Controls - 2") ///
		addstat(Cells, `cells', R squared, `R2', Counties, `counties', nobs,`nobs') ///
		addtext(State x birth year,"No", Birth year, "Yes", Birth month, "Yes", Survey year,"Yes", ///
		County Char Trends,"Yes", Controlling for population, "Yes", Other Controls, "Yes") ///
		dec(4)  afmt(g) fmt(g) excel
	
	* Model 4
	reghdfe z_composite_all shareFSPageIU_5 `controls' `trends' [aweight=obs_all] if sample==1, absorb(fips state_year birthmo year) vce(cluster fips) 
	local cells = round(`e(N)', 1000)
	local R2 = round(`e(r2)', .001)
	local counties = e(N_clust) //e(K1)
	outreg2 using "$output/robustnessPop", append noparen noaster noobs nor2 ///
		keep(shareFSPageIU_5) ctitle("Pop + Controls - 4") ///
		addstat(Cells, `cells', R squared, `R2', Counties, `counties', nobs,`nobs') ///
		addtext(State x birth year,"Yes", Birth year, "No",  Birth month, "Yes", Survey year,"Yes", ///
		County Char Trends,"Yes", Controlling for population, "Yes", Other Controls, "Yes") ///
		dec(4)  afmt(g) fmt(g) excel
		
	
end


/*******************************************************************************
*  balanceTable1share 
*  Tests for interntal validity. Models included in this subprogram regress
*  county time-varying observables on a variable measuring a birth cohorts share 
*  of food stamp availability from in utero to age 5 Different models vary in 
*  linear, quadratic and cubic trends. 
*******************************************************************************/ 
capture program drop balanceTable1share
program define balanceTable1share 
syntax, [data(string) sample(int 100) unrestricted(string) collapse(string)]

	use if runiform()< `sample'/100 using `data', clear 
	rename (year surveyyear) (birthyr year)
	keep if inrange(birthyr,1950,1980)
	egen state_year = group(stfips birthyr)
	* pick independent variables
	gen lpop = ln(copop)
	local vars "grant_hs grant_chc TpcRet TpcMedCARE1 TpcIncPA1 lpop" 
	* Convert units of subset of variables 
	foreach var of varlist  TpcRet TpcMedCARE1 TpcIncPA1{
		replace `var' = `var'/1000
	}
	local indvars "WIC `vars'"
	*gen lpop60 = ln(pop60)
	local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
	local trends2 "c.birthyr2#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
	local trends3 "c.birthyr3#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
	gen birthyr2 = birthyr^2
	gen birthyr3 = birthyr^3
	

	est clear 
	

	
	* More variables 
	if "`unrestricted'" == "Yes"{
		gen lnemp = ln(emp_total)
		gen lpop_ch = ln(copop_ch)
		gen lpop_ad = ln(copop_ad)
		gen lpop_eld = ln(copop_eld)
		loca morevars "lpop_ch lpop_ad lpop_eld inc_income_capita tr_transfers_capita lnemp amr imr nnmr pnmr" 
		local indvars "`indvars' `morevars'" 
		local ur "ur"
		
		foreach var of varlist inc_income_capita tr_transfers_capita {
			replace `var' = `var'/1000
		}
	}
	
	*** Collapse away survey year ***
	local c "Collapsed"
	collapse (mean) shareFSPageIU_5 `indvars'   *60 , by(fips birthyr birthyr2 birthyr3 state_year birthmo) 
	label var lpop_ch "Log Population, Age 1-19"
	label var lpop_ad "Log Population, Age 20-49"
	label var lpop_eld "Log Population, Age 50+"
	label var inc_income_capita "Real personal income per capita (1000s)"
	label var tr_transfers_capita "Real total transfers per capita (1000s)"
	label var lnemp "Log Employment"
	label var amr "Adult Mortality Rate"
	label var nnmr "Neonatal Mortality Rate"
	label var pnmr "Post-neonatal Mortality Rate"
	label var WIC "WIC"
	label var grant_hs "Head Start Program Indicator "
	label var grant_chc "Community Health Center Indicator"
	label var TpcRet "Retirement and disability insurance benefits per capita (1000s)"
	label var TpcMedCARE1 "Medicare + military medical insurance per capita (1000s)"
	label var TpcIncPA1 "Income maintenance minus food stamps per capita (1000s)"
	label var imr "Infant Mortality Rate"
	label var lpop "Log Population" 
	foreach var of local indvars{

		cap drop sample 
		cap drop tmp
		egen tmp = rowmiss(birthyr birthmo shareFSPageIU_5 fips pop60 state_year lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 `var')
		gen sample = tmp==0
		reghdfe `var' shareFSPageIU_5 `trends' if sample==1 [aweight=pop60], absorb(fips state_year birthmo ) vce(cluster fips) 
		local cells = round(e(N), 1000)
		sum birthyr if e(sample)==1 
		local minYear = r(min)
		local maxYear = r(max)
		sum `var' [aweight=pop60] if sample==1
		local mdv = round(r(mean), .001)
		
		if "`var'" == "WIC"{
			outreg2 using "$output/balanceTable1fspShare", replace noparen noobs noaster ///
				keep(shareFSPageIU_5) ///
				addstat(Cells, `cells', Year Min, `minYear', Year Max, `maxYear', mdv, `mdv') ///
				addtext(County FE,"Yes", Birth month, "Yes",  State X Birth year FE , "Yes", Linear Trends, "Yes", Quadratic Trends, "No", Cubic Trends, "No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) excel label 
		}
		else{
			outreg2 using "$output/balanceTable1fspShare", append noparen noaster noobs ///
				keep(shareFSPageIU_5) ///
				addstat(Cells, `cells', Year Min, `minYear', Year Max, `maxYear', mdv, `mdv') ///
				addtext(County FE,"Yes", Birth month, "Yes",  State X Birth year FE , "Yes", Linear Trends, "Yes", Quadratic Trends, "No", Cubic Trends, "No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) excel label 
		}
		reghdfe `var' shareFSPageIU_5 `trends' `trends2' if sample==1 [aweight=pop60], absorb( fips state_year birthmo ) vce(cluster fips)
		local cells = round(e(N), 1000)
		sum birthyr if e(sample)==1 
		local minYear = r(min)
		local maxYear = r(max)
		outreg2 using "$output/balanceTable1fspShare", append noparen noobs noaster ///
				keep(shareFSPageIU_5) ///
				addstat(Cells, `cells', Year Min, `minYear', Year Max, `maxYear', mdv, `mdv') ///
				addtext(County FE,"Yes", Birth month, "Yes",  State X Birth year FE , "Yes", Linear Trends, "Yes", Quadratic Trends, "Yes", Cubic Trends, "No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) excel label
				
				 
		reghdfe  `var' shareFSPageIU_5 `trends' `trends2' `trends3' if sample==1  [aweight=pop60], absorb(fips state_year birthmo) vce(cluster fips)
		local cells = round(e(N), 1000)
		sum birthyr if e(sample)==1 
		local minYear = r(min)
		local maxYear = r(max)
		outreg2 using "$output/balanceTable1fspShare", append noparen noobs noaster ///
				keep(shareFSPageIU_5) ///
				addstat(Cells, `cells', Year Min, `minYear', Year Max, `maxYear', mdv, `mdv') ///
				addtext(County FE,"Yes", Birth month, "Yes",  State X Birth year FE , "Yes", Linear Trends, "Yes", Quadratic Trends, "Yes", Cubic Trends, "Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) excel  label 
}

	

end



main

log close 
