clear all
set tracedepth 2 
*set matsize 11000



	
capture program drop main 
program define main 
	paths
	cap log close 
	log using "$output/test_subgroups.log", replace

	*** Exposure, Event study, and spline models ***
	* Exposure model data 
	local data1 "$datatemp/fs_hsacr_1_newsub_exactmatch0.dta"
	local stayerData1 "$datatemp/fs_hsacr_1_newsub_exactmatch0_withStayers.dta" 
	* Eventstudy and spline data 
	local data2 "$datatemp/fs_dtacr_2_exactmatch0_newsub.dta"		
	local stayerData2 "$datatemp/fs_dtacr_2_exactmatch0_newsub_withStayers.dta"
	* Sample sets what percent of the data to use
	local sample = 100
	
	/*
	* tables for index outcomes
	foreach o in /*z_composite*/ z_ess z_hc z_dis z_nei{
		outputTables, dataExposure(`data1') dataEvent(`data2') sample(`sample') indexType("`o'")
	}
	
	* tables for special indices
	foreach o in ess_7 dis_9{
		outputTablesSpecial, dataExposure(`data1') dataEvent(`data2') sample(`sample') indexType("`o'")
	}
	
	
	* tables for subindices in Appendix Table 2
	foreach o in hc ess nei{
		subindexOutputTable, indexType(`o') data(`data1') sample(`sample')
	}
	*/
	
	* tables for just Life Expectancy Measures 
	local shareVar "shareFSPage0_5"
	local shareVar2 ""
	foreach o in LE3  {
		outputTablesLE, dataExposure(`stayerData1') dataEvent(`stayerData2') sample(`sample') indexType("`o'") shareVar("`shareVar'") 
	}

	

end 



capture program drop paths
program define paths

	global datatemp"/projects/programs/foodstamps/master_folder/datatemp"
	global output "/projects/programs/foodstamps/master_folder/RESTUD_2021/output/test_subgroups"
	global data "/projects/data"		// project-wide data 
	global countydata "/projects/data/countyLevel"
	global empData "/projects/programs/rwalker/chris/dataSTATA"

end 

/******************************************************************************
* outputTables
*
* Produces tables for food stamp exposure, spline and event-study models. 
* 
*
*******************************************************************************/ 

capture program drop outputTables
program define outputTables
syntax, [dataExposure(string) dataEvent(string)  sample(int 100) indexType(string) ]

	* First do exposure model specifications and then add event-study and spline due to different datasets 
	use if runiform() <= `sample'/100 using `dataExposure', clear

	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen state_year = group(st_fips birthyr)
	
	
	* Drop the subindices for reshaping purposes
	if "`indexType'"!="z_composite"{
		drop `indexType'_*_*
	}
	
	*** Set weight to choose for weight variable
		if "`indexType'"=="z_dis"{
			local obs_ "obs_dis_"
		} 
		else{
			local obs_ "obs_"
			drop obs_dis* obs_inc*
		} 
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'"=="dis_8" local obs_ "num_deaths_"
			else local obs_ "num_births_"
		}
	
	
	
	*list fips birthmo birthyr year `indexType'* `obs_'* shareFSPageIU_5 urban60 in 1/5
	
	reshape long `indexType'_ `obs_', i(fips birthmo birthyr year) j(subgroup) string
	
	*list fips birthmo birthyr year `indexType'_ `obs_' subgroup shareFSPageIU_5 urban60 in 1/25
	
	* Create indicators
	gen wm = subgroup == "wm"
	gen wf = subgroup == "wf"
	gen nm = subgroup == "nm"
	gen nf = subgroup == "nf"
	drop if subgroup == "all"
		
		* Table names 
		if "`indexType'" == "z_composite" local title "Composite Index"
		if "`indexType'" == "z_ess" local title "Economic Self Sufficiency Index"
		if "`indexType'" == "z_hc"  local title  "Human Capital Index" 
		if "`indexType'" == "z_dis" local title "Disability Index" 
		if "`indexType'" == "z_nei" local title "Living Quality Index"	
		if "`indexType'" == "dis_7" local title "Share That Lived to 2000"
		if "`indexType'" == "dis_8" local title "Age at Death"
		if "`indexType'" == "dis_9" local title "Share That Lived to 2012"	
		
		* Identify sample for exposure models 
		cap drop sample
		egen tmp = rowmiss(`indexType'_ shareFSPageIU_5 birthyr birthmo year fips `obs_' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 )
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs_', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs_' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_ [aw=`obs_'] if inrange(birthyr,1950,1954) & sample==1
		local mdv = round(r(mean), .0001)
		
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 

		* Run exposure model 3
		local r "replace"  
		
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		
		local wf_trends "wf#(c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560))"
		local nm_trends "nm#(c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560))"
		local nf_trends "nf#(c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560))"
		
		
		di "Run regression"
		
		* Model 3
		eststo clear
		reghdfe `indexType'_ shareFSPageIU_5 wf nm nf ///
		wf#c.shareFSPageIU_5  nm#c.shareFSPageIU_5 nf#c.shareFSPageIU_5 ///
		`trends' `wf_trends' `nm_trends' `nf_trends' ///
		if sample==1 [aw=`obs_'] , ///
		absorb(fips wf#fips nm#fips nf#fips ///
		state_year wf#state_year nm#state_year nf#state_year ///
		birthmo wf#birthmo nm#birthmo nf#birthmo ///
		year wf#year nm#year nf#year) vce(cluster fips)	
		
		eststo `indexType'
		
		estout using "$output/test_`indexType'_subgroups.xls", replace ///
		keep (shareFSPageIU_5 1.wf#c.shareFSPageIU_5 ///
		1.nm#c.shareFSPageIU_5 1.nf#c.shareFSPageIU_5) ///
		cells("b se p") stats(N)
	
	
end 


/******************************************************************************
* outputTablesSpecial 
*
* Similar to previous subprogram but specific to a specific set of indices. 
*
*******************************************************************************/
capture program drop outputTablesSpecial 
program define outputTablesSpecial
syntax, [dataExposure(string) dataEvent(string)  sample(int 100) indexType(string) ]


	* First do exposure model specifications and then add event-study and spline due to different datasets 
	use if runiform() <= `sample'/100 using `dataExposure', clear

	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen inNumidentSamp=tag(fips birthyr) //special
	replace inNumidentSamp=. if fips==. | !inrange(birthyr,1950,1980) //special
	egen state_year = group(st_fips birthyr)
	
	* Some modifications to certain indices //special
	if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
		* These observations are at the county/birth-month level. No survey-year variation.
		* So get rid of the extra survey years of data
		egen tag = tag(fips birthyr birthmo exactmatch)
		tab birthyr tag, m
		tab year tag, m
		keep if tag==1 & exactmatch==0
		drop tag
	} 
	
	*** Set weight to choose for weight variable
		if "`indexType'"=="z_dis"{
			local obs_ "obs_dis_"
		} 
		else{
			local obs_ "obs_"
			drop obs_dis*
		} 
		
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'"=="dis_8" local obs_ "num_deaths_"
			else local obs_ "num_births_"
		}
		
		if "`indexType'"=="ess_7"{
			local obs_ "obs_inc_"
		} 
		else{
			drop obs_inc*	
		}
	
	
	*list fips birthmo birthyr year `indexType'* `obs_'* shareFSPageIU_5 urban60 in 1/5
	
	reshape long `indexType'_ `obs_', i(fips birthmo birthyr year) j(subgroup) string
	
	*list fips birthmo birthyr year `indexType'_ `obs_' subgroup shareFSPageIU_5 urban60 in 1/25
	
	* Create indicators
	gen wm = subgroup == "wm"
	gen wf = subgroup == "wf"
	gen nm = subgroup == "nm"
	gen nf = subgroup == "nf"
	drop if subgroup == "all"
		
		* Table names 
		if "`indexType'" == "z_composite" local title "Composite Index"
		if "`indexType'" == "z_ess" local title "Economic Self Sufficiency Index"
		if "`indexType'" == "z_hc"  local title  "Human Capital Index" 
		if "`indexType'" == "z_dis" local title "Disability Index" 
		if "`indexType'" == "z_nei" local title "Living Quality Index"	
		if "`indexType'" == "dis_7" local title "Share That Lived to 2000"
		if "`indexType'" == "dis_8" local title "Age at Death"
		if "`indexType'" == "dis_9" local title "Share That Lived to 2012"	
		if "`indexType'" == "ess_7" local title "Share Not Incarcerated"
		
		* Identify sample for exposure models 
		*preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_ shareFSPageIU_5 birthyr year fips `obs_' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 ) //special does not include birthmo
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs_', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
	
		if "`indexType'" == "ess_7" {
		  * Capture number of underlying observations	// special			
		  sum `obs_' if sample==1
		  local nobs = r(sum)
		  sum `indexType'_ [aw=`obs_'] if inrange(birthyr,1950,1954) 	
		  local mdv = r(mean)
		}
		
		* report following additional statistics for these indices 
	*	if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {					
			* Calculate mean for 1950-54
			sum `indexType'_ if inrange(birthyr,1950,1954) & sample==1
			local mdv5054 = r(mean)
			local sd5054 = r(sd)
		
			* Calculate mean for 1950-80
			sum `indexType'_ [aw=`obs_'] if sample==1
			local mdv = r(mean)
			local sd = r(sd)
			local nobs = r(sum_w)
	*	}
		
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 

		* Run exposure model 3
		local r "replace"  
		
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		
		local wf_trends "wf#(c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560))"
		local nm_trends "nm#(c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560))"
		local nf_trends "nf#(c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560))"
		
		
		di "Run regression"
		
		* Model 3
		eststo clear
		reghdfe `indexType'_ shareFSPageIU_5 wf nm nf ///
		wf#c.shareFSPageIU_5  nm#c.shareFSPageIU_5 nf#c.shareFSPageIU_5 ///
		`trends' `wf_trends' `nm_trends' `nf_trends' ///
		if sample==1 [aw=`obs_'] , ///
		absorb(fips wf#fips nm#fips nf#fips ///
		state_year wf#state_year nm#state_year nf#state_year ///
		birthmo wf#birthmo nm#birthmo nf#birthmo ///
		year wf#year nm#year nf#year) vce(cluster fips)
		
		eststo `indexType'
		
		estout using "$output/test_`indexType'_subgroups.xls", replace ///
		keep (shareFSPageIU_5 1.wf#c.shareFSPageIU_5 ///
		1.nm#c.shareFSPageIU_5 1.nf#c.shareFSPageIU_5) ///
		cells("b se p") stats(N)
		
	
end


/******************************************************************************
* outputTablesLE
*
* Produces tables for food stamp exposure, spline and event-study models.
* Specific to Life Expectancy estimates 
* 
*
*******************************************************************************/ 

capture program drop outputTablesLE
program define outputTablesLE
syntax, [dataExposure(string) dataEvent(string)  sample(int 100) indexType(string) shareVar(string) shareVar2(string)]

	* First do exposure model specifications and then add event-study and spline due to different datasets 
	use if runiform() <= `sample'/100 using `dataEvent', clear

	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen state_year = group(st_fips birthyr)
	
	/*
	* Drop the subindices for reshaping purposes
	if "`indexType'"!="z_composite"{
		drop `indexType'_*_*
	}
	*/
	
	*** Set weight to choose for weight variable
		*** LE weights using cohort size
		if "`indexType'"=="LE1" local obs_ "obs_LE1_"
		else{
			drop obs_LE1*
		}
		if "`indexType'"=="LE2" local obs_ "obs_LE2_"
		else{
			drop obs_LE2*
		}
		if "`indexType'"=="LE3" local obs_ "obs_LE3_"
		else{
			drop obs_LE3*
		}
		if "`indexType'"=="LE4" local obs_ "obs_LE4_"
		else{
			drop obs_LE4*
		}
		if "`indexType'"=="LE4"{
			drop if LE4_all>100
			}	
		if "`indexType'"=="LE_chetty" local obs "obs_dis_"
		else{
			drop obs_dis*
		}
		
		drop obs_all obs_?? obs_inc*
	
	list fips birthyr year `indexType'* `obs_'* `shareVar' urban60 in 1/5
	
	reshape long `indexType'_ `obs_', i(fips birthyr year stayer) j(subgroup) string
	
	list fips birthyr year `indexType'_ `obs_' subgroup `shareVar' urban60 in 1/25
	
	* Create indicators
	gen wm = subgroup == "wm"
	gen wf = subgroup == "wf"
	gen nm = subgroup == "nm"
	gen nf = subgroup == "nf"
	drop if subgroup == "all"
		
		*** Table names 
		if "`indexType'" == "z_composite" local title "Composite Index"
		if "`indexType'" == "z_ess" local title "Economic Self Sufficiency Index"
		if "`indexType'" == "z_hc"  local title  "Human Capital Index" 
		if "`indexType'" == "z_dis" local title "Disability Index" 
		if "`indexType'" == "z_nei" local title "Living Quality Index"	
		if "`indexType'" == "dis_7" local title "Share That Lived to 2000"
		if "`indexType'" == "dis_8" local title "Age at Death"
		if "`indexType'" == "dis_9" local title "Share That Lived to 2012"	
		if "`indexType'" == "LE" local title "Life Expectancy"
		if "`indexType'" == "LE_chetty" local title "Chetty Life Expectancy"	

		* Identify sample for exposure models 
		*preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_ `shareVar' `shareVar2' birthyr year fips `obs_' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 ) // add birthmonth?
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs_', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs_' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_ [aw=`obs_'] if inrange(birthyr,1950,1954) & sample==1 
		local mdv = round(r(mean), .0001)
		
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 
		
		* Run exposure model 3
		local r "replace"  
		
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		
		local wf_trends "wf#(c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560))"
		local nm_trends "nm#(c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560))"
		local nf_trends "nf#(c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560))"
		
		
		di "Run regression"
		
		* Model 3
		eststo clear
		reghdfe `indexType'_ `shareVar' wf nm nf ///
		wf#c.`shareVar'  nm#c.`shareVar' nf#c.`shareVar' ///
		`trends' `wf_trends' `nm_trends' `nf_trends' ///
		if sample==1 [aw=`obs_'] , ///
		absorb(fips wf#fips nm#fips nf#fips ///
		state_year wf#state_year nm#state_year nf#state_year ///
		year wf#year nm#year nf#year) vce(cluster fips)
	
		eststo `indexType'
		
		estout using "$output/test_`indexType'_subgroups.xls", replace ///
		keep (`shareVar' 1.wf#c.`shareVar' ///
		1.nm#c.`shareVar' 1.nf#c.`shareVar') ///
		cells("b se p") stats(N)
	
end 

/******************************************************************************
* subindexOutputTable
*
* FSP exposure models where the outcome variables are subindices that compose the 
* indices explored in other tables. 
*
*******************************************************************************/
capture program drop subindexOutputTable
program define subindexOutputTable
syntax, [indexType(string) data(string) sample(int 100)]
	
	use if runiform() <=`sample'/100 using `data', clear 
	
	keep if inrange(birthyr,1950,1980)

	drop if birthmo==.  // Shouldn't do anything

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1

	egen state_year = group(st_fips birthyr)
	
	if "`indexType'" == "hc"{
		local subindex_list hc_1 hc_2 hc_3 hc_4 hc_5 hc_6
	}
	
	if "`indexType'" == "ess"{
		local subindex_list ess_1 ess_2 ess_3 ess_4 ess_5 ess_6 ess_8 ess_9 ess_10 ess_5_1 ess_8_1
	}
	
	if "`indexType'" == "nei"{
		local subindex_list nei_1 nei_2 nei_3 nei_4 nei_5 nei_6 nei_7 nei_8 nei_9 nei_10 nei_11 nei_12 nei_5_1
	}
	
	local r replace
	eststo clear
	foreach subindex of local subindex_list{
	preserve
	
	* Drop some subindices for reshaping purposes
	if "`subindex'" == "nei_1" | "`subindex'" == "nei_5" ///
	| "`subindex'" == "ess_5" | "`subindex'" == "ess_6" ///
	| "`subindex'" == "ess_8" | "`subindex'" == "ess_10"{
		drop `subindex'_1_*
	}
	
	*** Set weight to choose for weight variable
	if substr("`subindex'",3,3)=="dis" local obs_ "obs_dis_"
	else{
			local obs_ "obs_"
			drop obs_dis* obs_inc*
		} 
		
	
			
	reshape long `subindex'_ `obs_', i(fips birthmo birthyr year) j(subgroup) string
		
	* Create indicators
	gen wm = subgroup == "wm"
	gen wf = subgroup == "wf"
	gen nm = subgroup == "nm"
	gen nf = subgroup == "nf"
	drop if subgroup == "all"
		
	* Identify sample
	cap drop sample
	egen tmp = rowmiss(`subindex'_ shareFSPageIU_5 birthyr birthmo year fips `obs_' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60)
	gen sample = tmp==0
	tab sample tmp, m			// Total county/birth year/survey year cells
	tabstat `obs_', by(sample) stats(sum)	// Total underlying individual observations
	drop tmp
			
	* Capture number of underlying observations				
	sum `subindex'_ [aw=`obs_'] if inrange(birthyr,1950,1980) & sample==1	
	local mdv = round(r(mean), .0001)
	local nobs = round(r(sum_w), 1000)
				
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 
		
		* Run exposure model 3
		
	local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		
	local wf_trends "wf#(c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560))"
	local nm_trends "nm#(c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560))"
	local nf_trends "nf#(c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560))"
		
		
	di "Run regression"
		
	* Model 3
	
	reghdfe `subindex'_ shareFSPageIU_5 wf nm nf ///
	wf#c.shareFSPageIU_5  nm#c.shareFSPageIU_5 nf#c.shareFSPageIU_5 ///
	`trends' `wf_trends' `nm_trends' `nf_trends' ///
	if sample==1 [aw=`obs_'] , ///
	absorb(fips wf#fips nm#fips nf#fips ///
	state_year wf#state_year nm#state_year nf#state_year ///
	birthmo wf#birthmo nm#birthmo nf#birthmo ///
	year wf#year nm#year nf#year) vce(cluster fips)	
		
	eststo `subindex'
	
	restore
	
	}
	
	estout using "$output/test_`indexType'_subindices_subgroups_new.xls", `r' ///
	keep (shareFSPageIU_5 1.wf#c.shareFSPageIU_5 ///
	1.nm#c.shareFSPageIU_5 1.nf#c.shareFSPageIU_5) ///
	cells("b se p") stats(N)

end 




main

log close 
