clear all
set tracedepth 2 
*set matsize 11000
 
* Set ado directory to use rwolf2
sysdir set PERSONAL "/projects/programs/foodstamps/foodstamps/RESTUD_Revision_March2021/ado"


	
capture program drop main 
program define main 
	paths
	cap log close 
	log using "$output/test_rwolf2_z_hc.log", replace

	*** Exposure, Event study, and spline models ***
	* Exposure model data 
	local data1 "$datatemp/fs_hsacr_1_newsub_exactmatch0.dta"
	local stayerData1 "$datatemp/fs_hsacr_1_newsub_exactmatch0_withStayers.dta" // these are made by Matt and include the LE estimates
	* Eventstudy and spline data 
	local data2 "$datatemp/fs_dtacr_2_exactmatch0_newsub.dta"		
	local stayerData2 "$datatemp/fs_dtacr_2_exactmatch0_newsub_withStayers.dta"
	* Sample sets what percent of the data to use
	local sample = 100
	
	* tables for subindices in Appendix Table 2
	foreach o in z_hc{
		rwolfSubindex, indexType(`o') data(`data1') sample(`sample')
	}

	

end 



capture program drop paths
program define paths

	global datatemp"/projects/programs/foodstamps/foodstamps/RESTUD_Revision_March2021/datatemp"
	global output "/projects/programs/foodstamps/foodstamps/RESTUD_Revision_March2021/output/rwolf"
	global data "/projects/data"		// project-wide data 
	global countydata "/projects/data/countyLevel"
	global empData "/projects/programs/rwalker/chris/dataSTATA"

end 


/******************************************************************************
* rwolfSubindex
*
* FSP exposure models where the outcome variables are subindices that compose the 
* indices explored in other tables. 
*
*******************************************************************************/
capture program drop rwolfSubindex
program define rwolfSubindex
syntax, [indexType(string) data(string) sample(int 100)]
	
	use if runiform() <= `sample'/100 using `data', clear 
	
	keep if inrange(birthyr,1950,1980)

	drop if birthmo==.  // Shouldn't do anything

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1

	egen state_year = group(st_fips birthyr)	
	
	foreach g in all{
		
		local r "replace"
		preserve
		
		if "`indexType'" == "z_hc"{
			local subindex_list z_hc_1_`g' z_hc_2_`g' z_hc_3_`g' z_hc_4_`g' z_hc_5_`g' z_hc_6_`g'
		}
		
		*** Set weight to choose for weight variable
		if "`indexType'"=="dis" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		
		
		* Identify sample
		cap drop sample
		egen tmp = rowmiss(/*`subindex'_`g'*/ shareFSPageIU_5 birthyr birthmo year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60)
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		/*		
		* Capture number of underlying observations				
		sum `subindex'_`g' [aw=`obs'] if inrange(birthyr,1950,1980) & sample==1	
		local mdv = round(r(mean), .0001)
		local nobs = round(r(sum_w), 1000)
		*/
					
			*Order of models 
			* 0. birthyr year (w/o trends) 
			* 1. state_year year (w/o trends) * in subgroup  
			* 2. year birthyr (w trends) 
			* 3. state_year year (w trends) * in subgroup 
			
			* Run exposure model 3
			
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		
		* State-year model 
		di "Attempt rwolf2"
		#delimit ;
		rwolf2 (reghdfe z_hc_1_`g' shareFSPageIU_5 `trends' if sample==1 [aw=`obs'],
		absorb(fips state_year birthmo year) vce(cluster fips)) 
		
		(reghdfe z_hc_2_`g' shareFSPageIU_5 `trends' if sample==1 [aw=`obs'], 
		absorb(fips state_year birthmo year) vce(cluster fips))
		
		(reghdfe z_hc_3_`g' shareFSPageIU_5 `trends' if sample==1 [aw=`obs'],
		absorb(fips state_year birthmo year) vce(cluster fips)) 
		
		(reghdfe z_hc_4_`g' shareFSPageIU_5 `trends' if sample==1 [aw=`obs'], 
		absorb(fips state_year birthmo year) vce(cluster fips)) 
		
		(reghdfe z_hc_5_`g' shareFSPageIU_5 `trends' if sample==1 [aw=`obs'], 
		absorb(fips state_year birthmo year) vce(cluster fips)) 
		
		(reghdfe z_hc_6_`g' shareFSPageIU_5 `trends' if sample==1 [aw=`obs'],
		absorb(fips state_year birthmo year) vce(cluster fips)),
		
		indepvars(shareFSPageIU_5, shareFSPageIU_5, shareFSPageIU_5, 
		shareFSPageIU_5, shareFSPageIU_5, shareFSPageIU_5)
		cluster(fips) verbose seed(66245);
		#delimit cr
		
		matrix M = e(RW)'
		matrix rownames M = "model p" "resample p" "Romano-Wolf p"
		matrix colnames M = `subindex_list'
		matrix p_RW = M[3, 1..6]
		matrix list p_RW
		
		estout matrix(p_RW, fmt(4)) using "$output/rwolf_`indexType'_`g'_subindices.xls", replace
		
		restore

	
	}

end 




main

log close 
