* Exposure model with new outcomes: higher percent urban and higher number of colleges per capita in adult county than birth county
* 6/15/2021 

clear all 
set more off 
set trace on
set tracedepth 2 
*set matsize 11000
	
capture program drop main 
program define main 
	paths
	cap log close 
	log using "$output/dd_pct_urb_RESTUD.log", replace

	*** Exposure, Event study, and spline models ***
	* Exposure model data 
	local data1 "$datatemp/fs_hsacr_1_newsub_exactmatch0_withCollege.dta"
	* Eventstudy and spline data 
	local data2 "$datatemp/fs_dtacr_2_exactmatch0_newsub.dta"
	* Sample sets what percent of the data to use
	local sample = 100
	

	* tables for index outcomes
	foreach o in higher_pct_urb higher_num_4yr higher_num_4yr_per_cap{
		outputTablesNew, dataExposure(`data1') dataEvent(`data2') sample(`sample') indexType("`o'")
	}

	

end 

capture program drop paths
program define paths

	global datatemp"/projects/programs/foodstamps/master_folder/datatemp"
	global output "/projects/programs/foodstamps/master_folder/RESTUD_2021/output/urban_and_colleges"

end 

/******************************************************************************
* outputTables
*
* Produces tables for food stamp exposure, spline and event-study models. 
* 
*
*******************************************************************************/ 

capture program drop outputTablesNew
program define outputTablesNew
syntax, [dataExposure(string) dataEvent(string)  sample(int 100) indexType(string) ]


	* First do exposure model specifications and then add event-study and spline due to different datasets 
	use if runiform() <= `sample'/100 using `dataExposure', clear

	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen state_year = group(st_fips birthyr)
	

	foreach g in all wm wf nm nf {
		
		* Table names 
		if "`indexType'" == "higher_pct_urb" local title "Higher Percent Urban in Adult County , `g'"
		if "`indexType'" == "higher_num_4yr" local title "Higher Number of 4 Year Colleges in Adult County, `g'"
		if "`indexType'" == "higher_num_4yr_per_cap" local title "Higher Number of 4 Year Colleges Per Capita in Adult County, `g'"
	
		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		
		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"



		
		* Identify sample for exposure models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' shareFSPageIU_5 birthyr birthmo year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 )
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv = round(r(mean), .0001)
		
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 

		* Run exposure models
		* Models 0 and 2 not estimated for subgroups
		* Model 0
		local r "replace"  
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		if "`g'" == "all"{
			reghdfe `outcome' shareFSPageIU_5  if sample==1 [aw=`obs'], absorb(fips birthyr birthmo year) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = round(e(N_clust),100)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(shareFSPageIU_5) ctitle("Model 0") ///
				adds(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv', nobs, `nobs') ///
				addtext(Birth year,"Yes", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				title("`title'") dec(4) bdec(4) sdec(4) fmt(g) dta
			local r "append"
		}
				
		* Model 1
		reghdfe `outcome' shareFSPageIU_5  if sample==1 [aw=`obs'] , absorb(fips state_year birthmo year) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
			local counties = round(e(N_clust),100)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(shareFSP*) ctitle("Model 1" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"No") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		local r "append"
		if "`g'" == "all"{
			* Model 2
			reghdfe `outcome' shareFSPageIU_5 `trends'  if sample==1 [aw=`obs'] , absorb(fips birthyr birthmo year) vce(cluster fips) 
 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = round(e(N_clust),100)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(shareFSP*) ctitle("Model 2" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
				
			local r "append" 
		}
		* Model 3 (preferred model)
		reghdfe `outcome' shareFSPageIU_5 `trends'  if sample==1 [aw=`obs'] , absorb(fips state_year birthmo year) vce(cluster fips) 
		local cells = round(`e(N)', 1000) 
		local R2 = round(`e(r2)', .0001)
		local counties = round(e(N_clust),100)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(shareFSP*) ctitle("Model 3" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta		
		restore 
	
	}

	
	
	* Make table 	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 
	foreach g in all wm wf nm nf {
		use $output/table_`indexType'_`g'_dta, clear 
		export excel using $output/`indexType', sheet("`g'", replace )  
	}
	
end 

main

log close
