* Run models accounting for age
* Try age range 35-45
* Individually age 30, 31, ..., 35
* Adding in age controls

clear all 
set more off 
set trace on
set tracedepth 2 
*set matsize 11000
set scheme s1color


	
capture program drop main 
program define main 
	paths

	*** Exposure, Event study, and spline models ***
	* Exposure model data 
	local data1 "$datatemp/fs_hsacr_1_newsub_exactmatch0.dta"
	* Eventstudy and spline data 
	local data2 "$datatemp/fs_dtacr_2_exactmatch0_newsub.dta"
	local sample = 100
	
	* Run outcomes measured at specific ages
	cap log close 
	log using "$output/generate_age_range_outcomes.log", replace
	
	outputTablesAgeRange, dataExposure(`data1') dataEvent(`data2') ///
	sample(`sample') indexType(z_composite)
	
	forvalues i = 30/35{
		outputTablesAgeSpecific, dataExposure(`data1') dataEvent(`data2') sample(`sample') indexType(z_composite) ageTime(`i')
	}

	* Run exposure model with age controls
	outputTablesAgeControls, dataExposure(`data1') sample(`sample') indexType(z_composite)
	
	log close
	

end 

capture program drop paths
program define paths

	global datatemp"/projects/programs/foodstamps/master_folder/datatemp"
	global output "/projects/programs/foodstamps/master_folder/RESTUD_2021/output/age_range_outcomes"
	global data "/projects/data"		// project-wide data 
	global countydata "/projects/data/countyLevel"
	global empData "/projects/programs/rwalker/chris/dataSTATA"

end 

capture program drop outputTablesAgeRange
program outputTablesAgeRange
syntax, [dataExposure(string) dataEvent(string) sample(int 100) indexType(string)]

	use "`dataExposure'" if runiform() <= `sample'/100, clear
	keep if inrange(birthyr,1950,1980)

	* Run exposure model
	
	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen state_year = group(st_fips birthyr)
	
	* For each cohort, identify data available between 35-45
	gen age_at_survey = year - birthyr

	foreach g in all /*wm wf nm nf*/ {
		
		* Calculate the mean from available data
		cap drop use_outcome
		gen use_outcome = !missing(`indexType'_`g') & inrange(age_at_survey, 35, 45)
		tab birthyr if use_outcome == 1
		bysort fips birthyr birthmo: egen mean_`indexType'_`g'_35_45 = mean(`indexType'_`g') if use_outcome == 1
		
		*Find total observations for each county x birthyr x birthmo cell
		*sum the underlying observations
		bysort fips birthyr birthmo: egen tot_obs_`g' = total(obs_`g') if use_outcome == 1
		*br fips birthyr birthmo year age_at_survey use_outcome z_composite_all mean_z_composite_all_35_45 tot_obs_all obs_all
		
		keep if use_outcome == 1
		keep st_fips co_fips_1 fips state_year birthyr birthmo ///
		mean_`indexType'_`g'_35_45 shareFSPageIU_5 lpop60 inc3k60 ///
		urban60 black60 age560 age6560 farmlandpct60 tot_obs*
		
		* Collapse data to county x birthyr x birthmo level
		duplicates drop
		
		* Table names 
		if "`indexType'" == "z_composite" local title "Composite Index, `g'"
		if "`indexType'" == "z_ess" local title "Economic Self Sufficiency Index, `g'"
		if "`indexType'" == "z_hc"  local title  "Human Capital Index, `g'" 
		if "`indexType'" == "z_dis" local title "Disability Index, `g'" 
		if "`indexType'" == "z_nei" local title "Living Quality Index"	
		if "`indexType'" == "dis_7" local title "Share That Lived to 2000, `g'"
		if "`indexType'" == "dis_8" local title "Age at Death, `g'"
		if "`indexType'" == "dis_9" local title "Share That Lived to 2012, `g'"	
		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "tot_obs_dis_`g'"
		else local obs "tot_obs_`g'"
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		
		* outcome of interest for subgroup g 
		local outcome "mean_`indexType'_`g'_35_45"

		* Identify sample for exposure models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(mean_`indexType'_`g'_35_45 shareFSPageIU_5 birthyr birthmo fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 )
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		di `nobs'
		
		* Mean of dependent variable,  1950-54 cohorts
		* We only have cohorts 1955+ so just do overall mean for now
		sum mean_`indexType'_`g'_35_45 [aw=`obs'] if sample==1
		local mdv = round(r(mean), .0001)
		
		* Run exposure model
		* Model 3 (preferred model) without survey year FE
		local r "replace"
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		reghdfe `outcome' shareFSPageIU_5 `trends' if sample==1 [aw=`obs'], absorb(fips state_year birthmo) vce(cluster fips) 
		local cells = round(`e(N)', 1000) 
		local R2 = round(`e(r2)', .0001)
		local counties = round(e(N_clust), 100)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(shareFSP*) ctitle("Exposure" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv',nobs,`nobs') ///
				addtext(Birth month, "Yes", Survey year,"No", ///
				State x Birth Year,"Yes", County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta	
		restore 
	
	}
	
	* Make table 	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 
	foreach g in all /*wm wf nm nf*/ {
		use $output/table_mean_`indexType'_`g'_35_45_dta, clear 
		export excel using $output/`indexType'_35_45, sheet("`g'", replace )  
	}
	
end

capture program drop outputTablesAgeSpecific
program outputTablesAgeSpecific
syntax, [dataExposure(string) dataEvent(string) sample(int 100) indexType(string) ageTime(int 100)]

	use "`dataExposure'" if runiform() <= `sample'/100, clear
	keep if inrange(birthyr,1950,1980)

	* Run exposure model
	
	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen state_year = group(st_fips birthyr)
	
	* For each cohort, identify data available between 35-45
	gen age_at_survey = year - birthyr

	foreach g in all /*wm wf nm nf*/ {
		
		* Calculate the mean from available data
		cap drop use_outcome
		gen use_outcome = !missing(`indexType'_`g') & age_at_survey==`ageTime'
		tab birthyr if use_outcome == 1
		bysort fips birthyr birthmo: egen mean_`indexType'_`g'_`ageTime' = mean(`indexType'_`g') if use_outcome == 1
		
		*Find total observations for each county x birthyr x birthmo cell
		*sum the underlying observations
		bysort fips birthyr birthmo: egen tot_obs_`g' = total(obs_`g') if use_outcome == 1
		*br fips birthyr birthmo year age_at_survey use_outcome z_composite_all mean_z_composite_all_35_45 tot_obs_all obs_all
		
		keep if use_outcome == 1
		keep st_fips co_fips_1 fips state_year birthyr birthmo ///
		mean_`indexType'_`g'_`ageTime' shareFSPageIU_5 lpop60 inc3k60 ///
		urban60 black60 age560 age6560 farmlandpct60 tot_obs*
		
		* Collapse data to county x birthyr x birthmo level
		duplicates drop
		
		* Table names 
		if "`indexType'" == "z_composite" local title "Composite Index at `ageTime', `g'"
		if "`indexType'" == "z_ess" local title "Economic Self Sufficiency Index at `ageTime', `g'"
		if "`indexType'" == "z_hc"  local title  "Human Capital Index at `ageTime', `g'" 
		if "`indexType'" == "z_dis" local title "Disability Index at `ageTime', `g'" 
		if "`indexType'" == "z_nei" local title "Living Quality Index at `ageTime'"	
		if "`indexType'" == "dis_7" local title "Share That Lived to 2000, `g'"
		if "`indexType'" == "dis_8" local title "Age at Death, `g'"
		if "`indexType'" == "dis_9" local title "Share That Lived to 2012, `g'"	
		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "tot_obs_dis_`g'"
		else local obs "tot_obs_`g'"
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		
		* outcome of interest for subgroup g 
		local outcome "mean_`indexType'_`g'_`ageTime'"

		* Identify sample for exposure models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(mean_`indexType'_`g'_`ageTime' shareFSPageIU_5 birthyr birthmo fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 )
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		di `nobs'
		
		* Mean of dependent variable,  1950-54 cohorts
		* We only have cohorts 1955+ so just do overall mean for now
		sum mean_`indexType'_`g'_`ageTime' [aw=`obs'] if sample==1
		local mdv = round(r(mean), .0001)
		
		* Run exposure model
		* Model 3 (preferred model) without survey year FE
		local r "replace"
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		reghdfe `outcome' shareFSPageIU_5 `trends' if sample==1 [aw=`obs'], absorb(fips state_year birthmo) vce(cluster fips) 
		local cells = round(`e(N)', 1000) 
		local R2 = round(`e(r2)', .0001)
		local counties = round(e(N_clust), 100)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(shareFSP*) ctitle("Exposure" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv',nobs,`nobs') ///
				addtext(Birth month, "Yes", Survey year,"No", ///
				State x Birth Year,"Yes", County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta	
		restore 
	
	}
	
	* Make table 	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 
	foreach g in all /*wm wf nm nf*/ {
		use $output/table_mean_`indexType'_`g'_`ageTime'_dta, clear 
		export excel using $output/`indexType'_`ageTime', sheet("`g'", replace )  
	}
	
end

capture program drop outputTablesAgeControls
program outputTablesAgeControls
syntax, [dataExposure(string) sample(int 100) indexType(string)]
	* First do exposure model specifications and then add event-study and spline due to different datasets 
	use if runiform() <= `sample'/100 using `dataExposure', clear

	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen state_year = group(st_fips birthyr)
	
	gen age = year - birthyr
	gen age_sq = age*age

	foreach g in all wm wf nm nf {
		
		* Table names 
		if "`indexType'" == "z_composite" local title "Composite Index, `g'"
		if "`indexType'" == "z_ess" local title "Economic Self Sufficiency Index, `g'"
		if "`indexType'" == "z_hc"  local title  "Human Capital Index, `g'" 
		if "`indexType'" == "z_dis" local title "Disability Index, `g'" 
		if "`indexType'" == "z_nei" local title "Living Quality Index"	
		if "`indexType'" == "dis_7" local title "Share That Lived to 2000, `g'"
		if "`indexType'" == "dis_8" local title "Age at Death, `g'"
		if "`indexType'" == "dis_9" local title "Share That Lived to 2012, `g'"	
		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		
		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"



		
		* Identify sample for exposure models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' shareFSPageIU_5 birthyr birthmo year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 )
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv = round(r(mean), .0001)
		
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 

		* Run exposure models
		local r "replace"
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		* Model 3 (preferred model)
		reghdfe `outcome' shareFSPageIU_5 age age_sq `trends'  if sample==1 [aw=`obs'] , absorb(fips state_year birthmo year) vce(cluster fips) 
		local cells = round(`e(N)', 1000) 
		local R2 = round(`e(r2)', .0001)
		local counties = round(e(N_clust), 100)
		outreg2 using "$output/table_`outcome'_age", `r' noparen noaster noobs nor2 ///
				keep(shareFSP*) ctitle("Exposure 3" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv, `mdv',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "Yes", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes", Age, "Yes", Age Squared, "Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta		
		restore 
	
	}
	
	* Make table 	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 
	foreach g in all wm wf nm nf {
		use $output/table_`indexType'_`g'_age_dta, clear 
		export excel using $output/`indexType'_age_controls, sheet("`g'", replace )  
	}
	
end

main
