clear all 
set more off 
set trace on
set tracedepth 2 
*set matsize 11000

*** This set of programs will produce all output necessary to replace
*** Survive to 2012 analysis with life expectancy LE3 outcome 
	
capture program drop main 
program define main 

	paths
	cap log close 
	log using "$results/mobility_final.log", replace

	*** Exposure, Event study, and spline models ***
	* Exposure model data 
	local data1 "$datatemp/fs_hsacr_1_newsub_exactmatch0.dta"
	local stayerData1 "$datatemp/fs_hsacr_1_newsub_exactmatch0_withStayers.dta" 
	* Eventstudy and spline data 
	local data2 "$datatemp/fs_dtacr_2_exactmatch0_newsub.dta"		
	local stayerData2 "$datatemp/fs_dtacr_2_exactmatch0_newsub_withStayers.dta"
	
	local sample = 100

	// merge on fs share variable for 0-5
	// Note: need to re-run if fs_dtacr... have been remade

//-----------------------------
// run first time after dataset is created 
// takes share FS age 0-5 from birthmonth dataset and collapses to birthyear

	use "`stayerData2'", clear 
	capture confirm variable FSshare6_18
	if (_rc!=0) {
	di _rc	
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	

	preserve
	use "$datatemp/fs_hsacr_1_newsub_exactmatch0_withStayers.dta", clear 
	gen fips = st_fips*1000+co_fips_1
	collapse (mean) shareFSPage0_5, by(birthyr fips)
	tempfile shares 
	save `shares'
	restore 
	
	preserve
	use "$datatemp/FSshare6_18.dta", clear // this is made in disclosure 20181010
	collapse (mean) FSshare6_18, by(birthyr fips)
	tempfile shares6_18 
	save `shares6_18'
	restore 
	
	merge m:1 fips birthyr using `shares', nogen
	merge m:1 fips birthyr using `shares6_18', nogen 
	
	drop fips 
	save "`stayerData2'", replace 
	
	}

// --------------------------------

// run using FSshare6_18 as sharevar

	* run for just Life Expectancy Measures 
	local shareVar2 "FSshare6_18"
	local shareVar "shareFSPage0_5"
	foreach o in LE3 {
		outputTablesLE, dataExposure(`stayerData1') dataEvent(`stayerData2') sample(`sample') indexType("`o'") shareVar("`shareVar'") shareVar2("`shareVar2'")
	}
	
	
// run for shareFSPage0_5 as sharevar
	* run for just Life Expectancy Measures 
	local shareVar "shareFSPage0_5"
	local shareVar2 ""
	foreach o in LE3  {
		outputTablesLE, dataExposure(`stayerData1') dataEvent(`stayerData2') sample(`sample') indexType("`o'") shareVar("`shareVar'") 
	}
	
	* Spline 5-17
	local vars LE3
	foreach o of local vars {
		spline5_17_LE, data(`stayerData2') indexType("`o'") sample(`sample') 
	}

	
end 

capture program drop paths
program define paths
	
	global datatemp"/projects/programs/foodstamps/master_folder/datatemp"
	global output "/projects/programs/foodstamps/master_folder/RESTUD_2021/output/LE"
	global data "/projects/data"		// project-wide data 
	global countydata "/projects/data/countyLevel"
	global empData "/projects/programs/rwalker/chris/dataSTATA"
	global results "/projects/programs/foodstamps/master_folder/RESTUD_2021/output/LE"

end 

/******************************************************************************
* outputTablesLE
*
* Produces tables for food stamp exposure, spline and event-study models.
* Specific to Life Expectancy estimates 
* 
*
*******************************************************************************/ 

capture program drop outputTablesLE
program define outputTablesLE
syntax, [dataExposure(string) dataEvent(string)  sample(int 100) indexType(string) shareVar(string) shareVar2(string)]

	* First do exposure model specifications and then add event-study and spline due to different datasets 
	use if runiform() <= `sample'/100 using `dataEvent', clear

	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1	
	sort fips birthyr
	egen state_year = group(st_fips birthyr)

	foreach g in all wm wf nm nf {
		
		*** Table names 
		if "`indexType'" == "z_composite" local title "Composite Index, `g'"
		if "`indexType'" == "z_ess" local title "Economic Self Sufficiency Index, `g'"
		if "`indexType'" == "z_hc"  local title  "Human Capital Index, `g'" 
		if "`indexType'" == "z_dis" local title "Disability Index, `g'" 
		if "`indexType'" == "z_nei" local title "Living Quality Index"	
		if "`indexType'" == "dis_7" local title "Share That Lived to 2000, `g'"
		if "`indexType'" == "dis_8" local title "Age at Death, `g'"
		if "`indexType'" == "dis_9" local title "Share That Lived to 2012, `g'"	
		if "`indexType'" == "LE" local title "Life Expectancy, `g'"
		if "`indexType'" == "LE_chetty" local title "Chetty Life Expectancy, `g'"	

		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		*** LE weights using cohort size
		if "`indexType'_`g'"=="LE1_`g'" local obs "obs_LE1_`g'"
		if "`indexType'_`g'"=="LE2_`g'" local obs "obs_LE2_`g'"
		if "`indexType'_`g'"=="LE3_`g'" local obs "obs_LE3_`g'"
		if "`indexType'_`g'"=="LE4_`g'" local obs "obs_LE4_`g'"
		if "`indexType'_`g'"=="LE4_`g'"{
			drop if LE4_all>100
			}
		if "`indexType'_`g'"=="LE_chetty`g'" local obs "obs_dis_`g'"
		
		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"

		* Identify sample for exposure models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' `shareVar' `shareVar2' birthyr year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 )
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable
		sum `indexType'_`g' [aw=`obs'] if sample==1
		local mdv = round(r(mean), .0001)
		local sd = round(r(sd), .0001)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv5054 = round(r(mean), .0001)
		
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 

		* Run exposure models
		local r "replace"  
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"
		if "`g'" == "all"{
			reghdfe `outcome' `shareVar' `shareVar2' if sample==1 [aw=`obs'], absorb(fips birthyr year) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = round(e(N_clust), 100)
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(`shareVar' `shareVar2') ctitle("Model 1") ///
				adds(Cells, `cells', R squared, `R2', Counties, `counties', mdv,`mdv',sd,`sd', nobs, `nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				title("`title'") dec(4) bdec(4) sdec(4) fmt(g) dta
			local r "append"
		}
		if "`g'" == "all"{
		reghdfe `outcome' `shareVar' `shareVar2' `trends'  if sample==1 [aw=`obs'] , absorb(fips birthyr year) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
		local counties = round(e(N_clust), 100)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(`shareVar' `shareVar2') ctitle("Model 2" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv,`mdv',sd,`sd', nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
				
		local r "append" 
		}
		reghdfe `outcome' `shareVar' `shareVar2' `trends'  if sample==1 [aw=`obs'] , absorb(fips state_year year) vce(cluster fips) 
		local cells = round(`e(N)', 1000) 
		local R2 = round(`e(r2)', .0001)
		local counties = round(e(N_clust), 100)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(`shareVar' `shareVar2') ctitle("Model 3" ) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', mdv,`mdv',sd,`sd', nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				title("`title'") dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta		
		restore 
	
	}
	
		
	*** Estimate event-study and spline models using other data 
	use if runiform() <= `sample'/100 using `dataEvent', clear 	 
	keep if inrange(birthyr,1950,1980)

	* Create fips for clustering
	capture drop fips
	gen fips = st_fips*1000+co_fips_1
	sort fips birthyr
	egen inNumidentSamp=tag(fips birthyr)
	replace inNumidentSamp=. if fips==. | !inrange(birthyr,1950,1980)
	egen state_year = group(st_fips birthyr)	
	
	foreach g in all wm wf nm nf{
		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		*** LE weights using cohort size
		if "`indexType'_`g'"=="LE1_`g'" local obs "obs_LE1_`g'"
		if "`indexType'_`g'"=="LE2_`g'" local obs "obs_LE2_`g'"
		if "`indexType'_`g'"=="LE3_`g'" local obs "obs_LE3_`g'"
		if "`indexType'_`g'"=="LE4_`g'" local obs "obs_LE4_`g'"
		if "`indexType'_`g'"=="LE4_`g'"{
			drop if LE4_all>100
			}
		if "`indexType'_`g'"=="LE_chetty`g'" local obs "obs_dis_`g'"
		
		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"
		
		* Identify sample for event study/spline models 
		preserve 
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' birthyr year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 _TB_exp_*)
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv = r(mean)
		
		* Run event study models	
		*Order of models 
		* 0. birthyr year (w/o trends) 
		* 1. state_year year (w/o trends) * in subgroup  
		* 2. year birthyr (w trends) 
		* 3. state_year year (w trends) * in subgroup 
		rename _TB_exp_* TB_exp_*
		local r "append"
		if "`g'" == "all"{
			reghdfe `outcome' TB_exp_*    if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = round(e(N_clust), 100)
			test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		}
		reghdfe `outcome' TB_exp_*  if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
		local counties = round(e(N_clust), 100)
		test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes",  ///
				State x Birth Year,"Yes",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		if "`g'" == "all"{
			reghdfe `outcome' TB_exp_* `trends'  if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year) vce(cluster fips) 
			local cells = round(`e(N)', 1000)
			local R2 = round(`e(r2)', .0001)
			local counties = round(e(N_clust), 100)
			test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
			outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		}	
		reghdfe `outcome' TB_exp_* `trends'  if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year  ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
		local counties = round(e(N_clust), 100)
		test TB_exp_3 TB_exp_4 TB_exp_5 TB_exp_6
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(*exp*) ctitle(Event Study 0) ///
				addstat(Cells, `cells', R squared, `R2', Counties , `counties', k, `e(df_m)',F,`r(F)',df,`r(df)',p,`r(p)',nobs,`nobs') ///
				addtext(Birth year,"No", Birth month, "No", Survey year,"Yes",  ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
				
		restore
	}
	
	* Make table 	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 
	capture foreach g in all wm wf nm nf {
		use $output/table_`indexType'_`g'_dta, clear 
		export excel using $results/tarduno/`indexType'_`shareVar2'_outputTables, sheet("`g'", replace )  
	}
	
end 



capture program drop spline5_17_LE
program define spline5_17_LE
syntax, [data(string) sample(int 100) indexType(string)]

	use if runiform() <= `sample'/100 using `data', clear 	 
	keep if inrange(birthyr,1950,1980)
	* Create fips for clusteringshareFSPageIU_5
	capture drop fips
	gen fips = st_fips*1000+co_fips_1
	sort fips birthyr
	egen inNumidentSamp=tag(fips birthyr)
	replace inNumidentSamp=. if fips==. | !inrange(birthyr,1950,1980)
	egen state_year = group(st_fips birthyr)	

		
	* Some modifications to certain indices 
	if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
		* These observations are at the county/birth-month level. No survey-year variation.
		* So get rid of the extra survey years of data
		egen tag = tag(fips birthyr  exactmatch)
		tab birthyr tag, m
		tab year tag, m
		keep if tag==1 & exactmatch==0
		drop tag
	} 


	
	* make new spline 
	mkspline spline2_1 -2 spline2_2 5 spline2_3 11 spline2_4 = exp
	replace spline2_1=0 if !inrange(exp,-5,17) & exp != .
	replace spline2_2=0 if !inrange(exp,-5,17) & exp != .
	replace spline2_3=0 if !inrange(exp,-5,17) & exp != .
	replace spline2_4=0 if !inrange(exp,-5,17) & exp != .



	foreach g in all wm wf nm nf{
	
		*** Set weights 
		if "`indexType'_`g'"=="z_dis_`g'" local obs "obs_dis_`g'"
		else local obs "obs_`g'"
		* Specific weights for these indices 
		if "`indexType'" == "dis_7" | "`indexType'" == "dis_8" | "`indexType'" == "dis_9" {
			if "`indexType'_`g'"=="dis_8_`g'" local obs "num_deaths_`g'"
			else local obs "num_births_`g'"
		}
		*** LE weights using cohort size
		if "`indexType'_`g'"=="LE1_`g'" local obs "obs_LE1_`g'"
		if "`indexType'_`g'"=="LE2_`g'" local obs "obs_LE2_`g'"
		if "`indexType'_`g'"=="LE3_`g'" local obs "obs_LE3_`g'"
		if "`indexType'_`g'"=="LE4_`g'" local obs "obs_LE4_`g'"
		if "`indexType'_`g'"=="LE4_`g'"{
			drop if LE4_all>100
			}
		if "`indexType'_`g'"=="LE_chetty`g'" local obs "obs_dis_`g'"
		

		* outcome of interest for subgroup g 
		local outcome "`indexType'_`g'"
		* Identify sample for event study/spline models 
		preserve 
		
		cap drop sample
		egen tmp = rowmiss(`indexType'_`g' birthyr year fips `obs' lpop60 inc3k60 urban60 black60 age560 age6560 farmlandpct60 _TB_exp_*)
		gen sample = tmp==0
		tab sample tmp, m			// Total county/birth year/survey year cells
		tabstat `obs', by(sample) stats(sum)	// Total underlying individual observations
		drop tmp
		
		* Capture number of underlying observations and round 			
		sum `obs' if sample==1
		local nobs = round(r(sum), 1000)
		
		* Mean of dependent variable, 1950-54 cohorts
		sum `indexType'_`g' [aw=`obs'] if inrange(birthyr,1950,1954) & sample==1	
		local mdv = r(mean)
		
		* Run spline models
		/*
		local nonparam1 "TB_exp_1-TB_exp_2 TB_exp_19-TB_exp_25"
		local LSRvars "`nonparam1' spline1_1 spline1_2 spline1_3"					
		reghdfe `outcome' `LSRvars'  `trends' if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year  ) vce(cluster fips) 
		local cells = round(`e(N)', 1000)
		local R2 = round(`e(r2)', .0001)
		local counties = round(e(N_clust), 100)
		outreg2 using "$output/table_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Spline 1") ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"Yes", Birth month, "No", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		*/	
			rename _TB_exp_* TB_exp_*
	
		local nonparam1 "TB_exp_1 TB_exp_25"
		local LSRvars "`nonparam1' spline2_1 spline2_2 spline2_3 spline2_4"	
		local trends "c.birthyr#(c.lpop60 c.inc3k60 c.urban60 c.black60 c.age560 c.age6560)"

		local r "replace"
		if "`g'"=="all"{
		  reghdfe `outcome' `LSRvars' if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year  ) vce(cluster fips) 
		  local cells = round(`e(N)', 1000)
		  local R2 = round(`e(r2)', .0001)
		  local counties = round(e(N_clust), 100)
		  outreg2 using "$output/splinem5_p17_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Model 1") ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"No") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		  local r "append"	
		  reghdfe `outcome' `LSRvars'  `trends' if exp!=. & sample==1 [pw=`obs'], absorb(fips birthyr year  ) vce(cluster fips) 
		  local cells = round(`e(N)', 1000)
		  local R2 = round(`e(r2)', .0001)
		  local counties = round(e(N_clust), 100)
		  outreg2 using "$output/splinem5_p17_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Model 2")  ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"Yes", Survey year,"Yes", ///
				State x Birth Year,"No",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta
		  local r "append"
		 }
		 reghdfe `outcome' `LSRvars'  `trends' if exp!=. & sample==1 [pw=`obs'], absorb(fips state_year year  ) vce(cluster fips) 
		 local cells = round(`e(N)', 1000)
		 local R2 = round(`e(r2)', .0001)
		 local counties = round(e(N_clust), 100)
		 outreg2 using "$output/splinem5_p17_`outcome'", `r' noparen noaster noobs nor2 ///
				keep(spline*) ctitle("Model 3") ///
				addstat(Cells, `cells', R squared, `R2', Counties, `counties', k, `e(df_m)', nobs,`nobs') ///
				addtext(Birth year,"No", Survey year,"Yes", ///
				State x Birth Year,"Yes",County Char Trends,"Yes") ///
				dec(4) bdec(4) sdec(4) rdec(4) fmt(g) dta	
		restore 	
	}	
	
	* Now save each onto a different sheet within an excel file
	*capture erase $output/table_`indexType'_`g'_dta.dta 
	foreach g in all wm wf nm nf {
		use $output/splinem5_p17_`indexType'_`g'_dta, clear 
		export excel using $results/spline/splinem5_p17_`indexType', sheet("`g'", replace )  
	}
end


main
