#------------- Siqueira et al -------------#
#-- Evolution of fish-coral interactions --#
#------------ RevBayes ModComp-------------#

#----- Setting WD -----#
wd <- "XXX"   #Set your personal working directory here
setwd(wd)


#----- Loading the Marginal Likelihood values -----#
ss_marginal_muhisse <- as.numeric(readLines("RevBayes/MuHiSSE/output/Mod_comp/MuHiSSE_ssMarginal.txt", warn = FALSE)) #-17558.79 - From the file MuHiSSE_ssMarginal

ss_marginal_cid <- as.numeric(readLines("RevBayes/CID/output/Mod_comp/CID_ssMarginal.txt", warn = FALSE))             #-17563.46 - From the file CID_ssMarginal

ss_marginal_musse <- as.numeric(readLines("RevBayes/MuSSE/output/Mod_comp/MuSSE_ssMarginal.txt", warn = FALSE))       #-17648.86 - From the file MuSSE_ssMarginal


### Calculating Bayes factors between models
# BF = MarginalLikelihood_M0 - MarginalLikelihood_M1 - Check table at https://revbayes.github.io/tutorials/model_selection_bayes_factors/bf_intro.html for strengh of evidence

BF_muhisseXmusse <- ss_marginal_muhisse - ss_marginal_musse #90.07 decisive support for muhisse
BF_musseXcid <- ss_marginal_cid - ss_marginal_musse         #85.4 decisive support for cid
BF_muhisseXcid <- ss_marginal_muhisse - ss_marginal_cid     #4.67 decisive support for muhisse


BF_muhisseXmusse
BF_musseXcid
BF_muhisseXcid

## MuHiSSE model has decisive support over all other models